/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.process.destruct;

import mods.eln.Eln;
import mods.eln.misc.Utils;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.ranges.RangesKt;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.IProcess;
import mods.eln.sim.process.destruct.IDestructible;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001b\u001a\u00020\rH&J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\rH\u0016J\u0006\u0010\u001f\u001a\u00020\u001dJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0015\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011R\u001a\u0010\u0018\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000f\"\u0004\b\u001a\u0010\u0011\u00a8\u0006!"}, d2={"Lmods/eln/sim/process/destruct/ValueWatchdog;", "Lmods/eln/sim/IProcess;", "()V", "boot", "", "getBoot", "()Z", "setBoot", "(Z)V", "destructible", "Lmods/eln/sim/process/destruct/IDestructible;", "joker", "max", "", "getMax", "()D", "setMax", "(D)V", "min", "getMin", "setMin", "timeout", "getTimeout", "setTimeout", "timeoutReset", "getTimeoutReset", "setTimeoutReset", "getValue", "process", "", "time", "reset", "setDestroys", "Eln"})
public abstract class ValueWatchdog
implements IProcess {
    @Nullable
    private IDestructible destructible;
    private double min;
    private double max;
    private double timeoutReset = 2.0;
    private double timeout;
    private boolean boot = true;
    private boolean joker = true;

    public final double getMin() {
        return this.min;
    }

    public final void setMin(double d) {
        this.min = d;
    }

    public final double getMax() {
        return this.max;
    }

    public final void setMax(double d) {
        this.max = d;
    }

    public final double getTimeoutReset() {
        return this.timeoutReset;
    }

    public final void setTimeoutReset(double d) {
        this.timeoutReset = d;
    }

    public final double getTimeout() {
        return this.timeout;
    }

    public final void setTimeout(double d) {
        this.timeout = d;
    }

    public final boolean getBoot() {
        return this.boot;
    }

    public final void setBoot(boolean bl) {
        this.boot = bl;
    }

    @Override
    public void process(double time) {
        block8: {
            double value;
            double overflow;
            if (this.boot) {
                this.boot = false;
                this.timeout = this.timeoutReset;
            }
            if ((overflow = RangesKt.coerceAtLeast((value = this.getValue()) - this.max, this.min - value)) > 0.0) {
                if (this.joker) {
                    this.joker = false;
                    overflow = 0.0;
                }
            } else {
                this.joker = true;
            }
            this.timeout -= time * overflow * Utils.rand(0.5, 1.5);
            if (this.timeout > this.timeoutReset) {
                this.timeout = this.timeoutReset;
            }
            if (!(this.timeout < 0.0)) break block8;
            Object[] objectArray = new Object[2];
            objectArray[0] = this.getClass().getName();
            Object object = this.destructible;
            if (object == null || (object = object.describe()) == null) {
                object = "Null destructible";
            }
            objectArray[1] = object;
            Utils.println("%s destroying %s", objectArray);
            if (!Eln.debugExplosions) {
                IDestructible iDestructible = this.destructible;
                if (iDestructible != null) {
                    iDestructible.destructImpl();
                }
            }
        }
    }

    @NotNull
    public final ValueWatchdog setDestroys(@NotNull IDestructible destructible) {
        Intrinsics.checkNotNullParameter(destructible, "destructible");
        this.destructible = destructible;
        return this;
    }

    public abstract double getValue();

    public final void reset() {
        this.boot = true;
    }
}

