/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sim.process.heater;

import mods.eln.misc.Utils;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lmods/eln/sim/process/heater/ElectricalLoadHeatThermalLoad;", "Lmods/eln/sim/IProcess;", "resistor", "Lmods/eln/sim/ElectricalLoad;", "load", "Lmods/eln/sim/ThermalLoad;", "(Lmods/eln/sim/ElectricalLoad;Lmods/eln/sim/ThermalLoad;)V", "getLoad", "()Lmods/eln/sim/ThermalLoad;", "setLoad", "(Lmods/eln/sim/ThermalLoad;)V", "getResistor", "()Lmods/eln/sim/ElectricalLoad;", "setResistor", "(Lmods/eln/sim/ElectricalLoad;)V", "process", "", "time", "", "Eln"})
public final class ElectricalLoadHeatThermalLoad
implements IProcess {
    @NotNull
    private ElectricalLoad resistor;
    @NotNull
    private ThermalLoad load;

    public ElectricalLoadHeatThermalLoad(@NotNull ElectricalLoad resistor, @NotNull ThermalLoad load) {
        Intrinsics.checkNotNullParameter(resistor, "resistor");
        Intrinsics.checkNotNullParameter(load, "load");
        this.resistor = resistor;
        this.load = load;
    }

    @NotNull
    public final ElectricalLoad getResistor() {
        return this.resistor;
    }

    public final void setResistor(@NotNull ElectricalLoad electricalLoad) {
        Intrinsics.checkNotNullParameter(electricalLoad, "<set-?>");
        this.resistor = electricalLoad;
    }

    @NotNull
    public final ThermalLoad getLoad() {
        return this.load;
    }

    public final void setLoad(@NotNull ThermalLoad thermalLoad) {
        Intrinsics.checkNotNullParameter(thermalLoad, "<set-?>");
        this.load = thermalLoad;
    }

    @Override
    public void process(double time) {
        if (this.resistor.isNotSimulated()) {
            return;
        }
        double current = this.resistor.getCurrent();
        Utils.println("Moving heat: " + current * current * this.resistor.getSerialResistance() * (double)2 + " watts at " + this.resistor + ' ' + this.load);
        this.load.movePowerTo(current * current * this.resistor.getSerialResistance() * (double)2);
    }
}

