/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.simplenode.computerprobe;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import mods.eln.Eln;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.simple.SimpleNode;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalGateInputOutput;
import mods.eln.sim.nbt.NbtElectricalGateOutputProcess;
import mods.eln.sixnode.wirelesssignal.IWirelessSignalSpot;
import mods.eln.sixnode.wirelesssignal.IWirelessSignalTx;
import mods.eln.sixnode.wirelesssignal.WirelessUtils;
import mods.eln.sixnode.wirelesssignal.aggregator.BiggerAggregator;
import mods.eln.sixnode.wirelesssignal.aggregator.IWirelessSignalAggregator;
import mods.eln.sixnode.wirelesssignal.aggregator.SmallerAggregator;
import mods.eln.sixnode.wirelesssignal.tx.WirelessSignalTxElement;
import net.minecraft.nbt.NBTTagCompound;

@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")
public class ComputerProbeNode
extends SimpleNode
implements IPeripheral {
    public NbtElectricalGateInputOutput[] ioGate = new NbtElectricalGateInputOutput[6];
    public NbtElectricalGateOutputProcess[] ioGateProcess = new NbtElectricalGateOutputProcess[6];
    double spotTimeout = 0.0;
    IWirelessSignalSpot spot;
    HashMap<String, HashSet<IWirelessSignalTx>> txSet = new HashMap();
    HashMap<IWirelessSignalTx, Double> txStrength = new HashMap();
    HashMap<String, WirelessTx> wirelessTxMap = new HashMap();
    String[] functionNames = new String[]{"signalSetDir", "signalGetDir", "signalSetOut", "signalGetOut", "signalGetIn", "wirelessSet", "wirelessRemove", "wirelessRemoveAll", "wirelessGet"};

    @Override
    public void initialize() {
        this.slowProcessList.add(new SlowProcess());
        for (int idx = 0; idx < 6; ++idx) {
            this.ioGate[idx] = new NbtElectricalGateInputOutput("ioGate" + idx);
            this.ioGateProcess[idx] = new NbtElectricalGateOutputProcess("ioGateProcess" + idx, this.ioGate[idx]);
            this.electricalLoadList.add(this.ioGate[idx]);
            this.electricalComponentList.add(this.ioGateProcess[idx]);
            this.ioGateProcess[idx].setHighImpedance(true);
        }
        this.connect();
    }

    double wirelessRead(String channel, String aggregatorName) {
        if (this.spot == null) {
            this.spot = WirelessUtils.buildSpot(this.coordinate, null, 0);
            this.txSet.clear();
            this.txStrength.clear();
            WirelessUtils.getTx(this.spot, this.txSet, this.txStrength);
            this.spotTimeout = Utils.rand(1.0, 2.0);
        }
        IWirelessSignalAggregator aggregator = new BiggerAggregator();
        if (aggregatorName.equals("bigger")) {
            aggregator = new BiggerAggregator();
        }
        if (aggregatorName.equals("smaller")) {
            aggregator = new SmallerAggregator();
        }
        return aggregator.aggregate((Collection<IWirelessSignalTx>)this.txSet.get(channel));
    }

    @Override
    public void onBreakBlock() {
        super.onBreakBlock();
        this.unregister();
    }

    @Override
    public void unload() {
        super.unload();
        this.unregister();
    }

    void unregister() {
        for (WirelessTx tx : this.wirelessTxMap.values()) {
            WirelessSignalTxElement.channelRemove(tx);
        }
    }

    @Override
    public int getSideConnectionMask(Direction side, LRDU lrduA) {
        return 4;
    }

    @Override
    public ThermalLoad getThermalLoad(Direction side, LRDU lrduA, int mask) {
        return null;
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrduB, int mask) {
        return this.ioGate[side.getInt()];
    }

    @Override
    public String getNodeUuid() {
        return ComputerProbeNode.getNodeUuidStatic();
    }

    public static String getNodeUuidStatic() {
        return "ElnComputerProbe";
    }

    public Object[] signalSetDir(Direction side, boolean highImpedance) {
        this.ioGateProcess[side.getInt()].setHighImpedance(highImpedance);
        Utils.println(this.ioGateProcess[side.getInt()].isHighImpedance());
        return null;
    }

    public Object[] signalGetDir(Direction side) {
        return new Object[]{this.ioGateProcess[side.getInt()].isHighImpedance() ? "in" : "out"};
    }

    public Object[] signalSetOut(Direction side, double value) {
        this.ioGateProcess[side.getInt()].setOutputNormalized(value);
        return null;
    }

    public Object[] signalGetOut(Direction side) {
        return new Object[]{this.ioGateProcess[side.getInt()].getOutputNormalized()};
    }

    public Object[] signalGetIn(Direction side) {
        return new Object[]{this.ioGate[side.getInt()].getInputNormalized()};
    }

    public Object[] wirelessSet(String channel, double value) {
        WirelessTx tx = this.wirelessTxMap.get(channel);
        if (tx == null) {
            tx = new WirelessTx();
            tx.channel = channel;
            WirelessSignalTxElement.channelRegister(tx);
            this.wirelessTxMap.put(channel, tx);
        }
        tx.value = value;
        return null;
    }

    public Object[] wirelessRemove(String channel) {
        WirelessTx tx = this.wirelessTxMap.get(channel);
        if (tx != null) {
            WirelessSignalTxElement.channelRemove(tx);
            this.wirelessTxMap.remove(channel);
        }
        return null;
    }

    public Object[] wirelessRemoveAll() {
        for (WirelessTx tx : this.wirelessTxMap.values()) {
            WirelessSignalTxElement.channelRemove(tx);
        }
        this.wirelessTxMap.clear();
        return null;
    }

    public Object[] wirelessGet(String channel, String aggregation) {
        return new Object[]{this.wirelessRead(channel, aggregation)};
    }

    @Optional.Method(modid="OpenComputers")
    public Object[] signalSetDir(Context context, Arguments args2) {
        Direction side = Direction.valueOf(args2.checkString(0));
        boolean highImpedance = args2.checkString(1).equals("in");
        return this.signalSetDir(side, highImpedance);
    }

    @Optional.Method(modid="OpenComputers")
    public Object[] signalGetDir(Context context, Arguments args2) {
        Direction side = Direction.valueOf(args2.checkString(0));
        return this.signalGetDir(side);
    }

    @Optional.Method(modid="OpenComputers")
    public Object[] signalSetOut(Context context, Arguments args2) {
        Direction side = Direction.valueOf(args2.checkString(0));
        double value = args2.checkDouble(1);
        return this.signalSetOut(side, value);
    }

    @Optional.Method(modid="OpenComputers")
    public Object[] signalGetOut(Context context, Arguments args2) {
        Direction side = Direction.valueOf(args2.checkString(0));
        return this.signalGetOut(side);
    }

    @Optional.Method(modid="OpenComputers")
    public Object[] signalGetIn(Context context, Arguments args2) {
        Direction side = Direction.valueOf(args2.checkString(0));
        return this.signalGetIn(side);
    }

    @Optional.Method(modid="OpenComputers")
    public Object[] wirelessSet(Context context, Arguments args2) {
        String channel = args2.checkString(0);
        double value = args2.checkDouble(1);
        return this.wirelessSet(channel, value);
    }

    @Optional.Method(modid="OpenComputers")
    public Object[] wirelessRemove(Context context, Arguments args2) {
        String channel = args2.checkString(0);
        return this.wirelessRemove(channel);
    }

    @Optional.Method(modid="OpenComputers")
    public Object[] wirelessRemoveAll(Context context, Arguments args2) {
        return this.wirelessRemoveAll();
    }

    @Optional.Method(modid="OpenComputers")
    public Object[] wirelessGet(Context context, Arguments args2) {
        String channel = args2.checkString(0);
        String aggregation = "bigger";
        if (args2.count() == 2) {
            aggregation = args2.checkString(1);
        }
        return this.wirelessGet(channel, aggregation);
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return "ElnProbe";
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return this.functionNames;
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] args2) throws LuaException, InterruptedException {
        try {
            if (method < 0 || method >= this.functionNames.length) {
                return null;
            }
            switch (method) {
                case 0: {
                    return this.signalSetDir(Direction.valueOf((String)args2[0]), args2[1].equals("in"));
                }
                case 1: {
                    return this.signalGetDir(Direction.valueOf((String)args2[0]));
                }
                case 2: {
                    return this.signalSetOut(Direction.valueOf((String)args2[0]), (Double)args2[1]);
                }
                case 3: {
                    return this.signalGetOut(Direction.valueOf((String)args2[0]));
                }
                case 4: {
                    return this.signalGetIn(Direction.valueOf((String)args2[0]));
                }
                case 5: {
                    return this.wirelessSet((String)args2[0], (Double)args2[1]);
                }
                case 6: {
                    return this.wirelessRemove((String)args2[0]);
                }
                case 7: {
                    return this.wirelessRemoveAll();
                }
                case 8: {
                    String aggregation = "bigger";
                    if (args2.length == 2) {
                        aggregation = (String)args2[1];
                    }
                    return this.wirelessGet((String)args2[0], aggregation);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
        Utils.println("CC attache");
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
        Utils.println("CC detach");
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return this == other;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74768_a("wirelessTxCount", this.wirelessTxMap.size());
        int idx = 0;
        for (WirelessTx tx : this.wirelessTxMap.values()) {
            nbt.func_74778_a("wirelessTx" + idx + "channel", tx.channel);
            nbt.func_74780_a("wirelessTx" + idx + "value", tx.value);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        int wirelessTxCount = nbt.func_74762_e("wirelessTxCount");
        for (int idx = 0; idx < wirelessTxCount; ++idx) {
            WirelessTx tx = new WirelessTx();
            tx.channel = nbt.func_74779_i("wirelessTx" + idx + "channel");
            tx.value = nbt.func_74769_h("wirelessTx" + idx + "value");
            WirelessSignalTxElement.channelRegister(tx);
            this.wirelessTxMap.put(tx.channel, tx);
        }
    }

    class SlowProcess
    implements IProcess {
        SlowProcess() {
        }

        @Override
        public void process(double time) {
            if (ComputerProbeNode.this.spot != null) {
                ComputerProbeNode.this.spotTimeout -= time;
                if (ComputerProbeNode.this.spotTimeout < 0.0) {
                    ComputerProbeNode.this.spot = null;
                    ComputerProbeNode.this.txSet.clear();
                    ComputerProbeNode.this.txStrength.clear();
                }
            }
        }
    }

    class WirelessTx
    implements IWirelessSignalTx {
        String channel;
        double value;

        WirelessTx() {
        }

        @Override
        public Coordinate getCoordinate() {
            return ComputerProbeNode.this.coordinate;
        }

        @Override
        public int getRange() {
            return Eln.wirelessTxRange;
        }

        @Override
        public String getChannel() {
            return this.channel;
        }

        @Override
        public double getValue() {
            return this.value;
        }
    }
}

