/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.simplenode.energyconverter;

import java.util.Collection;
import java.util.List;
import mods.eln.gui.GuiButtonEln;
import mods.eln.gui.GuiHelper;
import mods.eln.gui.GuiScreenEln;
import mods.eln.gui.GuiTextFieldEln;
import mods.eln.gui.GuiVerticalTrackBar;
import mods.eln.gui.IGuiObject;
import mods.eln.misc.Utils;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.collections.CollectionsKt;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.kotlin.math.MathKt;
import mods.eln.shadow.kotlin.text.StringsKt;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.simplenode.energyconverter.EnergyConverterElnToOtherEntity;
import mods.eln.simplenode.energyconverter.NetworkType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020,H\u0016J\b\u00100\u001a\u000201H\u0014J \u00102\u001a\u00020,2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000206H\u0014J\u000e\u00108\u001a\u0002042\u0006\u00109\u001a\u00020\u001bJ\u000e\u0010:\u001a\u00020\u001b2\u0006\u0010;\u001a\u000204J\u0006\u0010<\u001a\u00020,R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\nR\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\nR\"\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010\u0004R\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u0006="}, d2={"Lmods/eln/simplenode/energyconverter/EnergyConverterElnToOtherGui;", "Lmods/eln/gui/GuiScreenEln;", "render", "Lmods/eln/simplenode/energyconverter/EnergyConverterElnToOtherEntity;", "(Lmods/eln/simplenode/energyconverter/EnergyConverterElnToOtherEntity;)V", "ic2tier1", "Lmods/eln/gui/GuiButtonEln;", "getIc2tier1", "()Lmods/eln/gui/GuiButtonEln;", "setIc2tier1", "(Lmods/eln/gui/GuiButtonEln;)V", "ic2tier2", "getIc2tier2", "setIc2tier2", "ic2tier3", "getIc2tier3", "setIc2tier3", "ic2tier4", "getIc2tier4", "setIc2tier4", "ic2tierList", "", "getIc2tierList", "()Ljava/util/List;", "setIc2tierList", "(Ljava/util/List;)V", "maxResistance", "", "powerEntry", "Lmods/eln/gui/GuiTextFieldEln;", "getPowerEntry", "()Lmods/eln/gui/GuiTextFieldEln;", "setPowerEntry", "(Lmods/eln/gui/GuiTextFieldEln;)V", "getRender", "()Lmods/eln/simplenode/energyconverter/EnergyConverterElnToOtherEntity;", "setRender", "resistanceSelector", "Lmods/eln/gui/GuiVerticalTrackBar;", "getResistanceSelector", "()Lmods/eln/gui/GuiVerticalTrackBar;", "setResistanceSelector", "(Lmods/eln/gui/GuiVerticalTrackBar;)V", "guiObjectEvent", "", "guiObject", "Lmods/eln/gui/IGuiObject;", "initGui", "newHelper", "Lmods/eln/gui/GuiHelper;", "preDraw", "f", "", "x", "", "y", "selectedResistanceToSlider", "selectedResistance", "sliderToSelectedResistance", "slider", "syncVoltage", "Eln"})
@SourceDebugExtension(value={"SMAP\nEnergyConverterElnToOtherGui.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnergyConverterElnToOtherGui.kt\nmods/eln/simplenode/energyconverter/EnergyConverterElnToOtherGui\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n37#2,2:108\n1864#3,3:110\n*S KotlinDebug\n*F\n+ 1 EnergyConverterElnToOtherGui.kt\nmods/eln/simplenode/energyconverter/EnergyConverterElnToOtherGui\n*L\n48#1:108,2\n55#1:110,3\n*E\n"})
public final class EnergyConverterElnToOtherGui
extends GuiScreenEln {
    @NotNull
    private EnergyConverterElnToOtherEntity render;
    @Nullable
    private GuiVerticalTrackBar resistanceSelector;
    @Nullable
    private GuiButtonEln ic2tier1;
    @Nullable
    private GuiButtonEln ic2tier2;
    @Nullable
    private GuiButtonEln ic2tier3;
    @Nullable
    private GuiButtonEln ic2tier4;
    @Nullable
    private GuiTextFieldEln powerEntry;
    private final double maxResistance;
    @Nullable
    private List<? extends GuiButtonEln> ic2tierList;

    public EnergyConverterElnToOtherGui(@NotNull EnergyConverterElnToOtherEntity render) {
        Intrinsics.checkNotNullParameter(render, "render");
        this.render = render;
        this.maxResistance = 100000.0;
    }

    @NotNull
    public final EnergyConverterElnToOtherEntity getRender() {
        return this.render;
    }

    public final void setRender(@NotNull EnergyConverterElnToOtherEntity energyConverterElnToOtherEntity) {
        Intrinsics.checkNotNullParameter(energyConverterElnToOtherEntity, "<set-?>");
        this.render = energyConverterElnToOtherEntity;
    }

    @Nullable
    public final GuiVerticalTrackBar getResistanceSelector() {
        return this.resistanceSelector;
    }

    public final void setResistanceSelector(@Nullable GuiVerticalTrackBar guiVerticalTrackBar) {
        this.resistanceSelector = guiVerticalTrackBar;
    }

    @Nullable
    public final GuiButtonEln getIc2tier1() {
        return this.ic2tier1;
    }

    public final void setIc2tier1(@Nullable GuiButtonEln guiButtonEln) {
        this.ic2tier1 = guiButtonEln;
    }

    @Nullable
    public final GuiButtonEln getIc2tier2() {
        return this.ic2tier2;
    }

    public final void setIc2tier2(@Nullable GuiButtonEln guiButtonEln) {
        this.ic2tier2 = guiButtonEln;
    }

    @Nullable
    public final GuiButtonEln getIc2tier3() {
        return this.ic2tier3;
    }

    public final void setIc2tier3(@Nullable GuiButtonEln guiButtonEln) {
        this.ic2tier3 = guiButtonEln;
    }

    @Nullable
    public final GuiButtonEln getIc2tier4() {
        return this.ic2tier4;
    }

    public final void setIc2tier4(@Nullable GuiButtonEln guiButtonEln) {
        this.ic2tier4 = guiButtonEln;
    }

    @Nullable
    public final GuiTextFieldEln getPowerEntry() {
        return this.powerEntry;
    }

    public final void setPowerEntry(@Nullable GuiTextFieldEln guiTextFieldEln) {
        this.powerEntry = guiTextFieldEln;
    }

    @Nullable
    public final List<GuiButtonEln> getIc2tierList() {
        return this.ic2tierList;
    }

    public final void setIc2tierList(@Nullable List<? extends GuiButtonEln> list) {
        this.ic2tierList = list;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        GuiVerticalTrackBar guiVerticalTrackBar = this.resistanceSelector = this.newGuiVerticalTrackBar(6, 8, 20, 82);
        Intrinsics.checkNotNull(guiVerticalTrackBar);
        guiVerticalTrackBar.setStepIdMax(100);
        GuiVerticalTrackBar guiVerticalTrackBar2 = this.resistanceSelector;
        Intrinsics.checkNotNull(guiVerticalTrackBar2);
        guiVerticalTrackBar2.setEnable(true);
        GuiVerticalTrackBar guiVerticalTrackBar3 = this.resistanceSelector;
        Intrinsics.checkNotNull(guiVerticalTrackBar3);
        guiVerticalTrackBar3.setRange(0.0f, 1.0f);
        this.ic2tier1 = this.newGuiButton(30, 6, 47, "IC2 T1");
        this.ic2tier2 = this.newGuiButton(30, 28, 47, "IC2 T2");
        this.ic2tier3 = this.newGuiButton(30, 50, 47, "IC2 T3");
        this.ic2tier4 = this.newGuiButton(30, 72, 47, "IC2 T4");
        GuiButtonEln[] guiButtonElnArray = new GuiButtonEln[]{this.ic2tier1, this.ic2tier2, this.ic2tier3, this.ic2tier4};
        this.ic2tierList = CollectionsKt.listOfNotNull(guiButtonElnArray);
        Intrinsics.checkNotNull(this.ic2tier1);
        this.ic2tier1.field_146124_l = true;
        GuiButtonEln guiButtonEln = this.ic2tier1;
        Intrinsics.checkNotNull(guiButtonEln);
        guiButtonEln.setComment(0, "Set output to 32 EU/t max");
        Intrinsics.checkNotNull(this.ic2tier2);
        this.ic2tier2.field_146124_l = true;
        GuiButtonEln guiButtonEln2 = this.ic2tier2;
        Intrinsics.checkNotNull(guiButtonEln2);
        guiButtonEln2.setComment(0, "Set output to 128 EU/t max");
        Intrinsics.checkNotNull(this.ic2tier3);
        this.ic2tier3.field_146124_l = true;
        GuiButtonEln guiButtonEln3 = this.ic2tier3;
        Intrinsics.checkNotNull(guiButtonEln3);
        guiButtonEln3.setComment(0, "Set output to 512 EU/t max");
        Intrinsics.checkNotNull(this.ic2tier4);
        this.ic2tier4.field_146124_l = true;
        GuiButtonEln guiButtonEln4 = this.ic2tier4;
        Intrinsics.checkNotNull(guiButtonEln4);
        guiButtonEln4.setComment(0, "Set output to 2048 EU/t max");
        GuiTextFieldEln guiTextFieldEln = this.powerEntry = this.newGuiTextField(6, 96, 70);
        Intrinsics.checkNotNull(guiTextFieldEln);
        guiTextFieldEln.getEnabled();
        GuiTextFieldEln guiTextFieldEln2 = this.powerEntry;
        Intrinsics.checkNotNull(guiTextFieldEln2);
        Collection $this$toTypedArray$iv = CollectionsKt.listOf("Select the resistance");
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        guiTextFieldEln2.setComment(thisCollection$iv.toArray(new String[0]));
        this.syncVoltage();
    }

    public final void syncVoltage() {
        GuiVerticalTrackBar guiVerticalTrackBar = this.resistanceSelector;
        Intrinsics.checkNotNull(guiVerticalTrackBar);
        guiVerticalTrackBar.setValue(this.selectedResistanceToSlider(this.render.selectedResistance));
        GuiTextFieldEln guiTextFieldEln = this.powerEntry;
        Intrinsics.checkNotNull(guiTextFieldEln);
        guiTextFieldEln.func_146180_a(String.valueOf((int)this.render.selectedResistance));
        List<? extends GuiButtonEln> list = this.ic2tierList;
        Intrinsics.checkNotNull(list);
        Iterable $this$forEachIndexed$iv = list;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            GuiButtonEln guiButtonEln = (GuiButtonEln)item$iv;
            int index = n;
            boolean bl = false;
            int tier = index + 1;
            button.field_146126_j = tier == this.render.getIc2tier() ? "[IC2 T" + tier + ']' : "IC2 T" + tier;
        }
        this.render.hasChanges = false;
    }

    public final float selectedResistanceToSlider(double selectedResistance) {
        return (float)MathKt.log(selectedResistance / (double)100 + 1.0, this.maxResistance / (double)100 + 1.0);
    }

    public final double sliderToSelectedResistance(float slider) {
        return (double)100 * (Math.pow(this.maxResistance / (double)100 + 1.0, slider) - 1.0);
    }

    @Override
    public void guiObjectEvent(@NotNull IGuiObject guiObject) {
        Intrinsics.checkNotNullParameter(guiObject, "guiObject");
        super.guiObjectEvent(guiObject);
        if (guiObject == this.resistanceSelector) {
            GuiVerticalTrackBar guiVerticalTrackBar = this.resistanceSelector;
            Intrinsics.checkNotNull(guiVerticalTrackBar);
            this.render.selectedResistance = this.sliderToSelectedResistance(guiVerticalTrackBar.getValue());
            this.render.getSender().clientSendDouble(NetworkType.SET_OHMS.getId(), this.render.selectedResistance);
        } else if (guiObject == this.powerEntry) {
            GuiTextFieldEln guiTextFieldEln = this.powerEntry;
            Intrinsics.checkNotNull(guiTextFieldEln);
            String string = guiTextFieldEln.func_146179_b();
            Intrinsics.checkNotNullExpressionValue(string, "powerEntry!!.text");
            Double d = StringsKt.toDoubleOrNull(string);
            this.render.selectedResistance = d != null ? d : this.render.selectedResistance;
            this.render.getSender().clientSendDouble(NetworkType.SET_OHMS.getId(), this.render.selectedResistance);
        } else if (guiObject == this.ic2tier1) {
            this.render.getSender().clientSendInt(NetworkType.SET_IC2_TIER.getId(), 1);
        } else if (guiObject == this.ic2tier2) {
            this.render.getSender().clientSendInt(NetworkType.SET_IC2_TIER.getId(), 2);
        } else if (guiObject == this.ic2tier3) {
            this.render.getSender().clientSendInt(NetworkType.SET_IC2_TIER.getId(), 3);
        } else if (guiObject == this.ic2tier4) {
            this.render.getSender().clientSendInt(NetworkType.SET_IC2_TIER.getId(), 4);
        }
    }

    @Override
    protected void preDraw(float f, int x, int y) {
        super.preDraw(f, x, y);
        if (this.render.hasChanges) {
            this.syncVoltage();
        }
        GuiVerticalTrackBar guiVerticalTrackBar = this.resistanceSelector;
        Intrinsics.checkNotNull(guiVerticalTrackBar);
        guiVerticalTrackBar.setComment(0, Utils.plotOhm(this.render.selectedResistance));
    }

    @Override
    @NotNull
    protected GuiHelper newHelper() {
        return new GuiHelper(this, 82, 115);
    }
}

