/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.simplenode.energyconverter;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.node.simple.SimpleNode;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.JvmStatic;
import mods.eln.shadow.kotlin.jvm.internal.DefaultConstructorMarker;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtResistor;
import mods.eln.simplenode.energyconverter.EnergyConverterElnToOtherDescriptor;
import mods.eln.simplenode.energyconverter.NetworkType;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 P2\u00020\u0001:\u0002PQB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u00101\u001a\u00020\n2\u0006\u00102\u001a\u00020\nJ\u0016\u00103\u001a\u00020\n2\u0006\u00104\u001a\u00020\n2\u0006\u00102\u001a\u00020\nJ\u0016\u00105\u001a\u00020\n2\u0006\u00106\u001a\u00020\n2\u0006\u00102\u001a\u00020\nJ \u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0013H\u0016J\u0018\u0010>\u001a\u00020\u00132\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0016J\"\u0010?\u001a\u0004\u0018\u00010@2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0013H\u0016J\u0010\u0010A\u001a\u00020B2\u0006\u00109\u001a\u00020:H\u0016J\b\u0010C\u001a\u00020DH\u0016J\u001a\u0010E\u001a\u00020D2\u0006\u0010F\u001a\u00020G2\b\u0010H\u001a\u0004\u0018\u00010IH\u0016J\u0010\u0010J\u001a\u00020D2\u0006\u0010F\u001a\u00020KH\u0016J\u0010\u0010L\u001a\u00020D2\u0006\u0010M\u001a\u00020NH\u0016J\u0010\u0010O\u001a\u00020D2\u0006\u0010M\u001a\u00020NH\u0016R\u001e\u0010\u0003\u001a\u00060\u0004R\u00020\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u000eR\u001a\u0010\u001b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\f\"\u0004\b\u001d\u0010\u000eR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\f\"\u0004\b0\u0010\u000e\u00a8\u0006R"}, d2={"Lmods/eln/simplenode/energyconverter/EnergyConverterElnToOtherNode;", "Lmods/eln/node/simple/SimpleNode;", "()V", "electricalProcess", "Lmods/eln/simplenode/energyconverter/EnergyConverterElnToOtherNode$ElectricalProcess;", "getElectricalProcess", "()Lmods/eln/simplenode/energyconverter/EnergyConverterElnToOtherNode$ElectricalProcess;", "setElectricalProcess", "(Lmods/eln/simplenode/energyconverter/EnergyConverterElnToOtherNode$ElectricalProcess;)V", "energyBuffer", "", "getEnergyBuffer", "()D", "setEnergyBuffer", "(D)V", "energyBufferMax", "getEnergyBufferMax", "setEnergyBufferMax", "ic2tier", "", "getIc2tier", "()I", "setIc2tier", "(I)V", "inPowerMax", "getInPowerMax", "setInPowerMax", "inStdVoltage", "getInStdVoltage", "setInStdVoltage", "load", "Lmods/eln/sim/nbt/NbtElectricalLoad;", "getLoad", "()Lmods/eln/sim/nbt/NbtElectricalLoad;", "setLoad", "(Lmods/eln/sim/nbt/NbtElectricalLoad;)V", "nodeUuid", "", "getNodeUuid", "()Ljava/lang/String;", "powerInResistor", "Lmods/eln/sim/nbt/NbtResistor;", "getPowerInResistor", "()Lmods/eln/sim/nbt/NbtResistor;", "setPowerInResistor", "(Lmods/eln/sim/nbt/NbtResistor;)V", "selectedOhms", "getSelectedOhms", "setSelectedOhms", "availableEnergyInModUnits", "conversionRatio", "availableEnergyInModUnitsWithLimit", "maximumModUnits", "drawEnergy", "otherModEnergy", "getElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "side", "Lmods/eln/misc/Direction;", "lrdu", "Lmods/eln/misc/LRDU;", "mask", "getSideConnectionMask", "getThermalLoad", "Lmods/eln/sim/ThermalLoad;", "hasGui", "", "initialize", "", "networkUnserialize", "stream", "Ljava/io/DataInputStream;", "player", "Lnet/minecraft/entity/player/EntityPlayerMP;", "publishSerialize", "Ljava/io/DataOutputStream;", "readFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "writeToNBT", "Companion", "ElectricalProcess", "Eln"})
public final class EnergyConverterElnToOtherNode
extends SimpleNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private NbtElectricalLoad load = new NbtElectricalLoad("load");
    @NotNull
    private NbtResistor powerInResistor = new NbtResistor("powerInResistor", this.load, null);
    @NotNull
    private ElectricalProcess electricalProcess = new ElectricalProcess();
    private double energyBuffer;
    private double energyBufferMax;
    private double inStdVoltage;
    private double inPowerMax;
    private double selectedOhms;
    private int ic2tier = 1;
    @NotNull
    private final String nodeUuid;
    @NotNull
    private static final String nodeUuidStatic = "ElnToOther";

    public EnergyConverterElnToOtherNode() {
        this.powerInResistor.setResistance(1.0E9);
        this.nodeUuid = "ElnToOther";
    }

    @NotNull
    public final NbtElectricalLoad getLoad() {
        return this.load;
    }

    public final void setLoad(@NotNull NbtElectricalLoad nbtElectricalLoad) {
        Intrinsics.checkNotNullParameter(nbtElectricalLoad, "<set-?>");
        this.load = nbtElectricalLoad;
    }

    @NotNull
    public final NbtResistor getPowerInResistor() {
        return this.powerInResistor;
    }

    public final void setPowerInResistor(@NotNull NbtResistor nbtResistor) {
        Intrinsics.checkNotNullParameter(nbtResistor, "<set-?>");
        this.powerInResistor = nbtResistor;
    }

    @NotNull
    public final ElectricalProcess getElectricalProcess() {
        return this.electricalProcess;
    }

    public final void setElectricalProcess(@NotNull ElectricalProcess electricalProcess) {
        Intrinsics.checkNotNullParameter(electricalProcess, "<set-?>");
        this.electricalProcess = electricalProcess;
    }

    public final double getEnergyBuffer() {
        return this.energyBuffer;
    }

    public final void setEnergyBuffer(double d) {
        this.energyBuffer = d;
    }

    public final double getEnergyBufferMax() {
        return this.energyBufferMax;
    }

    public final void setEnergyBufferMax(double d) {
        this.energyBufferMax = d;
    }

    public final double getInStdVoltage() {
        return this.inStdVoltage;
    }

    public final void setInStdVoltage(double d) {
        this.inStdVoltage = d;
    }

    public final double getInPowerMax() {
        return this.inPowerMax;
    }

    public final void setInPowerMax(double d) {
        this.inPowerMax = d;
    }

    public final double getSelectedOhms() {
        return this.selectedOhms;
    }

    public final void setSelectedOhms(double d) {
        this.selectedOhms = d;
    }

    public final int getIc2tier() {
        return this.ic2tier;
    }

    public final void setIc2tier(int n) {
        this.ic2tier = n;
    }

    @Override
    public int getSideConnectionMask(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return 1;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return null;
    }

    @Override
    @NotNull
    public ElectricalLoad getElectricalLoad(@NotNull Direction side, @NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return this.load;
    }

    @Override
    public void initialize() {
        this.electricalLoadList.add(this.load);
        this.electricalComponentList.add(this.powerInResistor);
        this.getElectricalProcessList().add(this.electricalProcess);
        Eln.applySmallRs(this.load);
        this.load.setAsPrivate();
        Object object = this.getDescriptor();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type mods.eln.simplenode.energyconverter.EnergyConverterElnToOtherDescriptor");
        ((EnergyConverterElnToOtherDescriptor)object).applyTo(this);
        this.connect();
    }

    public final double availableEnergyInModUnits(double conversionRatio) {
        return this.energyBuffer * conversionRatio;
    }

    public final double drawEnergy(double otherModEnergy, double conversionRatio) {
        double drawEnergy = otherModEnergy / conversionRatio;
        this.energyBuffer -= drawEnergy;
        return drawEnergy;
    }

    public final double availableEnergyInModUnitsWithLimit(double maximumModUnits, double conversionRatio) {
        return Math.min(this.availableEnergyInModUnits(conversionRatio), maximumModUnits * conversionRatio) / conversionRatio;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.writeToNBT(nbt);
        nbt.func_74780_a("energyBuffer", this.energyBuffer);
        nbt.func_74780_a("selectedOhms", this.selectedOhms);
        nbt.func_74768_a("ic2tier", this.ic2tier);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.readFromNBT(nbt);
        this.energyBuffer = nbt.func_74769_h("energyBuffer");
        this.selectedOhms = nbt.func_74764_b("selectedOhms") ? nbt.func_74769_h("selectedOhms") : 1.0E9;
        this.ic2tier = nbt.func_74762_e("ic2tier");
    }

    @Override
    public boolean hasGui(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return true;
    }

    @Override
    public void publishSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.publishSerialize(stream);
        try {
            stream.writeDouble(this.selectedOhms);
            stream.writeInt(this.ic2tier);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void networkUnserialize(@NotNull DataInputStream stream, @Nullable EntityPlayerMP player) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        try {
            byte by = stream.readByte();
            if (by == NetworkType.SET_OHMS.getId()) {
                double ohms = stream.readDouble();
                boolean bl = 10.0 <= ohms ? ohms <= 1.0E9 : false;
                if (bl) {
                    this.selectedOhms = ohms;
                }
                this.needPublish();
            } else if (by == NetworkType.SET_IC2_TIER.getId()) {
                int tier = stream.readInt();
                boolean bl = 1 <= tier ? tier < 5 : false;
                if (bl) {
                    this.ic2tier = tier;
                    this.needPublish();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @NotNull
    public String getNodeUuid() {
        return this.nodeUuid;
    }

    @NotNull
    public static final String getNodeUuidStatic() {
        return Companion.getNodeUuidStatic();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lmods/eln/simplenode/energyconverter/EnergyConverterElnToOtherNode$ElectricalProcess;", "Lmods/eln/sim/IProcess;", "(Lmods/eln/simplenode/energyconverter/EnergyConverterElnToOtherNode;)V", "timeout", "", "getTimeout", "()D", "setTimeout", "(D)V", "process", "", "time", "Eln"})
    public final class ElectricalProcess
    implements IProcess {
        private double timeout;

        public final double getTimeout() {
            return this.timeout;
        }

        public final void setTimeout(double d) {
            this.timeout = d;
        }

        @Override
        public void process(double time) {
            double power2 = EnergyConverterElnToOtherNode.this.getPowerInResistor().getPower();
            double d = power2;
            if (!(!Double.isInfinite(d) && !Double.isNaN(d))) {
                power2 = 0.0;
            }
            EnergyConverterElnToOtherNode energyConverterElnToOtherNode = EnergyConverterElnToOtherNode.this;
            energyConverterElnToOtherNode.setEnergyBuffer(energyConverterElnToOtherNode.getEnergyBuffer() + power2 * time);
            this.timeout -= time;
            if (this.timeout < 0.0) {
                this.timeout = 0.05;
                if (EnergyConverterElnToOtherNode.this.getEnergyBufferMax() - EnergyConverterElnToOtherNode.this.getEnergyBuffer() <= 0.0) {
                    EnergyConverterElnToOtherNode.this.getPowerInResistor().highImpedance();
                } else if (EnergyConverterElnToOtherNode.this.getSelectedOhms() < 10.0) {
                    EnergyConverterElnToOtherNode.this.getPowerInResistor().setResistance(1.0E9);
                } else {
                    EnergyConverterElnToOtherNode.this.getPowerInResistor().setResistance(Math.max(Eln.getSmallRs(), EnergyConverterElnToOtherNode.this.getSelectedOhms()));
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lmods/eln/simplenode/energyconverter/EnergyConverterElnToOtherNode$Companion;", "", "()V", "nodeUuidStatic", "", "getNodeUuidStatic$annotations", "getNodeUuidStatic", "()Ljava/lang/String;", "Eln"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getNodeUuidStatic() {
            return nodeUuidStatic;
        }

        @JvmStatic
        public static /* synthetic */ void getNodeUuidStatic$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

