/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.i18n.I18N;
import mods.eln.item.ElectricalFuseDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.Pair;
import mods.eln.shadow.kotlin.Unit;
import mods.eln.shadow.kotlin.collections.MapsKt;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001cH\u0016J\u001a\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001cH\u0016J\u0014\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020&0%H\u0016J\b\u0010'\u001a\u00020\u001aH\u0016J\b\u0010(\u001a\u00020&H\u0016J\u0010\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+H\u0016J0\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002012\u0006\u00103\u001a\u000201H\u0016J\u0010\u00104\u001a\u00020\u001a2\u0006\u00105\u001a\u000206H\u0016J\u0006\u00107\u001a\u00020\u001aJ\u0010\u00108\u001a\u00020\u001a2\u0006\u00105\u001a\u000206H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u00069"}, d2={"Lmods/eln/sixnode/ElectricalFuseHolderElement;", "Lmods/eln/node/six/SixNodeElement;", "sixNode", "Lmods/eln/node/six/SixNode;", "side", "Lmods/eln/misc/Direction;", "descriptor", "Lmods/eln/node/six/SixNodeDescriptor;", "(Lmods/eln/node/six/SixNode;Lmods/eln/misc/Direction;Lmods/eln/node/six/SixNodeDescriptor;)V", "T", "", "aLoad", "Lmods/eln/sim/nbt/NbtElectricalLoad;", "bLoad", "fuseProcess", "Lmods/eln/sim/IProcess;", "fuseResistor", "Lmods/eln/sim/mna/component/Resistor;", "value", "Lmods/eln/item/ElectricalFuseDescriptor;", "installedFuse", "getInstalledFuse", "()Lmods/eln/item/ElectricalFuseDescriptor;", "setInstalledFuse", "(Lmods/eln/item/ElectricalFuseDescriptor;)V", "computeElectricalLoad", "", "getConnectionMask", "", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "mask", "getThermalLoad", "Lmods/eln/sim/ThermalLoad;", "getWaila", "", "", "initialize", "multiMeterString", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "onBlockActivated", "", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "vx", "", "vy", "vz", "readFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "refreshSwitchResistor", "writeToNBT", "Eln"})
@SourceDebugExtension(value={"SMAP\nElectricalFuse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ElectricalFuse.kt\nmods/eln/sixnode/ElectricalFuseHolderElement\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,238:1\n1#2:239\n*E\n"})
public final class ElectricalFuseHolderElement
extends SixNodeElement {
    @NotNull
    private final NbtElectricalLoad aLoad;
    @NotNull
    private final NbtElectricalLoad bLoad;
    @NotNull
    private final Resistor fuseResistor;
    @Nullable
    private ElectricalFuseDescriptor installedFuse;
    private double T;
    @NotNull
    private final IProcess fuseProcess;

    public ElectricalFuseHolderElement(@NotNull SixNode sixNode, @NotNull Direction side, @NotNull SixNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(sixNode, "sixNode");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(sixNode, side, descriptor);
        this.aLoad = new NbtElectricalLoad("aLoad");
        this.bLoad = new NbtElectricalLoad("bLoad");
        this.fuseResistor = new Resistor(this.aLoad, this.bLoad);
        this.fuseProcess = arg_0 -> ElectricalFuseHolderElement.fuseProcess$lambda$0(this, arg_0);
        this.electricalLoadList.add(this.aLoad);
        this.electricalLoadList.add(this.bLoad);
        this.electricalComponentList.add(this.fuseResistor);
        this.electricalComponentList.add(new Resistor(this.bLoad, null).pullDown());
        this.electricalComponentList.add(new Resistor(this.aLoad, null).pullDown());
        this.electricalProcessList.add(this.fuseProcess);
    }

    @Nullable
    public final ElectricalFuseDescriptor getInstalledFuse() {
        return this.installedFuse;
    }

    public final void setInstalledFuse(@Nullable ElectricalFuseDescriptor value) {
        if (Intrinsics.areEqual(value, this.installedFuse)) {
            return;
        }
        this.installedFuse = value;
        this.refreshSwitchResistor();
        this.needPublish();
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        ItemStack fuseStack;
        NBTTagCompound fuseCompound;
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.readFromNBT(nbt);
        this.front = LRDU.Companion.readFromNBT(nbt, "front");
        NBTBase nBTBase = nbt.func_74781_a("fuse");
        NBTTagCompound nBTTagCompound = fuseCompound = nBTBase instanceof NBTTagCompound ? (NBTTagCompound)nBTBase : null;
        if (fuseCompound != null && (fuseStack = ItemStack.func_77949_a((NBTTagCompound)fuseCompound)) != null) {
            GenericItemUsingDamageDescriptor genericItemUsingDamageDescriptor = GenericItemUsingDamageDescriptor.Companion.getDescriptor(fuseStack);
            this.setInstalledFuse(genericItemUsingDamageDescriptor instanceof ElectricalFuseDescriptor ? (ElectricalFuseDescriptor)genericItemUsingDamageDescriptor : null);
        }
        this.T = nbt.func_74769_h("T");
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.writeToNBT(nbt);
        this.front.writeToNBT(nbt, "front");
        if (this.installedFuse != null) {
            NBTTagCompound fuseCompaound = new NBTTagCompound();
            ElectricalFuseDescriptor electricalFuseDescriptor = this.installedFuse;
            Intrinsics.checkNotNull(electricalFuseDescriptor);
            electricalFuseDescriptor.newItemStack().func_77955_b(fuseCompaound);
            nbt.func_74782_a("fuse", (NBTBase)fuseCompaound);
        }
        nbt.func_74780_a("T", this.T);
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        LRDU lRDU = lrdu;
        return lRDU == this.front ? (ElectricalLoad)this.aLoad : (lRDU == this.front.inverse() ? (ElectricalLoad)this.bLoad : null);
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return null;
    }

    @Override
    public int getConnectionMask(@NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        LRDU lRDU = lrdu;
        return lRDU == this.front ? 5 : (lRDU == this.front.inverse() ? 5 : 0);
    }

    @Override
    @NotNull
    public String multiMeterString() {
        return Utils.plotAmpere("I:", Math.abs(this.aLoad.getCurrent()));
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        Pair[] pairArray = new Pair[]{new Pair<String, String>(I18N.tr("Current", new Object[0]), Utils.plotAmpere("", Math.abs(this.aLoad.getCurrent())))};
        return MapsKt.mutableMapOf(pairArray);
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        try {
            ElectricalFuseDescriptor electricalFuseDescriptor = this.installedFuse;
            Utils.serialiseItemStack(stream, (ItemStack)(electricalFuseDescriptor != null ? electricalFuseDescriptor.newItemStack() : null));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void refreshSwitchResistor() {
        Unit unit;
        Object object = this.installedFuse;
        if (object != null && (object = ((ElectricalFuseDescriptor)object).getCableDescriptor()) != null) {
            ((ElectricalCableDescriptor)object).applyTo(this.fuseResistor);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            this.fuseResistor.ultraImpedance();
        }
    }

    @Override
    public void initialize() {
        this.computeElectricalLoad();
    }

    public final void computeElectricalLoad() {
        Eln.instance.veryHighVoltageCableDescriptor.applyTo(this.aLoad);
        Eln.instance.veryHighVoltageCableDescriptor.applyTo(this.bLoad);
        this.refreshSwitchResistor();
    }

    @Override
    public boolean onBlockActivated(@NotNull EntityPlayer entityPlayer, @NotNull Direction side, float vx, float vy, float vz) {
        ElectricalFuseDescriptor fuseDescriptor;
        ElectricalFuseDescriptor takenOutFuse;
        block6: {
            GenericItemUsingDamageDescriptor genericItemUsingDamageDescriptor;
            Object it;
            ItemStack itemStack;
            Intrinsics.checkNotNullParameter(entityPlayer, "entityPlayer");
            Intrinsics.checkNotNullParameter((Object)side, "side");
            if (this.onBlockActivatedRotate(entityPlayer)) {
                return true;
            }
            takenOutFuse = null;
            ItemStack itemStack2 = itemStack = entityPlayer.func_71045_bC();
            if (itemStack2 != null) {
                it = itemStack2;
                boolean bl = false;
                genericItemUsingDamageDescriptor = GenericItemUsingDamageDescriptor.Companion.getDescriptor((ItemStack)it);
            } else {
                genericItemUsingDamageDescriptor = null;
            }
            GenericItemUsingDamageDescriptor genericItemUsingDamageDescriptor2 = genericItemUsingDamageDescriptor;
            ElectricalFuseDescriptor electricalFuseDescriptor = fuseDescriptor = genericItemUsingDamageDescriptor2 instanceof ElectricalFuseDescriptor ? (ElectricalFuseDescriptor)genericItemUsingDamageDescriptor2 : null;
            if (itemStack != null) {
                if (fuseDescriptor != null && itemStack.field_77994_a > 0) {
                    int n = itemStack.field_77994_a;
                    itemStack.field_77994_a = n + -1;
                    takenOutFuse = this.installedFuse;
                    this.setInstalledFuse(fuseDescriptor);
                }
            } else {
                takenOutFuse = this.installedFuse;
                this.setInstalledFuse(null);
            }
            ElectricalFuseDescriptor electricalFuseDescriptor2 = takenOutFuse;
            if (electricalFuseDescriptor2 == null) break block6;
            it = electricalFuseDescriptor2;
            boolean bl = false;
            SixNode sixNode = this.sixNode;
            Intrinsics.checkNotNull(sixNode);
            sixNode.dropItem(((GenericItemUsingDamageDescriptor)it).newItemStack());
        }
        return takenOutFuse != null || fuseDescriptor != null;
    }

    private static final void fuseProcess$lambda$0(ElectricalFuseHolderElement this$0, double time) {
        ElectricalCableDescriptor cable;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        double I = this$0.aLoad.getCurrent();
        ElectricalFuseDescriptor electricalFuseDescriptor = this$0.installedFuse;
        ElectricalCableDescriptor electricalCableDescriptor = cable = electricalFuseDescriptor != null ? electricalFuseDescriptor.getCableDescriptor() : null;
        if (cable == null) {
            this$0.T = 0.0;
        } else {
            double P = I * I * cable.electricalRs * 2.0 - this$0.T / cable.thermalRp * 0.9;
            this$0.T += P / cable.thermalC * time;
        }
        double d = this$0.T;
        ElectricalCableDescriptor electricalCableDescriptor2 = cable;
        double d2 = electricalCableDescriptor2 != null ? electricalCableDescriptor2.thermalWarmLimit : 0.0;
        if (d > d2) {
            this$0.setInstalledFuse(ElectricalFuseDescriptor.Companion.getBlownFuse());
        }
    }
}

