/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.JvmField;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.ElectricalVuMeterElement;
import mods.eln.sixnode.ElectricalVuMeterRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0014\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001RB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J.\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u0003042\u0006\u00105\u001a\u00020\u0006H\u0016J\u001a\u00106\u001a\u00020\u00062\b\u00107\u001a\u0004\u0018\u0001022\u0006\u00108\u001a\u000209H\u0016J\u0018\u0010:\u001a\u00020.2\u0006\u0010;\u001a\u00020<2\b\u0010=\u001a\u0004\u0018\u00010>J\u0018\u0010?\u001a\u00020@2\u0006\u00108\u001a\u0002092\u0006\u00107\u001a\u000202H\u0016J\u0018\u0010A\u001a\u00020\u00062\u0006\u0010B\u001a\u0002002\u0006\u0010C\u001a\u00020DH\u0016J1\u0010E\u001a\u00020.2\u0006\u0010C\u001a\u00020D2\u0006\u0010B\u001a\u0002002\u0012\u0010F\u001a\n\u0012\u0006\b\u0001\u0012\u00020H0G\"\u00020HH\u0016\u00a2\u0006\u0002\u0010IJ\u0018\u0010J\u001a\u00020.2\u0006\u0010B\u001a\u00020K2\u0006\u0010L\u001a\u00020MH\u0016J \u0010N\u001a\u00020\u00062\u0006\u0010C\u001a\u00020D2\u0006\u0010B\u001a\u0002002\u0006\u0010O\u001a\u00020PH\u0016J&\u0010Q\u001a\u00020\u00062\b\u0010C\u001a\u0004\u0018\u00010D2\b\u0010B\u001a\u0004\u0018\u0001002\b\u0010O\u001a\u0004\u0018\u00010PH\u0016R \u0010\b\u001a\b\u0018\u00010\tR\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\b\u0018\u00010\tR\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\f\"\u0004\b\u0013\u0010\u000eR \u0010\u0014\u001a\b\u0018\u00010\tR\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\f\"\u0004\b\u0016\u0010\u000eR\u001c\u0010\u0017\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0010\"\u0004\b#\u0010$R\u0014\u0010%\u001a\u0004\u0018\u00010&8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R \u0010'\u001a\b\u0018\u00010\tR\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\f\"\u0004\b)\u0010\u000eR \u0010*\u001a\b\u0018\u00010\tR\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\f\"\u0004\b,\u0010\u000e\u00a8\u0006S"}, d2={"Lmods/eln/sixnode/ElectricalVuMeterDescriptor;", "Lmods/eln/node/six/SixNodeDescriptor;", "name", "", "objName", "onOffOnly", "", "(Ljava/lang/String;Ljava/lang/String;Z)V", "halo", "Lmods/eln/misc/Obj3D$Obj3DPart;", "Lmods/eln/misc/Obj3D;", "getHalo", "()Lmods/eln/misc/Obj3D$Obj3DPart;", "setHalo", "(Lmods/eln/misc/Obj3D$Obj3DPart;)V", "isRGB", "()Z", "led", "getLed", "setLed", "main", "getMain", "setMain", "obj", "getObj", "()Lmods/eln/misc/Obj3D;", "setObj", "(Lmods/eln/misc/Obj3D;)V", "objType", "Lmods/eln/sixnode/ElectricalVuMeterDescriptor$ObjType;", "getObjType", "()Lmods/eln/sixnode/ElectricalVuMeterDescriptor$ObjType;", "setObjType", "(Lmods/eln/sixnode/ElectricalVuMeterDescriptor$ObjType;)V", "getOnOffOnly", "setOnOffOnly", "(Z)V", "pinDistance", "", "pointer", "getPointer", "setPointer", "vumeter", "getVumeter", "setVumeter", "addInformation", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "list", "", "par4", "canBePlacedOnSide", "player", "side", "Lmods/eln/misc/Direction;", "draw", "factorArg", "", "entity", "Lnet/minecraft/tileentity/TileEntity;", "getFrontFromPlace", "Lmods/eln/misc/LRDU;", "handleRenderType", "item", "type", "Lnet/minecraftforge/client/IItemRenderer$ItemRenderType;", "renderItem", "data", "", "", "(Lnet/minecraftforge/client/IItemRenderer$ItemRenderType;Lnet/minecraft/item/ItemStack;[Ljava/lang/Object;)V", "setParent", "Lnet/minecraft/item/Item;", "damage", "", "shouldUseRenderHelper", "helper", "Lnet/minecraftforge/client/IItemRenderer$ItemRendererHelper;", "shouldUseRenderHelperEln", "ObjType", "Eln"})
public final class ElectricalVuMeterDescriptor
extends SixNodeDescriptor {
    private boolean onOffOnly;
    @Nullable
    private Obj3D obj;
    @Nullable
    private ObjType objType;
    @Nullable
    private Obj3D.Obj3DPart vumeter;
    @Nullable
    private Obj3D.Obj3DPart pointer;
    @Nullable
    private Obj3D.Obj3DPart led;
    @Nullable
    private Obj3D.Obj3DPart halo;
    @Nullable
    private Obj3D.Obj3DPart main;
    @JvmField
    @Nullable
    public float[] pinDistance;
    private final boolean isRGB;

    public ElectricalVuMeterDescriptor(@NotNull String name, @NotNull String objName, boolean onOffOnly) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(objName, "objName");
        super(name, ElectricalVuMeterElement.class, ElectricalVuMeterRender.class);
        this.onOffOnly = onOffOnly;
        this.name = name;
        this.obj = Eln.obj.getObj(objName);
        if (this.obj != null) {
            Obj3D obj3D = this.obj;
            Intrinsics.checkNotNull(obj3D);
            String string = obj3D.getString("type");
            Intrinsics.checkNotNullExpressionValue(string, "obj!!.getString(\"type\")");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
            if (Intrinsics.areEqual(string2, "rot")) {
                this.objType = ObjType.Rot;
                Obj3D obj3D2 = this.obj;
                Intrinsics.checkNotNull(obj3D2);
                this.vumeter = obj3D2.getPart("Vumeter");
                Obj3D obj3D3 = this.obj;
                Intrinsics.checkNotNull(obj3D3);
                this.pointer = obj3D3.getPart("Pointer");
                Obj3D.Obj3DPart obj3DPart = this.vumeter;
                Intrinsics.checkNotNull(obj3DPart);
                this.pinDistance = Utils.getSixNodePinDistance(obj3DPart);
            }
            Obj3D obj3D4 = this.obj;
            Intrinsics.checkNotNull(obj3D4);
            if (Intrinsics.areEqual(obj3D4.getString("type"), "LedOnOff")) {
                this.objType = ObjType.LedOnOff;
                Obj3D obj3D5 = this.obj;
                Intrinsics.checkNotNull(obj3D5);
                this.main = obj3D5.getPart("main");
                Obj3D obj3D6 = this.obj;
                Intrinsics.checkNotNull(obj3D6);
                this.halo = obj3D6.getPart("halo");
                Obj3D obj3D7 = this.obj;
                Intrinsics.checkNotNull(obj3D7);
                this.led = obj3D7.getPart("Led");
                Obj3D.Obj3DPart obj3DPart = this.main;
                Intrinsics.checkNotNull(obj3DPart);
                this.pinDistance = Utils.getSixNodePinDistance(obj3DPart);
            }
        }
        this.isRGB = Intrinsics.areEqual(this.name, "Multicolor LED vuMeter");
        this.voltageLevelColor = VoltageLevelColor.SignalVoltage;
    }

    public final boolean getOnOffOnly() {
        return this.onOffOnly;
    }

    public final void setOnOffOnly(boolean bl) {
        this.onOffOnly = bl;
    }

    @Nullable
    public final Obj3D getObj() {
        return this.obj;
    }

    public final void setObj(@Nullable Obj3D obj3D) {
        this.obj = obj3D;
    }

    @Nullable
    public final ObjType getObjType() {
        return this.objType;
    }

    public final void setObjType(@Nullable ObjType objType) {
        this.objType = objType;
    }

    @Nullable
    public final Obj3D.Obj3DPart getVumeter() {
        return this.vumeter;
    }

    public final void setVumeter(@Nullable Obj3D.Obj3DPart obj3DPart) {
        this.vumeter = obj3DPart;
    }

    @Nullable
    public final Obj3D.Obj3DPart getPointer() {
        return this.pointer;
    }

    public final void setPointer(@Nullable Obj3D.Obj3DPart obj3DPart) {
        this.pointer = obj3DPart;
    }

    @Nullable
    public final Obj3D.Obj3DPart getLed() {
        return this.led;
    }

    public final void setLed(@Nullable Obj3D.Obj3DPart obj3DPart) {
        this.led = obj3DPart;
    }

    @Nullable
    public final Obj3D.Obj3DPart getHalo() {
        return this.halo;
    }

    public final void setHalo(@Nullable Obj3D.Obj3DPart obj3DPart) {
        this.halo = obj3DPart;
    }

    @Nullable
    public final Obj3D.Obj3DPart getMain() {
        return this.main;
    }

    public final void setMain(@Nullable Obj3D.Obj3DPart obj3DPart) {
        this.main = obj3DPart;
    }

    public final boolean isRGB() {
        return this.isRGB;
    }

    @Override
    public void setParent(@NotNull Item item, int damage) {
        Intrinsics.checkNotNullParameter(item, "item");
        super.setParent(item, damage);
        Data.addSignal(this.newItemStack());
    }

    public final void draw(float factorArg, @Nullable TileEntity entity) {
        float factor = factorArg;
        if ((double)factor < 0.0) {
            factor = 0.0f;
        }
        if ((double)factor > 1.0) {
            factor = 1.0f;
        }
        ObjType objType = this.objType;
        switch (objType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[objType.ordinal()]) {
            case 1: {
                Obj3D.Obj3DPart obj3DPart = this.main;
                Intrinsics.checkNotNull(obj3DPart);
                obj3DPart.draw();
                if (this.isRGB) {
                    Color ledColor = new Color();
                    ledColor.fromHSB(factor, 1.0f, 1.0f);
                    if (factor > 0.005f) {
                        GL11.glColor3f((float)((float)ledColor.getRed() / 255.0f), (float)((float)ledColor.getGreen() / 255.0f), (float)((float)ledColor.getBlue() / 255.0f));
                    } else {
                        GL11.glColor3f((float)0.5f, (float)0.5f, (float)0.5f);
                    }
                    UtilsClient.drawLight(this.led);
                    if (entity != null) {
                        if (!(factor > 0.005f)) break;
                        UtilsClient.drawHalo(this.halo, (float)ledColor.getRed() / 255.0f, (float)ledColor.getGreen() / 255.0f, (float)ledColor.getBlue() / 255.0f, entity, false);
                        break;
                    }
                    if (!(factor > 0.005f)) break;
                    UtilsClient.drawLight(this.halo);
                    break;
                }
                boolean s = (double)factor > 0.5;
                java.awt.Color c = UtilsClient.ledOnOffColorC(s);
                GL11.glColor3f((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f));
                UtilsClient.drawLight(this.led);
                if (entity != null) {
                    UtilsClient.drawHalo(this.halo, (float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, entity, false);
                    break;
                }
                UtilsClient.drawLight(this.halo);
                break;
            }
            case 2: {
                Obj3D.Obj3DPart obj3DPart = this.vumeter;
                Intrinsics.checkNotNull(obj3DPart);
                obj3DPart.draw();
                Obj3D.Obj3DPart obj3DPart2 = this.pointer;
                Intrinsics.checkNotNull(obj3DPart2);
                float alphaOff = obj3DPart2.getFloat("alphaOff");
                Obj3D.Obj3DPart obj3DPart3 = this.pointer;
                Intrinsics.checkNotNull(obj3DPart3);
                float alphaOn = obj3DPart3.getFloat("alphaOn");
                Obj3D.Obj3DPart obj3DPart4 = this.pointer;
                Intrinsics.checkNotNull(obj3DPart4);
                obj3DPart4.draw(factor * (alphaOn - alphaOff) + alphaOff, 1.0f, 0.0f, 0.0f);
            }
        }
    }

    @Override
    public void addInformation(@NotNull ItemStack itemStack, @NotNull EntityPlayer entityPlayer, @NotNull List<String> list, boolean par4) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(entityPlayer, "entityPlayer");
        Intrinsics.checkNotNullParameter(list, "list");
        super.addInformation(itemStack, entityPlayer, list, par4);
        if (this.isRGB) {
            String string = I18N.tr("Displays a color based on the value of a signal", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string, "tr(\"Displays a color bas\u2026n the value of a signal\")");
            list.add(string);
        } else {
            String string = I18N.tr("Displays the value of a signal.", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string, "tr(\"Displays the value of a signal.\")");
            list.add(string);
        }
    }

    @Override
    public boolean shouldUseRenderHelper(@NotNull IItemRenderer.ItemRenderType type, @NotNull ItemStack item, @NotNull IItemRenderer.ItemRendererHelper helper) {
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(helper, "helper");
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(@NotNull ItemStack item, @NotNull IItemRenderer.ItemRenderType type) {
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(type, "type");
        return true;
    }

    @Override
    public boolean shouldUseRenderHelperEln(@Nullable IItemRenderer.ItemRenderType type, @Nullable ItemStack item, @Nullable IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(@NotNull IItemRenderer.ItemRenderType type, @NotNull ItemStack item, Object ... data) {
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(data, "data");
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, Arrays.copyOf(data, data.length));
        } else {
            this.draw(0.0f, null);
        }
    }

    @Override
    @NotNull
    public LRDU getFrontFromPlace(@NotNull Direction side, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        LRDU lRDU = super.getFrontFromPlace(side, player);
        Intrinsics.checkNotNull((Object)lRDU);
        return lRDU.inverse();
    }

    @Override
    public boolean canBePlacedOnSide(@Nullable EntityPlayer player, @NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lmods/eln/sixnode/ElectricalVuMeterDescriptor$ObjType;", "", "(Ljava/lang/String;I)V", "Rot", "LedOnOff", "Eln"})
    public static final class ObjType
    extends Enum<ObjType> {
        public static final /* enum */ ObjType Rot = new ObjType();
        public static final /* enum */ ObjType LedOnOff = new ObjType();
        private static final /* synthetic */ ObjType[] $VALUES;

        public static ObjType[] values() {
            return (ObjType[])$VALUES.clone();
        }

        public static ObjType valueOf(String value) {
            return Enum.valueOf(ObjType.class, value);
        }

        static {
            $VALUES = objTypeArray = new ObjType[]{ObjType.Rot, ObjType.LedOnOff};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ObjType.values().length];
            try {
                nArray[ObjType.LedOnOff.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjType.Rot.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

