/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.JvmField;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalGateInput;
import mods.eln.sixnode.ElectricalVuMeterDescriptor;
import mods.eln.sixnode.ElectricalVuMeterSlowProcess;
import net.minecraft.nbt.NBTTagCompound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J\u0014\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001dH\u0016J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u001dH\u0016J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0016R\u0012\u0010\u0006\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006)"}, d2={"Lmods/eln/sixnode/ElectricalVuMeterElement;", "Lmods/eln/node/six/SixNodeElement;", "sixNode", "Lmods/eln/node/six/SixNode;", "side", "Lmods/eln/misc/Direction;", "descriptor", "Lmods/eln/node/six/SixNodeDescriptor;", "(Lmods/eln/node/six/SixNode;Lmods/eln/misc/Direction;Lmods/eln/node/six/SixNodeDescriptor;)V", "Lmods/eln/sixnode/ElectricalVuMeterDescriptor;", "inputGate", "Lmods/eln/sim/nbt/NbtElectricalGateInput;", "slowProcess", "Lmods/eln/sixnode/ElectricalVuMeterSlowProcess;", "getSlowProcess", "()Lmods/eln/sixnode/ElectricalVuMeterSlowProcess;", "setSlowProcess", "(Lmods/eln/sixnode/ElectricalVuMeterSlowProcess;)V", "getConnectionMask", "", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "mask", "getThermalLoad", "Lmods/eln/sim/ThermalLoad;", "getWaila", "", "", "initialize", "", "multiMeterString", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "readFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "thermoMeterString", "writeToNBT", "Eln"})
public final class ElectricalVuMeterElement
extends SixNodeElement {
    @JvmField
    @NotNull
    public NbtElectricalGateInput inputGate;
    @NotNull
    private ElectricalVuMeterSlowProcess slowProcess;
    @JvmField
    @NotNull
    public ElectricalVuMeterDescriptor descriptor;

    public ElectricalVuMeterElement(@NotNull SixNode sixNode, @NotNull Direction side, @NotNull SixNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(sixNode, "sixNode");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(sixNode, side, descriptor);
        this.inputGate = new NbtElectricalGateInput("inputGate");
        this.slowProcess = new ElectricalVuMeterSlowProcess(this);
        this.descriptor = (ElectricalVuMeterDescriptor)descriptor;
        this.electricalLoadList.add(this.inputGate);
        this.slowProcessList.add(this.slowProcess);
    }

    @NotNull
    public final ElectricalVuMeterSlowProcess getSlowProcess() {
        return this.slowProcess;
    }

    public final void setSlowProcess(@NotNull ElectricalVuMeterSlowProcess electricalVuMeterSlowProcess) {
        Intrinsics.checkNotNullParameter(electricalVuMeterSlowProcess, "<set-?>");
        this.slowProcess = electricalVuMeterSlowProcess;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.readFromNBT(nbt);
        byte value = nbt.func_74771_c("front");
        this.front = LRDU.Companion.fromInt(value >> 0 & 3);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.writeToNBT(nbt);
        nbt.func_74774_a("front", (byte)(this.front.toInt() << 0));
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return this.front == lrdu ? (ElectricalLoad)this.inputGate : null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return null;
    }

    @Override
    public int getConnectionMask(@NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return this.front == lrdu ? 4 : 0;
    }

    @Override
    @NotNull
    public String multiMeterString() {
        return Utils.plotVolt("U:", this.inputGate.getVoltage()) + Utils.plotAmpere("I:", this.inputGate.getCurrent());
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        Map info = new HashMap();
        if (this.descriptor.isRGB()) {
            Map map = info;
            String string = I18N.tr("Input", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string, "tr(\"Input\")");
            String string2 = string;
            String string3 = Utils.plotVolt(this.inputGate.getSignalVoltage());
            map.put(string2, string3);
        } else {
            Map map = info;
            String string = I18N.tr("Input", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string, "tr(\"Input\")");
            String string4 = string;
            String string5 = this.inputGate.stateHigh() ? I18N.tr("ON", new Object[0]) : I18N.tr("OFF", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string5, "if (inputGate.stateHigh(\u2026\"ON\") else I18N.tr(\"OFF\")");
            String string6 = string5;
            map.put(string4, string6);
        }
        return info;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        try {
            stream.writeByte(this.front.toInt() << 4);
            stream.writeFloat((float)(this.inputGate.getVoltage() / 5.0));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize() {
    }
}

