/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.PhysicalInterpolator;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.sixnode.ElectricalVuMeterDescriptor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010 \u001a\u00020\nH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u0015H\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006,"}, d2={"Lmods/eln/sixnode/ElectricalVuMeterRender;", "Lmods/eln/node/six/SixNodeElementRender;", "tileEntity", "Lmods/eln/node/six/SixNodeEntity;", "side", "Lmods/eln/misc/Direction;", "descriptor", "Lmods/eln/node/six/SixNodeDescriptor;", "(Lmods/eln/node/six/SixNodeEntity;Lmods/eln/misc/Direction;Lmods/eln/node/six/SixNodeDescriptor;)V", "boot", "", "getBoot", "()Z", "setBoot", "(Z)V", "Lmods/eln/sixnode/ElectricalVuMeterDescriptor;", "getDescriptor", "()Lmods/eln/sixnode/ElectricalVuMeterDescriptor;", "setDescriptor", "(Lmods/eln/sixnode/ElectricalVuMeterDescriptor;)V", "factor", "", "getFactor", "()F", "setFactor", "(F)V", "interpolator", "Lmods/eln/misc/PhysicalInterpolator;", "getInterpolator", "()Lmods/eln/misc/PhysicalInterpolator;", "setInterpolator", "(Lmods/eln/misc/PhysicalInterpolator;)V", "cameraDrawOptimisation", "draw", "", "getCableRender", "Lmods/eln/cable/CableRenderDescriptor;", "lrdu", "Lmods/eln/misc/LRDU;", "publishUnserialize", "stream", "Ljava/io/DataInputStream;", "refresh", "deltaT", "Eln"})
public final class ElectricalVuMeterRender
extends SixNodeElementRender {
    @NotNull
    private ElectricalVuMeterDescriptor descriptor;
    @NotNull
    private PhysicalInterpolator interpolator;
    private float factor;
    private boolean boot;

    public ElectricalVuMeterRender(@NotNull SixNodeEntity tileEntity, @NotNull Direction side, @NotNull SixNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(tileEntity, "tileEntity");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(tileEntity, side, descriptor);
        this.descriptor = (ElectricalVuMeterDescriptor)descriptor;
        this.interpolator = new PhysicalInterpolator(0.4f, 2.0f, 1.5f, 0.2f);
        this.boot = true;
    }

    @NotNull
    public final ElectricalVuMeterDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final void setDescriptor(@NotNull ElectricalVuMeterDescriptor electricalVuMeterDescriptor) {
        Intrinsics.checkNotNullParameter(electricalVuMeterDescriptor, "<set-?>");
        this.descriptor = electricalVuMeterDescriptor;
    }

    @NotNull
    public final PhysicalInterpolator getInterpolator() {
        return this.interpolator;
    }

    public final void setInterpolator(@NotNull PhysicalInterpolator physicalInterpolator) {
        Intrinsics.checkNotNullParameter(physicalInterpolator, "<set-?>");
        this.interpolator = physicalInterpolator;
    }

    public final float getFactor() {
        return this.factor;
    }

    public final void setFactor(float f) {
        this.factor = f;
    }

    public final boolean getBoot() {
        return this.boot;
    }

    public final void setBoot(boolean bl) {
        this.boot = bl;
    }

    @Override
    public void draw() {
        super.draw();
        this.drawSignalPin(this.front, this.descriptor.pinDistance);
        if (this.side.isY()) {
            LRDU lRDU = this.front;
            Intrinsics.checkNotNull((Object)lRDU);
            lRDU.right().glRotateOnX();
        }
        this.descriptor.draw(this.descriptor.getOnOffOnly() ? this.interpolator.getTarget() : this.interpolator.get(), this.getTileEntity());
    }

    @Override
    public void refresh(float deltaT) {
        this.interpolator.step(deltaT);
    }

    @Override
    public boolean cameraDrawOptimisation() {
        return false;
    }

    @Override
    public void publishUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.publishUnserialize(stream);
        try {
            byte b = stream.readByte();
            this.front = LRDU.Companion.fromInt(b >> 4 & 3);
            if (this.boot) {
                this.interpolator.setPos(stream.readFloat());
            } else {
                this.interpolator.setTarget(stream.readFloat());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.boot) {
            this.boot = false;
        }
    }

    @Override
    @NotNull
    public CableRenderDescriptor getCableRender(@NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        CableRenderDescriptor cableRenderDescriptor = Eln.instance.signalCableDescriptor.render;
        Intrinsics.checkNotNullExpressionValue(cableRenderDescriptor, "instance.signalCableDescriptor.render");
        return cableRenderDescriptor;
    }
}

