/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Map;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.NodePeriodicPublishProcess;
import mods.eln.node.published;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.Pair;
import mods.eln.shadow.kotlin.TuplesKt;
import mods.eln.shadow.kotlin.Unit;
import mods.eln.shadow.kotlin.collections.MapsKt;
import mods.eln.shadow.kotlin.jvm.functions.Function1;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.MutablePropertyReference1Impl;
import mods.eln.shadow.kotlin.jvm.internal.Reflection;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.kotlin.reflect.KProperty;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.ResistorSwitch;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sixnode.EmergencyLampDescriptor;
import mods.eln.sixnode.lampsupply.LampSupplyElement;
import net.minecraft.nbt.NBTTagCompound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001OB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0016J\u0018\u0010:\u001a\u00020;2\u0006\u00108\u001a\u0002092\u0006\u0010<\u001a\u000207H\u0016J\u001a\u0010=\u001a\u0004\u0018\u00010>2\u0006\u00108\u001a\u0002092\u0006\u0010<\u001a\u000207H\u0016J\u0014\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0@H\u0016J\b\u0010A\u001a\u00020 H\u0016J\b\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u00020\nH\u0016J\u0010\u0010E\u001a\u00020C2\u0006\u0010F\u001a\u00020GH\u0016J\u0010\u0010H\u001a\u00020C2\u0006\u0010F\u001a\u00020IH\u0016J\u0010\u0010J\u001a\u00020C2\u0006\u0010K\u001a\u00020LH\u0016J\b\u0010M\u001a\u00020\nH\u0016J\u0010\u0010N\u001a\u00020C2\u0006\u0010K\u001a\u00020LH\u0016R+\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR+\u0010!\u001a\u00020 2\u0006\u0010\t\u001a\u00020 8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b%\u0010\u0011\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R+\u0010*\u001a\u00020 2\u0006\u0010\t\u001a\u00020 8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b-\u0010\u0011\u001a\u0004\b+\u0010\"\"\u0004\b,\u0010$R+\u0010.\u001a\u00020 2\u0006\u0010\t\u001a\u00020 8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b1\u0010\u0011\u001a\u0004\b/\u0010\"\"\u0004\b0\u0010$R\u0011\u00102\u001a\u000203\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105\u00a8\u0006P"}, d2={"Lmods/eln/sixnode/EmergencyLampElement;", "Lmods/eln/node/six/SixNodeElement;", "sixNode", "Lmods/eln/node/six/SixNode;", "side", "Lmods/eln/misc/Direction;", "descriptor", "Lmods/eln/node/six/SixNodeDescriptor;", "(Lmods/eln/node/six/SixNode;Lmods/eln/misc/Direction;Lmods/eln/node/six/SixNodeDescriptor;)V", "<set-?>", "", "channel", "getChannel", "()Ljava/lang/String;", "setChannel", "(Ljava/lang/String;)V", "channel$delegate", "Lmods/eln/node/published;", "charge", "", "getCharge", "()D", "setCharge", "(D)V", "chargingResistor", "Lmods/eln/sim/mna/component/ResistorSwitch;", "getChargingResistor", "()Lmods/eln/sim/mna/component/ResistorSwitch;", "desc", "Lmods/eln/sixnode/EmergencyLampDescriptor;", "getDesc", "()Lmods/eln/sixnode/EmergencyLampDescriptor;", "", "isConnectedToLampSupply", "()Z", "setConnectedToLampSupply", "(Z)V", "isConnectedToLampSupply$delegate", "load", "Lmods/eln/sim/nbt/NbtElectricalLoad;", "getLoad", "()Lmods/eln/sim/nbt/NbtElectricalLoad;", "on", "getOn", "setOn", "on$delegate", "poweredByCable", "getPoweredByCable", "setPoweredByCable", "poweredByCable$delegate", "process", "Lmods/eln/sim/IProcess;", "getProcess", "()Lmods/eln/sim/IProcess;", "getConnectionMask", "", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "mask", "getThermalLoad", "Lmods/eln/sim/ThermalLoad;", "getWaila", "", "hasGui", "initialize", "", "multiMeterString", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "networkUnserialize", "Ljava/io/DataInputStream;", "readFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "thermoMeterString", "writeToNBT", "Event", "Eln"})
@SourceDebugExtension(value={"SMAP\nEmergencyLamp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmergencyLamp.kt\nmods/eln/sixnode/EmergencyLampElement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,309:1\n1855#2,2:310\n*S KotlinDebug\n*F\n+ 1 EmergencyLamp.kt\nmods/eln/sixnode/EmergencyLampElement\n*L\n116#1:310,2\n*E\n"})
public final class EmergencyLampElement
extends SixNodeElement {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final EmergencyLampDescriptor desc;
    @NotNull
    private final NbtElectricalLoad load;
    @NotNull
    private final ResistorSwitch chargingResistor;
    @NotNull
    private final published on$delegate;
    private double charge;
    @NotNull
    private final published poweredByCable$delegate;
    @NotNull
    private final published channel$delegate;
    @NotNull
    private final published isConnectedToLampSupply$delegate;
    @NotNull
    private final IProcess process;

    public EmergencyLampElement(@NotNull SixNode sixNode, @NotNull Direction side, @NotNull SixNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(sixNode, "sixNode");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(sixNode, side, descriptor);
        this.desc = (EmergencyLampDescriptor)descriptor;
        this.load = new NbtElectricalLoad("load");
        this.chargingResistor = new ResistorSwitch("chargingResistor", this.load, null);
        this.on$delegate = new published(false, new Function1<Boolean, Unit>(sixNode, this){
            final /* synthetic */ SixNode $sixNode;
            final /* synthetic */ EmergencyLampElement this$0;
            {
                this.$sixNode = $sixNode;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(boolean it) {
                this.$sixNode.setLightValue(it ? this.this$0.getDesc().getLightLevel() : 0);
            }
        }, false, 4, null);
        this.charge = this.desc.getBatteryCapacity() / (double)2;
        this.poweredByCable$delegate = new published<Boolean>(false, new Function1<Boolean, Unit>(this){
            final /* synthetic */ EmergencyLampElement this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(boolean it) {
                if (it) {
                    this.this$0.setConnectedToLampSupply(false);
                }
            }
        }, true);
        this.channel$delegate = new published("Default channel", null, false, 6, null);
        this.isConnectedToLampSupply$delegate = new published(false, null, false, 6, null);
        this.process = arg_0 -> EmergencyLampElement.process$lambda$1(this, sixNode, arg_0);
    }

    @NotNull
    public final EmergencyLampDescriptor getDesc() {
        return this.desc;
    }

    @NotNull
    public final NbtElectricalLoad getLoad() {
        return this.load;
    }

    @NotNull
    public final ResistorSwitch getChargingResistor() {
        return this.chargingResistor;
    }

    public final boolean getOn() {
        return (Boolean)this.on$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    public final void setOn(boolean bl) {
        this.on$delegate.setValue(this, (KProperty<?>)$$delegatedProperties[0], bl);
    }

    public final double getCharge() {
        return this.charge;
    }

    public final void setCharge(double d) {
        this.charge = d;
    }

    public final boolean getPoweredByCable() {
        return (Boolean)this.poweredByCable$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    public final void setPoweredByCable(boolean bl) {
        this.poweredByCable$delegate.setValue(this, (KProperty<?>)$$delegatedProperties[1], bl);
    }

    @NotNull
    public final String getChannel() {
        return (String)this.channel$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[2]);
    }

    public final void setChannel(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.channel$delegate.setValue(this, (KProperty<?>)$$delegatedProperties[2], string);
    }

    public final boolean isConnectedToLampSupply() {
        return (Boolean)this.isConnectedToLampSupply$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[3]);
    }

    public final void setConnectedToLampSupply(boolean bl) {
        this.isConnectedToLampSupply$delegate.setValue(this, (KProperty<?>)$$delegatedProperties[3], bl);
    }

    @NotNull
    public final IProcess getProcess() {
        return this.process;
    }

    @Override
    public void initialize() {
        this.chargingResistor.setResistance(this.desc.getCable().electricalNominalVoltage * this.desc.getCable().electricalNominalVoltage / this.desc.getChargePower());
        this.desc.getCable().applyTo(this.load);
        this.electricalLoadList.add(this.load);
        this.electricalComponentList.add(this.chargingResistor);
        this.slowProcessList.add(this.process);
        SixNode sixNode = this.sixNode;
        Intrinsics.checkNotNull(sixNode);
        this.slowProcessList.add(new NodePeriodicPublishProcess(sixNode, 2.0, 0.5));
        this.slowProcessList.add(new VoltageStateWatchDog(this.load).setNominalVoltage(this.desc.getCable().electricalNominalVoltage).setDestroys(new WorldExplosion(this).cableExplosion()));
    }

    @Override
    public int getConnectionMask(@NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return this.getPoweredByCable() && this.side == Direction.YP ? 1 : (this.getPoweredByCable() && (lrdu == this.front.left() || lrdu == this.front.right()) ? 1 : 0);
    }

    @Override
    @NotNull
    public ElectricalLoad getElectricalLoad(@NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return this.load;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return null;
    }

    @Override
    @NotNull
    public String multiMeterString() {
        StringBuilder stringBuilder;
        StringBuilder $this$multiMeterString_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$multiMeterString_u24lambda_u242.append(Utils.plotVolt("U:", this.load.getVoltage()));
        $this$multiMeterString_u24lambda_u242.append(Utils.plotAmpere("I:", this.load.getCurrent()));
        SixNodeDescriptor sixNodeDescriptor = this.sixNodeElementDescriptor;
        Intrinsics.checkNotNull(sixNodeDescriptor, "null cannot be cast to non-null type mods.eln.sixnode.EmergencyLampDescriptor");
        $this$multiMeterString_u24lambda_u242.append(Utils.plotPercent("Charge:", this.charge / ((EmergencyLampDescriptor)sixNodeDescriptor).getBatteryCapacity()));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return "";
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to("State", this.getOn() ? "On" : (this.chargingResistor.getState() ? "Charging..." : (this.charge <= 0.0 ? "Batteries empty" : "Fully charged")));
        SixNodeDescriptor sixNodeDescriptor = this.sixNodeElementDescriptor;
        Intrinsics.checkNotNull(sixNodeDescriptor, "null cannot be cast to non-null type mods.eln.sixnode.EmergencyLampDescriptor");
        pairArray[1] = TuplesKt.to("Charge", Utils.plotPercent("", this.charge / ((EmergencyLampDescriptor)sixNodeDescriptor).getBatteryCapacity()));
        return MapsKt.mapOf(pairArray);
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        stream.writeFloat((float)this.charge / (float)this.desc.getBatteryCapacity());
        stream.writeBoolean(this.getOn());
        stream.writeBoolean(this.getPoweredByCable());
        stream.writeUTF(this.getChannel());
        stream.writeBoolean(this.isConnectedToLampSupply());
    }

    @Override
    public void networkUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkUnserialize(stream);
        byte by = stream.readByte();
        if (by == Event.TOGGLE_POWERED_BY_CABLE.getValue()) {
            this.setPoweredByCable(!this.getPoweredByCable());
        } else if (by == Event.SET_CHANNEL.getValue()) {
            String string = stream.readUTF();
            Intrinsics.checkNotNullExpressionValue(string, "stream.readUTF()");
            this.setChannel(string);
        }
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.readFromNBT(nbt);
        this.setOn(nbt.func_74767_n("on"));
        this.charge = nbt.func_74769_h("charge");
        this.setPoweredByCable(nbt.func_74767_n("poweredByCable"));
        String string = nbt.func_74779_i("channel");
        Intrinsics.checkNotNullExpressionValue(string, "nbt.getString(\"channel\")");
        this.setChannel(string);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.writeToNBT(nbt);
        nbt.func_74757_a("on", this.getOn());
        nbt.func_74780_a("charge", this.charge);
        nbt.func_74757_a("poweredByCable", this.getPoweredByCable());
        nbt.func_74778_a("channel", this.getChannel());
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    private static final void process$lambda$1(EmergencyLampElement this$0, SixNode $sixNode, double deltaT) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($sixNode, "$sixNode");
        if (!this$0.getPoweredByCable()) {
            LampSupplyElement.PowerSupplyChannelHandle closestPowerSupply = null;
            float closestDistance = 0.0f;
            closestDistance = 10000.0f;
            ArrayList<LampSupplyElement.PowerSupplyChannelHandle> arrayList = LampSupplyElement.channelMap.get(this$0.getChannel());
            if (arrayList != null) {
                Iterable $this$forEach$iv = arrayList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    LampSupplyElement.PowerSupplyChannelHandle it = (LampSupplyElement.PowerSupplyChannelHandle)element$iv;
                    boolean bl = false;
                    SixNode sixNode = it.element.sixNode;
                    Intrinsics.checkNotNull(sixNode);
                    float distance = (float)sixNode.coordinate.trueDistanceTo($sixNode.coordinate);
                    if (!(distance < closestDistance) || !(distance <= (float)it.element.getRange())) continue;
                    closestDistance = distance;
                    closestPowerSupply = it;
                }
            }
            if (closestPowerSupply != null) {
                this$0.setConnectedToLampSupply(true);
                if (closestPowerSupply.element.getChannelState(closestPowerSupply.id)) {
                    closestPowerSupply.element.addToRp(this$0.chargingResistor.getResistance());
                    this$0.load.state = closestPowerSupply.element.powerLoad.state;
                } else {
                    this$0.load.state = 0.0;
                }
            } else {
                this$0.setConnectedToLampSupply(false);
                this$0.load.state = 0.0;
            }
        }
        if (this$0.chargingResistor.getVoltage() > 0.5 * this$0.desc.getCable().electricalNominalVoltage) {
            this$0.setOn(false);
            if (this$0.charge < this$0.desc.getBatteryCapacity()) {
                this$0.chargingResistor.setState(true);
                this$0.charge = Math.min(this$0.charge + this$0.chargingResistor.getPower() * deltaT, this$0.desc.getBatteryCapacity());
            } else {
                this$0.chargingResistor.setState(false);
            }
        } else {
            this$0.chargingResistor.setState(false);
            if (this$0.charge > 0.0) {
                this$0.setOn(true);
                this$0.charge = Math.max(this$0.charge - this$0.desc.getConsumption() * deltaT, 0.0);
            } else {
                this$0.setOn(false);
            }
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(EmergencyLampElement.class, "on", "getOn()Z", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(EmergencyLampElement.class, "poweredByCable", "getPoweredByCable()Z", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(EmergencyLampElement.class, "channel", "getChannel()Ljava/lang/String;", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(EmergencyLampElement.class, "isConnectedToLampSupply", "isConnectedToLampSupply()Z", 0))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lmods/eln/sixnode/EmergencyLampElement$Event;", "", "value", "", "(Ljava/lang/String;IB)V", "getValue", "()B", "TOGGLE_POWERED_BY_CABLE", "SET_CHANNEL", "Eln"})
    public static final class Event
    extends Enum<Event> {
        private final byte value;
        public static final /* enum */ Event TOGGLE_POWERED_BY_CABLE = new Event(1);
        public static final /* enum */ Event SET_CHANNEL = new Event(2);
        private static final /* synthetic */ Event[] $VALUES;

        private Event(byte value) {
            this.value = value;
        }

        public final byte getValue() {
            return this.value;
        }

        public static Event[] values() {
            return (Event[])$VALUES.clone();
        }

        public static Event valueOf(String value) {
            return Enum.valueOf(Event.class, value);
        }

        static {
            $VALUES = eventArray = new Event[]{Event.TOGGLE_POWERED_BY_CABLE, Event.SET_CHANNEL};
        }
    }
}

