/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode;

import java.io.DataInputStream;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.EmergencyLampDescriptor;
import mods.eln.sixnode.EmergencyLampGui;
import net.minecraft.entity.player.EntityPlayer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010$\u001a\u00020%H\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020+2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u000200H\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u001a\u0010!\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001b\"\u0004\b#\u0010\u001d\u00a8\u00061"}, d2={"Lmods/eln/sixnode/EmergencyLampRender;", "Lmods/eln/node/six/SixNodeElementRender;", "entity", "Lmods/eln/node/six/SixNodeEntity;", "side", "Lmods/eln/misc/Direction;", "descriptor", "Lmods/eln/node/six/SixNodeDescriptor;", "(Lmods/eln/node/six/SixNodeEntity;Lmods/eln/misc/Direction;Lmods/eln/node/six/SixNodeDescriptor;)V", "channel", "", "getChannel", "()Ljava/lang/String;", "setChannel", "(Ljava/lang/String;)V", "charge", "", "getCharge", "()F", "setCharge", "(F)V", "desc", "Lmods/eln/sixnode/EmergencyLampDescriptor;", "getDesc", "()Lmods/eln/sixnode/EmergencyLampDescriptor;", "isConnectedToLampSupply", "", "()Z", "setConnectedToLampSupply", "(Z)V", "on", "getOn", "setOn", "poweredByCable", "getPoweredByCable", "setPoweredByCable", "draw", "", "getCableRender", "Lmods/eln/cable/CableRenderDescriptor;", "lrdu", "Lmods/eln/misc/LRDU;", "newGuiDraw", "Lmods/eln/sixnode/EmergencyLampGui;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "publishUnserialize", "stream", "Ljava/io/DataInputStream;", "Eln"})
public final class EmergencyLampRender
extends SixNodeElementRender {
    @NotNull
    private final EmergencyLampDescriptor desc;
    private float charge;
    private boolean on;
    private boolean poweredByCable;
    @NotNull
    private String channel;
    private boolean isConnectedToLampSupply;

    public EmergencyLampRender(@NotNull SixNodeEntity entity, @NotNull Direction side, @NotNull SixNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(entity, side, descriptor);
        this.desc = (EmergencyLampDescriptor)descriptor;
        this.channel = "Default channel";
    }

    @NotNull
    public final EmergencyLampDescriptor getDesc() {
        return this.desc;
    }

    public final float getCharge() {
        return this.charge;
    }

    public final void setCharge(float f) {
        this.charge = f;
    }

    public final boolean getOn() {
        return this.on;
    }

    public final void setOn(boolean bl) {
        this.on = bl;
    }

    public final boolean getPoweredByCable() {
        return this.poweredByCable;
    }

    public final void setPoweredByCable(boolean bl) {
        this.poweredByCable = bl;
    }

    @NotNull
    public final String getChannel() {
        return this.channel;
    }

    public final void setChannel(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.channel = string;
    }

    public final boolean isConnectedToLampSupply() {
        return this.isConnectedToLampSupply;
    }

    public final void setConnectedToLampSupply(boolean bl) {
        this.isConnectedToLampSupply = bl;
    }

    @Override
    public void draw() {
        super.draw();
        LRDU lRDU = this.front;
        Intrinsics.checkNotNull((Object)lRDU);
        lRDU.glRotateOnX();
        this.desc.draw(this.side == Direction.YP, this.on, this.front == LRDU.Up);
    }

    @Override
    public void publishUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.publishUnserialize(stream);
        this.charge = stream.readFloat();
        this.on = stream.readBoolean();
        this.poweredByCable = stream.readBoolean();
        String string = stream.readUTF();
        Intrinsics.checkNotNullExpressionValue(string, "stream.readUTF()");
        this.channel = string;
        this.isConnectedToLampSupply = stream.readBoolean();
    }

    @Override
    @NotNull
    public EmergencyLampGui newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        return new EmergencyLampGui(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public CableRenderDescriptor getCableRender(@NotNull LRDU lrdu) {
        CableRenderDescriptor cableRenderDescriptor;
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (!this.poweredByCable) return null;
        if (this.side == Direction.YP) {
            cableRenderDescriptor = this.desc.getCable().render;
            return cableRenderDescriptor;
        } else {
            LRDU lRDU = this.front;
            Intrinsics.checkNotNull((Object)lRDU);
            if (lrdu != lRDU.left()) {
                LRDU lRDU2 = this.front;
                Intrinsics.checkNotNull((Object)lRDU2);
                if (lrdu != lRDU2.right()) return null;
            }
            cableRenderDescriptor = this.desc.getCable().render;
        }
        return cableRenderDescriptor;
    }
}

