/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.item.IConfigurable;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.sixnode.AnalogChipElement;
import mods.eln.sixnode.AnalogFunction;
import mods.eln.sixnode.Filter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001#B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016R&\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8B@BX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006$"}, d2={"Lmods/eln/sixnode/FilterElement;", "Lmods/eln/sixnode/AnalogChipElement;", "Lmods/eln/item/IConfigurable;", "node", "Lmods/eln/node/six/SixNode;", "side", "Lmods/eln/misc/Direction;", "sixNodeDescriptor", "Lmods/eln/node/six/SixNodeDescriptor;", "(Lmods/eln/node/six/SixNode;Lmods/eln/misc/Direction;Lmods/eln/node/six/SixNodeDescriptor;)V", "value", "", "cutOffFrequency", "getCutOffFrequency", "()D", "setCutOffFrequency", "(D)V", "ghostObserverCoordonate", "Lmods/eln/misc/Coordinate;", "getGhostObserverCoordonate", "()Lmods/eln/misc/Coordinate;", "hasGui", "", "networkSerialize", "", "stream", "Ljava/io/DataOutputStream;", "networkUnserialize", "Ljava/io/DataInputStream;", "readConfigTool", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "invoker", "Lnet/minecraft/entity/player/EntityPlayer;", "writeConfigTool", "Event", "Eln"})
public final class FilterElement
extends AnalogChipElement
implements IConfigurable {
    private double cutOffFrequency;

    public FilterElement(@NotNull SixNode node, @NotNull Direction side, @NotNull SixNodeDescriptor sixNodeDescriptor) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(sixNodeDescriptor, "sixNodeDescriptor");
        super(node, side, sixNodeDescriptor);
        this.cutOffFrequency = Eln.instance.electricalFrequency / 4.0;
    }

    private final double getCutOffFrequency() {
        AnalogFunction analogFunction = this.getFunction();
        Intrinsics.checkNotNull(analogFunction, "null cannot be cast to non-null type mods.eln.sixnode.Filter");
        return ((Filter)analogFunction).getFeedback$Eln() / (Math.PI * 2);
    }

    private final void setCutOffFrequency(double value) {
        this.cutOffFrequency = value;
        AnalogFunction analogFunction = this.getFunction();
        Intrinsics.checkNotNull(analogFunction, "null cannot be cast to non-null type mods.eln.sixnode.Filter");
        ((Filter)analogFunction).setFeedback$Eln(Math.PI * 2 * this.cutOffFrequency);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        try {
            stream.writeFloat((float)this.getCutOffFrequency());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @NotNull
    public Coordinate getGhostObserverCoordonate() {
        Coordinate coordinate = this.getCoordinate();
        Intrinsics.checkNotNull(coordinate);
        return coordinate;
    }

    @Override
    public void networkUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkUnserialize(stream);
        try {
            if (stream.readByte() == Event.CUTOFF_FREQUENCY_CHANGED.getValue()) {
                this.setCutOffFrequency(stream.readFloat());
            }
            this.needPublish();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void readConfigTool(@NotNull NBTTagCompound compound, @NotNull EntityPlayer invoker) {
        Intrinsics.checkNotNullParameter(compound, "compound");
        Intrinsics.checkNotNullParameter(invoker, "invoker");
        if (compound.func_74764_b("cutoff")) {
            this.setCutOffFrequency(compound.func_74769_h("cutoff"));
        }
    }

    @Override
    public void writeConfigTool(@NotNull NBTTagCompound compound, @NotNull EntityPlayer invoker) {
        Intrinsics.checkNotNullParameter(compound, "compound");
        Intrinsics.checkNotNullParameter(invoker, "invoker");
        compound.func_74780_a("cutoff", this.getCutOffFrequency());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lmods/eln/sixnode/FilterElement$Event;", "", "value", "", "(Ljava/lang/String;IB)V", "getValue", "()B", "CUTOFF_FREQUENCY_CHANGED", "Eln"})
    public static final class Event
    extends Enum<Event> {
        private final byte value;
        public static final /* enum */ Event CUTOFF_FREQUENCY_CHANGED = new Event(1);
        private static final /* synthetic */ Event[] $VALUES;

        private Event(byte value) {
            this.value = value;
        }

        public final byte getValue() {
            return this.value;
        }

        public static Event[] values() {
            return (Event[])$VALUES.clone();
        }

        public static Event valueOf(String value) {
            return Enum.valueOf(Event.class, value);
        }

        static {
            $VALUES = eventArray = new Event[]{Event.CUTOFF_FREQUENCY_CHANGED};
        }
    }
}

