/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode;

import mods.eln.i18n.I18N;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.sixnode.AnalogFunction;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u0010R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lmods/eln/sixnode/OpAmp;", "Lmods/eln/sixnode/AnalogFunction;", "()V", "infos", "", "getInfos", "()Ljava/lang/String;", "inputCount", "", "getInputCount", "()I", "process", "", "inputs", "", "deltaTime", "([Ljava/lang/Double;D)D", "Eln"})
public final class OpAmp
extends AnalogFunction {
    private final int inputCount;
    @NotNull
    private final String infos;

    public OpAmp() {
        this.inputCount = 2;
        String string = I18N.tr("Operational Amplifier - DC coupled\nhigh-gain voltage amplifier with\ndifferential input. Can be used to\ncompare voltages or as configurable amplifier.", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string, "tr(\"Operational Amplifie\u2026configurable amplifier.\")");
        this.infos = string;
    }

    @Override
    public int getInputCount() {
        return this.inputCount;
    }

    @Override
    @NotNull
    public String getInfos() {
        return this.infos;
    }

    @Override
    public double process(@NotNull Double[] inputs, double deltaTime) {
        Intrinsics.checkNotNullParameter(inputs, "inputs");
        Double d = inputs[0];
        Double d2 = inputs[1];
        return (double)10000 * ((d != null ? d : 0.0) - (d2 != null ? d2 : 0.0));
    }
}

