/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode;

import java.util.Map;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.sixnode.AnalogFunction;
import mods.eln.solver.Equation;
import mods.eln.solver.IValue;
import net.minecraft.nbt.NBTTagCompound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J1\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u001f2\u000e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040!2\u0006\u0010\"\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010#J%\u0010$\u001a\u00020\u00042\u000e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040!2\u0006\u0010%\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010&J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0014H\u0016J\u0018\u0010,\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0014H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lmods/eln/sixnode/PIDRegulator;", "Lmods/eln/sixnode/AnalogFunction;", "()V", "Kd", "", "getKd$Eln", "()D", "setKd$Eln", "(D)V", "Ki", "getKi$Eln", "setKi$Eln", "Kp", "getKp$Eln", "setKp$Eln", "hasState", "", "getHasState", "()Z", "infos", "", "mods.eln.shadow.kotlin.jvm.PlatformType", "getInfos", "()Ljava/lang/String;", "inputCount", "", "getInputCount", "()I", "pid", "Lmods/eln/solver/Equation$Pid;", "getWaila", "", "inputs", "", "output", "([Ljava/lang/Double;D)Ljava/util/Map;", "process", "deltaTime", "([Ljava/lang/Double;D)D", "readFromNBT", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "str", "writeToNBT", "Eln"})
public final class PIDRegulator
extends AnalogFunction {
    private final boolean hasState;
    private final int inputCount;
    private final String infos = I18N.tr("Proportional\u2013integral\u2013derivative controller. A PID\ncontroller continuously calculates an error value as\nthe difference between a desired setpoint and a measured\nprocess variable and applies a correction based on\nproportional, integral, and derivative terms.", new Object[0]);
    private double Kp = 1.0;
    private double Ki;
    private double Kd;
    @NotNull
    private final Equation.Pid pid = new Equation.Pid();

    public PIDRegulator() {
        this.hasState = true;
        this.inputCount = 2;
    }

    @Override
    public boolean getHasState() {
        return this.hasState;
    }

    @Override
    public int getInputCount() {
        return this.inputCount;
    }

    @Override
    public String getInfos() {
        return this.infos;
    }

    public final double getKp$Eln() {
        return this.Kp;
    }

    public final void setKp$Eln(double d) {
        this.Kp = d;
    }

    public final double getKi$Eln() {
        return this.Ki;
    }

    public final void setKi$Eln(double d) {
        this.Ki = d;
    }

    public final double getKd$Eln() {
        return this.Kd;
    }

    public final void setKd$Eln(double d) {
        this.Kd = d;
    }

    @Override
    public double process(@NotNull Double[] inputs, double deltaTime) {
        Intrinsics.checkNotNullParameter(inputs, "inputs");
        IValue[] iValueArray = new IValue[]{() -> PIDRegulator.process$lambda$0(inputs), () -> PIDRegulator.process$lambda$1(inputs), () -> PIDRegulator.process$lambda$2(this), () -> PIDRegulator.process$lambda$3(this), () -> PIDRegulator.process$lambda$4(this)};
        this.pid.setOperator(iValueArray);
        this.pid.process(deltaTime);
        return 5.0 * this.pid.getValue();
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt, @NotNull String str) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter(str, "str");
        this.Kp = nbt.func_74769_h("Kp");
        this.Ki = nbt.func_74769_h("Ki");
        this.Kd = nbt.func_74769_h("Kd");
        this.pid.readFromNBT(nbt, "pid");
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt, @NotNull String str) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter(str, "str");
        nbt.func_74780_a("Kp", this.Kp);
        nbt.func_74780_a("Ki", this.Ki);
        nbt.func_74780_a("Kd", this.Kd);
        this.pid.writeToNBT(nbt, "pid");
    }

    @Override
    @NotNull
    public Map<String, String> getWaila(@NotNull Double[] inputs, double output) {
        Map<String, String> info;
        Intrinsics.checkNotNullParameter(inputs, "inputs");
        Map<String, String> map = info = super.getWaila(inputs, output);
        String string = I18N.tr("Params", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string, "tr(\"Params\")");
        String string2 = string;
        String string3 = "Kp = " + this.Kp + ", Ki = " + this.Ki + ", Kd = " + this.Kd;
        map.put(string2, string3);
        if (Eln.wailaEasyMode) {
            map = info;
            String string4 = I18N.tr("State", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string4, "tr(\"State\")");
            string2 = string4;
            string3 = "Si = " + this.pid.iStack;
            map.put(string2, string3);
        }
        return info;
    }

    private static final double process$lambda$0(Double[] $inputs) {
        Intrinsics.checkNotNullParameter($inputs, "$inputs");
        Double d = $inputs[0];
        return (d != null ? d : 0.0) / 5.0;
    }

    private static final double process$lambda$1(Double[] $inputs) {
        Intrinsics.checkNotNullParameter($inputs, "$inputs");
        Double d = $inputs[1];
        return (d != null ? d : 0.0) / 5.0;
    }

    private static final double process$lambda$2(PIDRegulator this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return this$0.Kp;
    }

    private static final double process$lambda$3(PIDRegulator this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return this$0.Ki;
    }

    private static final double process$lambda$4(PIDRegulator this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return this$0.Kd;
    }
}

