/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode;

import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sixnode.PortableNaNDescriptor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u000e\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0015H\u0016J\u0018\u0010\u0012\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0015H\u0016J\u0014\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001dH\u0016J\b\u0010!\u001a\u00020\u001dH\u0016R\u0011\u0010\u0006\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lmods/eln/sixnode/PortableNaNElement;", "Lmods/eln/node/six/SixNodeElement;", "sixNode", "Lmods/eln/node/six/SixNode;", "side", "Lmods/eln/misc/Direction;", "descriptor", "Lmods/eln/node/six/SixNodeDescriptor;", "(Lmods/eln/node/six/SixNode;Lmods/eln/misc/Direction;Lmods/eln/node/six/SixNodeDescriptor;)V", "Lmods/eln/sixnode/PortableNaNDescriptor;", "getDescriptor", "()Lmods/eln/sixnode/PortableNaNDescriptor;", "electricalLoad", "Lmods/eln/sim/nbt/NbtElectricalLoad;", "getElectricalLoad", "()Lmods/eln/sim/nbt/NbtElectricalLoad;", "thermalLoad", "Lmods/eln/sim/nbt/NbtThermalLoad;", "getThermalLoad", "()Lmods/eln/sim/nbt/NbtThermalLoad;", "getConnectionMask", "", "lrdu", "Lmods/eln/misc/LRDU;", "Lmods/eln/sim/ElectricalLoad;", "mask", "Lmods/eln/sim/ThermalLoad;", "getWaila", "", "", "initialize", "", "multiMeterString", "thermoMeterString", "Eln"})
public final class PortableNaNElement
extends SixNodeElement {
    @NotNull
    private final NbtElectricalLoad electricalLoad;
    @NotNull
    private final NbtThermalLoad thermalLoad;
    @NotNull
    private final PortableNaNDescriptor descriptor;

    public PortableNaNElement(@NotNull SixNode sixNode, @NotNull Direction side, @NotNull SixNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(sixNode, "sixNode");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(sixNode, side, descriptor);
        this.electricalLoad = new NbtElectricalLoad("Portable NaN");
        this.thermalLoad = new NbtThermalLoad("Portable NaN");
        this.descriptor = (PortableNaNDescriptor)descriptor;
        this.electricalLoadList.add(this.electricalLoad);
        this.thermalLoadList.add(this.thermalLoad);
        this.thermalLoad.setAsSlow();
    }

    @NotNull
    public final NbtElectricalLoad getElectricalLoad() {
        return this.electricalLoad;
    }

    @NotNull
    public final NbtThermalLoad getThermalLoad() {
        return this.thermalLoad;
    }

    @NotNull
    public final PortableNaNDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    @NotNull
    public ElectricalLoad getElectricalLoad(@NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return this.electricalLoad;
    }

    @Override
    @NotNull
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        this.thermalLoad.movePowerTo(Double.NaN);
        return this.thermalLoad;
    }

    @Override
    public int getConnectionMask(@NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return this.descriptor.getNodeMask();
    }

    @Override
    public void initialize() {
        this.descriptor.applyTo(this.electricalLoad);
        this.descriptor.applyTo(this.thermalLoad);
    }

    @Override
    @NotNull
    public String multiMeterString() {
        return Utils.plotUIP(this.electricalLoad.getVoltage(), this.electricalLoad.getCurrent());
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return Utils.plotCelsius("T", this.thermalLoad.temperatureCelsius);
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap info = new HashMap();
        Map map = info;
        String string = I18N.tr("Current", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string, "tr(\"Current\")");
        String string2 = string;
        String string3 = Utils.plotAmpere("", this.electricalLoad.getCurrent());
        map.put(string2, string3);
        map = info;
        String string4 = I18N.tr("Temperature", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string4, "tr(\"Temperature\")");
        string2 = string4;
        string3 = Utils.plotCelsius("", this.thermalLoad.getTemperature());
        map.put(string2, string3);
        if (Eln.wailaEasyMode) {
            map = info;
            String string5 = I18N.tr("Voltage", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string5, "tr(\"Voltage\")");
            string2 = string5;
            string3 = Utils.plotVolt("", this.electricalLoad.getVoltage());
            map.put(string2, string3);
        }
        map = info;
        String string6 = I18N.tr("Subsystem Matrix Size", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string6, "tr(\"Subsystem Matrix Size\")");
        string2 = string6;
        string3 = Utils.renderSubSystemWaila(this.electricalLoad.getSubSystem());
        map.put(string2, string3);
        return info;
    }
}

