/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode;

import java.util.Arrays;
import java.util.List;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.i18n.I18N;
import mods.eln.item.DielectricItem;
import mods.eln.misc.Direction;
import mods.eln.misc.IFunction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.RealisticEnum;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.PowerCapacitorSixElement;
import mods.eln.sixnode.PowerCapacitorSixRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ4\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\"2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001eH\u0016J\u0006\u0010#\u001a\u00020\u0018J\u0016\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\tJ\u000e\u0010$\u001a\u00020\t2\u0006\u0010(\u001a\u00020)J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u001cH\u0016J\u000e\u0010/\u001a\u00020\t2\u0006\u0010(\u001a\u00020)J\u0018\u00100\u001a\u00020 2\u0006\u00101\u001a\u00020\u001a2\u0006\u00102\u001a\u000203H\u0016J1\u00104\u001a\u00020\u00182\u0006\u00102\u001a\u0002032\u0006\u00101\u001a\u00020\u001a2\u0012\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u00020706\"\u000207H\u0016\u00a2\u0006\u0002\u00108J\u0018\u00109\u001a\u00020\u00182\u0006\u00101\u001a\u00020:2\u0006\u0010;\u001a\u00020&H\u0016J \u0010<\u001a\u00020 2\u0006\u00102\u001a\u0002032\u0006\u00101\u001a\u00020\u001a2\u0006\u0010=\u001a\u00020>H\u0016R\u0014\u0010\u000b\u001a\b\u0018\u00010\fR\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0018\u00010\fR\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0018\u00010\fR\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006?"}, d2={"Lmods/eln/sixnode/PowerCapacitorSixDescriptor;", "Lmods/eln/node/six/SixNodeDescriptor;", "name", "", "obj", "Lmods/eln/misc/Obj3D;", "serie", "Lmods/eln/misc/IFunction;", "dischargeTao", "", "(Ljava/lang/String;Lmods/eln/misc/Obj3D;Lmods/eln/misc/IFunction;D)V", "Base", "Lmods/eln/misc/Obj3D$Obj3DPart;", "CapacitorCables", "CapacitorCore", "getDischargeTao", "()D", "setDischargeTao", "(D)V", "getSerie", "()Lmods/eln/misc/IFunction;", "setSerie", "(Lmods/eln/misc/IFunction;)V", "addInformation", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "list", "", "par4", "", "addRealismContext", "Lmods/eln/misc/RealisticEnum;", "draw", "getCValue", "cableCount", "", "nominalDielVoltage", "inventory", "Lnet/minecraft/inventory/IInventory;", "getFrontFromPlace", "Lmods/eln/misc/LRDU;", "side", "Lmods/eln/misc/Direction;", "player", "getUNominalValue", "handleRenderType", "item", "type", "Lnet/minecraftforge/client/IItemRenderer$ItemRenderType;", "renderItem", "data", "", "", "(Lnet/minecraftforge/client/IItemRenderer$ItemRenderType;Lnet/minecraft/item/ItemStack;[Ljava/lang/Object;)V", "setParent", "Lnet/minecraft/item/Item;", "damage", "shouldUseRenderHelper", "helper", "Lnet/minecraftforge/client/IItemRenderer$ItemRendererHelper;", "Eln"})
public final class PowerCapacitorSixDescriptor
extends SixNodeDescriptor {
    @NotNull
    private IFunction serie;
    private double dischargeTao;
    @Nullable
    private Obj3D.Obj3DPart CapacitorCore;
    @Nullable
    private Obj3D.Obj3DPart CapacitorCables;
    @Nullable
    private Obj3D.Obj3DPart Base;

    public PowerCapacitorSixDescriptor(@NotNull String name, @NotNull Obj3D obj, @NotNull IFunction serie, double dischargeTao) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(obj, "obj");
        Intrinsics.checkNotNullParameter(serie, "serie");
        super(name, PowerCapacitorSixElement.class, PowerCapacitorSixRender.class);
        this.serie = serie;
        this.dischargeTao = dischargeTao;
        this.CapacitorCables = obj.getPart("CapacitorCables");
        this.CapacitorCore = obj.getPart("CapacitorCore");
        this.Base = obj.getPart("Base");
        this.voltageLevelColor = VoltageLevelColor.Neutral;
    }

    @NotNull
    public final IFunction getSerie() {
        return this.serie;
    }

    public final void setSerie(@NotNull IFunction iFunction) {
        Intrinsics.checkNotNullParameter(iFunction, "<set-?>");
        this.serie = iFunction;
    }

    public final double getDischargeTao() {
        return this.dischargeTao;
    }

    public final void setDischargeTao(double d) {
        this.dischargeTao = d;
    }

    public final double getCValue(int cableCount, double nominalDielVoltage) {
        if (cableCount == 0) {
            return 1.0E-6;
        }
        double uTemp = nominalDielVoltage / 50.0;
        return this.serie.getValue((double)(cableCount - 1) / uTemp / uTemp);
    }

    public final double getCValue(@NotNull IInventory inventory) {
        Intrinsics.checkNotNullParameter(inventory, "inventory");
        ItemStack core = inventory.func_70301_a(0);
        ItemStack diel = inventory.func_70301_a(1);
        return core == null || diel == null ? this.getCValue(0, 0.0) : this.getCValue(core.field_77994_a, this.getUNominalValue(inventory));
    }

    public final double getUNominalValue(@NotNull IInventory inventory) {
        double d;
        Intrinsics.checkNotNullParameter(inventory, "inventory");
        ItemStack diel = inventory.func_70301_a(1);
        if (diel == null) {
            d = 10000.0;
        } else {
            GenericItemUsingDamageDescriptor genericItemUsingDamageDescriptor = GenericItemUsingDamageDescriptor.Companion.getDescriptor(diel);
            Intrinsics.checkNotNull(genericItemUsingDamageDescriptor, "null cannot be cast to non-null type mods.eln.item.DielectricItem");
            DielectricItem desc = (DielectricItem)genericItemUsingDamageDescriptor;
            d = desc.uNominal * (double)diel.field_77994_a;
        }
        return d;
    }

    @Override
    public void setParent(@NotNull Item item, int damage) {
        Intrinsics.checkNotNullParameter(item, "item");
        super.setParent(item, damage);
        Data.addEnergy(this.newItemStack());
    }

    public final void draw() {
        if (this.Base != null) {
            Obj3D.Obj3DPart obj3DPart = this.Base;
            Intrinsics.checkNotNull(obj3DPart);
            obj3DPart.draw();
        }
        if (this.CapacitorCables != null) {
            Obj3D.Obj3DPart obj3DPart = this.CapacitorCables;
            Intrinsics.checkNotNull(obj3DPart);
            obj3DPart.draw();
        }
        if (this.CapacitorCore != null) {
            Obj3D.Obj3DPart obj3DPart = this.CapacitorCore;
            Intrinsics.checkNotNull(obj3DPart);
            obj3DPart.draw();
        }
    }

    @Override
    public boolean shouldUseRenderHelper(@NotNull IItemRenderer.ItemRenderType type, @NotNull ItemStack item, @NotNull IItemRenderer.ItemRendererHelper helper) {
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(helper, "helper");
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(@NotNull ItemStack item, @NotNull IItemRenderer.ItemRenderType type) {
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(type, "type");
        return true;
    }

    @Override
    public void renderItem(@NotNull IItemRenderer.ItemRenderType type, @NotNull ItemStack item, Object ... data) {
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(data, "data");
        if (type != IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.2f);
            GL11.glScalef((float)1.25f, (float)1.25f, (float)1.25f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.draw();
        } else {
            super.renderItem(type, item, Arrays.copyOf(data, data.length));
        }
    }

    @Override
    public void addInformation(@Nullable ItemStack itemStack, @Nullable EntityPlayer entityPlayer, @Nullable List<String> list, boolean par4) {
        block0: {
            super.addInformation(itemStack, entityPlayer, list, par4);
            List<String> list2 = list;
            if (list2 == null) break block0;
            String string = I18N.tr("Provides capacitance. Use with dielectrics and redstone", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string, "tr(\"Provides capacitance\u2026ielectrics and redstone\")");
            list2.add(string);
        }
    }

    @Override
    @NotNull
    public RealisticEnum addRealismContext(@Nullable List<String> list) {
        block0: {
            super.addRealismContext(list);
            List<String> list2 = list;
            if (list2 == null) break block0;
            String string = I18N.tr("It doesn't really behave well for DC", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string, "tr(\"It doesn't really behave well for DC\")");
            list2.add(string);
        }
        return RealisticEnum.UNREALISTIC;
    }

    @Override
    @NotNull
    public LRDU getFrontFromPlace(@NotNull Direction side, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        LRDU lRDU = super.getFrontFromPlace(side, player);
        Intrinsics.checkNotNull((Object)lRDU);
        return lRDU.left();
    }
}

