/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode;

import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.i18n.I18N;
import mods.eln.item.IConfigurable;
import mods.eln.item.ItemMovingHelper;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Capacitor;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.BipoleVoltageWatchdog;
import mods.eln.sim.process.destruct.ValueWatchdog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sixnode.PowerCapacitorSixContainer;
import mods.eln.sixnode.PowerCapacitorSixDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002:\u0001aB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0016J\u001a\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010D\u001a\u00020E2\u0006\u0010H\u001a\u00020CH\u0016J\u001a\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010D\u001a\u00020E2\u0006\u0010H\u001a\u00020CH\u0016J\u0014\u0010K\u001a\u000e\u0012\u0004\u0012\u00020M\u0012\u0004\u0012\u00020M0LH\u0016J\b\u0010N\u001a\u00020\u001cH\u0016J\b\u0010O\u001a\u00020PH\u0016J\b\u0010Q\u001a\u00020PH\u0016J\b\u0010R\u001a\u00020MH\u0016J\u0018\u0010S\u001a\u00020T2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010U\u001a\u00020VH\u0016J\u0018\u0010W\u001a\u00020P2\u0006\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020VH\u0016J\u0010\u0010[\u001a\u00020P2\u0006\u0010\\\u001a\u00020YH\u0016J\u0006\u0010]\u001a\u00020PJ\b\u0010^\u001a\u00020MH\u0016J\u0018\u0010_\u001a\u00020P2\u0006\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020VH\u0016J\u0010\u0010`\u001a\u00020P2\u0006\u0010\\\u001a\u00020YH\u0016R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0007\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010*\"\u0004\b/\u0010,R\u001e\u00100\u001a\u000601R\u00020\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u00106\u001a\u000207X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u001a\u0010<\u001a\u00020=X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010A\u00a8\u0006b"}, d2={"Lmods/eln/sixnode/PowerCapacitorSixElement;", "Lmods/eln/node/six/SixNodeElement;", "Lmods/eln/item/IConfigurable;", "SixNode", "Lmods/eln/node/six/SixNode;", "side", "Lmods/eln/misc/Direction;", "descriptor", "Lmods/eln/node/six/SixNodeDescriptor;", "(Lmods/eln/node/six/SixNode;Lmods/eln/misc/Direction;Lmods/eln/node/six/SixNodeDescriptor;)V", "capacitor", "Lmods/eln/sim/mna/component/Capacitor;", "getCapacitor", "()Lmods/eln/sim/mna/component/Capacitor;", "setCapacitor", "(Lmods/eln/sim/mna/component/Capacitor;)V", "Lmods/eln/sixnode/PowerCapacitorSixDescriptor;", "getDescriptor", "()Lmods/eln/sixnode/PowerCapacitorSixDescriptor;", "setDescriptor", "(Lmods/eln/sixnode/PowerCapacitorSixDescriptor;)V", "dischargeResistor", "Lmods/eln/sim/mna/component/Resistor;", "getDischargeResistor", "()Lmods/eln/sim/mna/component/Resistor;", "setDischargeResistor", "(Lmods/eln/sim/mna/component/Resistor;)V", "fromNbt", "", "getFromNbt", "()Z", "setFromNbt", "(Z)V", "inventory", "Lmods/eln/node/six/SixNodeElementInventory;", "getInventory", "()Lmods/eln/node/six/SixNodeElementInventory;", "setInventory", "(Lmods/eln/node/six/SixNodeElementInventory;)V", "negativeLoad", "Lmods/eln/sim/nbt/NbtElectricalLoad;", "getNegativeLoad", "()Lmods/eln/sim/nbt/NbtElectricalLoad;", "setNegativeLoad", "(Lmods/eln/sim/nbt/NbtElectricalLoad;)V", "positiveLoad", "getPositiveLoad", "setPositiveLoad", "punkProcess", "Lmods/eln/sixnode/PowerCapacitorSixElement$PunkProcess;", "getPunkProcess", "()Lmods/eln/sixnode/PowerCapacitorSixElement$PunkProcess;", "setPunkProcess", "(Lmods/eln/sixnode/PowerCapacitorSixElement$PunkProcess;)V", "stdDischargeResistor", "", "getStdDischargeResistor", "()D", "setStdDischargeResistor", "(D)V", "voltageWatchdog", "Lmods/eln/sim/process/destruct/ValueWatchdog;", "getVoltageWatchdog", "()Lmods/eln/sim/process/destruct/ValueWatchdog;", "setVoltageWatchdog", "(Lmods/eln/sim/process/destruct/ValueWatchdog;)V", "getConnectionMask", "", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "mask", "getThermalLoad", "Lmods/eln/sim/ThermalLoad;", "getWaila", "", "", "hasGui", "initialize", "", "inventoryChanged", "multiMeterString", "newContainer", "Lnet/minecraft/inventory/Container;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "readConfigTool", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "invoker", "readFromNBT", "nbt", "setupPhysical", "thermoMeterString", "writeConfigTool", "writeToNBT", "PunkProcess", "Eln"})
public final class PowerCapacitorSixElement
extends SixNodeElement
implements IConfigurable {
    @NotNull
    private PowerCapacitorSixDescriptor descriptor;
    @NotNull
    private SixNodeElementInventory inventory;
    @NotNull
    private NbtElectricalLoad positiveLoad;
    @NotNull
    private NbtElectricalLoad negativeLoad;
    @NotNull
    private Capacitor capacitor;
    @NotNull
    private Resistor dischargeResistor;
    @NotNull
    private PunkProcess punkProcess;
    @NotNull
    private ValueWatchdog voltageWatchdog;
    private double stdDischargeResistor;
    private boolean fromNbt;

    public PowerCapacitorSixElement(@NotNull SixNode SixNode2, @NotNull Direction side, @NotNull SixNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(SixNode2, "SixNode");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(SixNode2, side, descriptor);
        this.descriptor = (PowerCapacitorSixDescriptor)descriptor;
        this.inventory = new SixNodeElementInventory(2, 64, this);
        this.positiveLoad = new NbtElectricalLoad("positiveLoad");
        this.negativeLoad = new NbtElectricalLoad("negativeLoad");
        this.capacitor = new Capacitor(this.positiveLoad, this.negativeLoad);
        this.dischargeResistor = new Resistor(this.positiveLoad, this.negativeLoad);
        this.punkProcess = new PunkProcess();
        this.voltageWatchdog = new BipoleVoltageWatchdog(this.capacitor).setNominalVoltage(this.descriptor.getUNominalValue(this.getInventory())).setDestroys(new WorldExplosion(this).cableExplosion());
        this.electricalLoadList.add(this.positiveLoad);
        this.electricalLoadList.add(this.negativeLoad);
        this.electricalComponentList.add(this.capacitor);
        this.electricalComponentList.add(this.dischargeResistor);
        this.electricalProcessList.add(this.punkProcess);
        this.slowProcessList.add(this.voltageWatchdog);
        this.positiveLoad.setAsMustBeFarFromInterSystem();
    }

    @NotNull
    public final PowerCapacitorSixDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final void setDescriptor(@NotNull PowerCapacitorSixDescriptor powerCapacitorSixDescriptor) {
        Intrinsics.checkNotNullParameter(powerCapacitorSixDescriptor, "<set-?>");
        this.descriptor = powerCapacitorSixDescriptor;
    }

    @Override
    @NotNull
    public SixNodeElementInventory getInventory() {
        return this.inventory;
    }

    public void setInventory(@NotNull SixNodeElementInventory sixNodeElementInventory) {
        Intrinsics.checkNotNullParameter(sixNodeElementInventory, "<set-?>");
        this.inventory = sixNodeElementInventory;
    }

    @NotNull
    public final NbtElectricalLoad getPositiveLoad() {
        return this.positiveLoad;
    }

    public final void setPositiveLoad(@NotNull NbtElectricalLoad nbtElectricalLoad) {
        Intrinsics.checkNotNullParameter(nbtElectricalLoad, "<set-?>");
        this.positiveLoad = nbtElectricalLoad;
    }

    @NotNull
    public final NbtElectricalLoad getNegativeLoad() {
        return this.negativeLoad;
    }

    public final void setNegativeLoad(@NotNull NbtElectricalLoad nbtElectricalLoad) {
        Intrinsics.checkNotNullParameter(nbtElectricalLoad, "<set-?>");
        this.negativeLoad = nbtElectricalLoad;
    }

    @NotNull
    public final Capacitor getCapacitor() {
        return this.capacitor;
    }

    public final void setCapacitor(@NotNull Capacitor capacitor) {
        Intrinsics.checkNotNullParameter(capacitor, "<set-?>");
        this.capacitor = capacitor;
    }

    @NotNull
    public final Resistor getDischargeResistor() {
        return this.dischargeResistor;
    }

    public final void setDischargeResistor(@NotNull Resistor resistor) {
        Intrinsics.checkNotNullParameter(resistor, "<set-?>");
        this.dischargeResistor = resistor;
    }

    @NotNull
    public final PunkProcess getPunkProcess() {
        return this.punkProcess;
    }

    public final void setPunkProcess(@NotNull PunkProcess punkProcess) {
        Intrinsics.checkNotNullParameter(punkProcess, "<set-?>");
        this.punkProcess = punkProcess;
    }

    @NotNull
    public final ValueWatchdog getVoltageWatchdog() {
        return this.voltageWatchdog;
    }

    public final void setVoltageWatchdog(@NotNull ValueWatchdog valueWatchdog) {
        Intrinsics.checkNotNullParameter(valueWatchdog, "<set-?>");
        this.voltageWatchdog = valueWatchdog;
    }

    public final double getStdDischargeResistor() {
        return this.stdDischargeResistor;
    }

    public final void setStdDischargeResistor(double d) {
        this.stdDischargeResistor = d;
    }

    public final boolean getFromNbt() {
        return this.fromNbt;
    }

    public final void setFromNbt(boolean bl) {
        this.fromNbt = bl;
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (lrdu == this.front.right()) {
            return this.positiveLoad;
        }
        return lrdu == this.front.left() ? (ElectricalLoad)this.negativeLoad : null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return null;
    }

    @Override
    public int getConnectionMask(@NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (lrdu == this.front.right()) {
            return 1;
        }
        return lrdu == this.front.left() ? 1 : 0;
    }

    @Override
    @NotNull
    public String multiMeterString() {
        return Utils.plotVolt("U", Math.abs(this.capacitor.getVoltage())) + Utils.plotAmpere("I", this.capacitor.getCurrent());
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        Map info;
        Map map = info = (Map)new HashMap();
        String string = I18N.tr("Capacity", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string, "tr(\"Capacity\")");
        String string2 = string;
        String string3 = Utils.plotValue(this.capacitor.getCoulombs(), "F");
        map.put(string2, string3);
        map = info;
        String string4 = I18N.tr("Charge", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string4, "tr(\"Charge\")");
        string2 = string4;
        string3 = Utils.plotEnergy("", this.capacitor.getEnergy());
        map.put(string2, string3);
        if (Eln.wailaEasyMode) {
            map = info;
            String string5 = I18N.tr("Voltage drop", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string5, "tr(\"Voltage drop\")");
            string2 = string5;
            string3 = Utils.plotVolt("", Math.abs(this.capacitor.getVoltage()));
            map.put(string2, string3);
            map = info;
            String string6 = I18N.tr("Current", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string6, "tr(\"Current\")");
            string2 = string6;
            string3 = Utils.plotAmpere("", Math.abs(this.capacitor.getCurrent()));
            map.put(string2, string3);
        }
        return info;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void initialize() {
        Eln.applySmallRs(this.positiveLoad);
        Eln.applySmallRs(this.negativeLoad);
        this.setupPhysical();
    }

    @Override
    public void inventoryChanged() {
        super.inventoryChanged();
        this.setupPhysical();
    }

    public final void setupPhysical() {
        double eOld = this.capacitor.getEnergy();
        this.capacitor.setCoulombs(this.descriptor.getCValue(this.getInventory()));
        this.stdDischargeResistor = this.descriptor.getDischargeTao() / this.capacitor.getCoulombs();
        this.punkProcess.setELegaliseResistor(Math.pow(this.descriptor.getUNominalValue(this.getInventory()), 2.0) / (double)400);
        if (this.fromNbt) {
            this.dischargeResistor.setResistance(this.stdDischargeResistor);
            this.fromNbt = false;
        } else {
            double deltaE = this.capacitor.getEnergy() - eOld;
            PunkProcess punkProcess = this.punkProcess;
            punkProcess.setELeft(punkProcess.getELeft() + deltaE);
            if (deltaE < 0.0) {
                this.dischargeResistor.setResistance(this.stdDischargeResistor);
            } else {
                this.dischargeResistor.setResistance(this.punkProcess.getELegaliseResistor());
            }
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.writeToNBT(nbt);
        nbt.func_74780_a("punkELeft", this.punkProcess.getELeft());
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.readFromNBT(nbt);
        this.punkProcess.setELeft(nbt.func_74769_h("punkELeft"));
        if (Double.isNaN(this.punkProcess.getELeft())) {
            this.punkProcess.setELeft(0.0);
        }
        this.fromNbt = true;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    @NotNull
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        return new PowerCapacitorSixContainer(player, this.getInventory());
    }

    @Override
    public void readConfigTool(@NotNull NBTTagCompound compound, @NotNull EntityPlayer invoker) {
        int desired;
        Intrinsics.checkNotNullParameter(compound, "compound");
        Intrinsics.checkNotNullParameter(invoker, "invoker");
        if (compound.func_74764_b("capRedstoneAmt")) {
            desired = compound.func_74762_e("capRedstoneAmt");
            new ItemMovingHelper(){

                public boolean acceptsStack(@NotNull ItemStack stack) {
                    Intrinsics.checkNotNullParameter(stack, "stack");
                    return stack.func_77973_b() == Items.field_151137_ax;
                }

                @NotNull
                public ItemStack newStackOfSize(int size) {
                    return new ItemStack(Items.field_151137_ax, size);
                }
            }.move(invoker.field_71071_by, this.getInventory(), 0, desired);
            this.reconnect();
        }
        if (compound.func_74764_b("capDielectricAmt")) {
            desired = compound.func_74762_e("capDielectricAmt");
            GenericItemUsingDamageDescriptor dielectric = GenericItemUsingDamageDescriptor.Companion.getByName("Dielectric");
            new ItemMovingHelper(dielectric){
                final /* synthetic */ GenericItemUsingDamageDescriptor $dielectric;
                {
                    this.$dielectric = $dielectric;
                }

                public boolean acceptsStack(@NotNull ItemStack stack) {
                    Intrinsics.checkNotNullParameter(stack, "stack");
                    GenericItemUsingDamageDescriptor genericItemUsingDamageDescriptor = this.$dielectric;
                    Intrinsics.checkNotNull(genericItemUsingDamageDescriptor);
                    return genericItemUsingDamageDescriptor.checkSameItemStack(stack);
                }

                @NotNull
                public ItemStack newStackOfSize(int items) {
                    GenericItemUsingDamageDescriptor genericItemUsingDamageDescriptor = this.$dielectric;
                    Intrinsics.checkNotNull(genericItemUsingDamageDescriptor);
                    return genericItemUsingDamageDescriptor.newItemStack(items);
                }
            }.move(invoker.field_71071_by, this.getInventory(), 1, desired);
            this.reconnect();
        }
    }

    @Override
    public void writeConfigTool(@NotNull NBTTagCompound compound, @NotNull EntityPlayer invoker) {
        Intrinsics.checkNotNullParameter(compound, "compound");
        Intrinsics.checkNotNullParameter(invoker, "invoker");
        ItemStack stack = this.getInventory().func_70301_a(0);
        if (stack == null) {
            compound.func_74768_a("capRedstoneAmt", 0);
        } else {
            compound.func_74768_a("capRedstoneAmt", stack.field_77994_a);
        }
        stack = this.getInventory().func_70301_a(1);
        if (stack == null) {
            compound.func_74768_a("capDielectricAmt", 0);
        } else {
            compound.func_74768_a("capDielectricAmt", stack.field_77994_a);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\u000f"}, d2={"Lmods/eln/sixnode/PowerCapacitorSixElement$PunkProcess;", "Lmods/eln/sim/IProcess;", "(Lmods/eln/sixnode/PowerCapacitorSixElement;)V", "eLeft", "", "getELeft", "()D", "setELeft", "(D)V", "eLegaliseResistor", "getELegaliseResistor", "setELegaliseResistor", "process", "", "time", "Eln"})
    public final class PunkProcess
    implements IProcess {
        private double eLeft;
        private double eLegaliseResistor;

        public final double getELeft() {
            return this.eLeft;
        }

        public final void setELeft(double d) {
            this.eLeft = d;
        }

        public final double getELegaliseResistor() {
            return this.eLegaliseResistor;
        }

        public final void setELegaliseResistor(double d) {
            this.eLegaliseResistor = d;
        }

        @Override
        public void process(double time) {
            if (this.eLeft <= 0.0) {
                this.eLeft = 0.0;
                PowerCapacitorSixElement.this.getDischargeResistor().setResistance(PowerCapacitorSixElement.this.getStdDischargeResistor());
            } else {
                this.eLeft -= PowerCapacitorSixElement.this.getDischargeResistor().getPower() * time;
                PowerCapacitorSixElement.this.getDischargeResistor().setResistance(this.eLegaliseResistor);
            }
        }
    }
}

