/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode;

import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.i18n.I18N;
import mods.eln.item.IConfigurable;
import mods.eln.item.ItemMovingHelper;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Inductor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sixnode.PowerInductorSixContainer;
import mods.eln.sixnode.PowerInductorSixDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u001a\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010,\u001a\u00020-2\u0006\u00100\u001a\u00020+H\u0016J\u001a\u00101\u001a\u0004\u0018\u0001022\u0006\u0010,\u001a\u00020-2\u0006\u00100\u001a\u00020+H\u0016J\u0014\u00103\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020504H\u0016J\b\u00106\u001a\u00020\u0010H\u0016J\b\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u000208H\u0016J\b\u0010:\u001a\u000205H\u0016J\u0018\u0010;\u001a\u00020<2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010=\u001a\u00020>H\u0016J\u0018\u0010?\u001a\u0002082\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020>H\u0016J\u0010\u0010C\u001a\u0002082\u0006\u0010D\u001a\u00020AH\u0016J\u0006\u0010E\u001a\u000208J\b\u0010F\u001a\u000205H\u0016J\u0018\u0010G\u001a\u0002082\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020>H\u0016R\u001a\u0010\u0007\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010$\"\u0004\b)\u0010&\u00a8\u0006H"}, d2={"Lmods/eln/sixnode/PowerInductorSixElement;", "Lmods/eln/node/six/SixNodeElement;", "Lmods/eln/item/IConfigurable;", "SixNode", "Lmods/eln/node/six/SixNode;", "side", "Lmods/eln/misc/Direction;", "descriptor", "Lmods/eln/node/six/SixNodeDescriptor;", "(Lmods/eln/node/six/SixNode;Lmods/eln/misc/Direction;Lmods/eln/node/six/SixNodeDescriptor;)V", "Lmods/eln/sixnode/PowerInductorSixDescriptor;", "getDescriptor", "()Lmods/eln/sixnode/PowerInductorSixDescriptor;", "setDescriptor", "(Lmods/eln/sixnode/PowerInductorSixDescriptor;)V", "fromNbt", "", "getFromNbt", "()Z", "setFromNbt", "(Z)V", "inductor", "Lmods/eln/sim/mna/component/Inductor;", "getInductor", "()Lmods/eln/sim/mna/component/Inductor;", "setInductor", "(Lmods/eln/sim/mna/component/Inductor;)V", "inventory", "Lmods/eln/node/six/SixNodeElementInventory;", "getInventory", "()Lmods/eln/node/six/SixNodeElementInventory;", "setInventory", "(Lmods/eln/node/six/SixNodeElementInventory;)V", "negativeLoad", "Lmods/eln/sim/nbt/NbtElectricalLoad;", "getNegativeLoad", "()Lmods/eln/sim/nbt/NbtElectricalLoad;", "setNegativeLoad", "(Lmods/eln/sim/nbt/NbtElectricalLoad;)V", "positiveLoad", "getPositiveLoad", "setPositiveLoad", "getConnectionMask", "", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "mask", "getThermalLoad", "Lmods/eln/sim/ThermalLoad;", "getWaila", "", "", "hasGui", "initialize", "", "inventoryChanged", "multiMeterString", "newContainer", "Lnet/minecraft/inventory/Container;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "readConfigTool", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "invoker", "readFromNBT", "nbt", "setupPhysical", "thermoMeterString", "writeConfigTool", "Eln"})
public final class PowerInductorSixElement
extends SixNodeElement
implements IConfigurable {
    @NotNull
    private PowerInductorSixDescriptor descriptor;
    @NotNull
    private NbtElectricalLoad positiveLoad;
    @NotNull
    private NbtElectricalLoad negativeLoad;
    @NotNull
    private Inductor inductor;
    private boolean fromNbt;
    @NotNull
    private SixNodeElementInventory inventory;

    public PowerInductorSixElement(@NotNull SixNode SixNode2, @NotNull Direction side, @NotNull SixNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(SixNode2, "SixNode");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(SixNode2, side, descriptor);
        this.descriptor = (PowerInductorSixDescriptor)descriptor;
        this.positiveLoad = new NbtElectricalLoad("positiveLoad");
        this.negativeLoad = new NbtElectricalLoad("negativeLoad");
        this.inductor = new Inductor("inductor", this.positiveLoad, this.negativeLoad);
        this.inventory = new SixNodeElementInventory(2, 64, this);
        this.electricalLoadList.add(this.positiveLoad);
        this.electricalLoadList.add(this.negativeLoad);
        this.electricalComponentList.add(this.inductor);
        this.positiveLoad.setAsMustBeFarFromInterSystem();
    }

    @NotNull
    public final PowerInductorSixDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final void setDescriptor(@NotNull PowerInductorSixDescriptor powerInductorSixDescriptor) {
        Intrinsics.checkNotNullParameter(powerInductorSixDescriptor, "<set-?>");
        this.descriptor = powerInductorSixDescriptor;
    }

    @NotNull
    public final NbtElectricalLoad getPositiveLoad() {
        return this.positiveLoad;
    }

    public final void setPositiveLoad(@NotNull NbtElectricalLoad nbtElectricalLoad) {
        Intrinsics.checkNotNullParameter(nbtElectricalLoad, "<set-?>");
        this.positiveLoad = nbtElectricalLoad;
    }

    @NotNull
    public final NbtElectricalLoad getNegativeLoad() {
        return this.negativeLoad;
    }

    public final void setNegativeLoad(@NotNull NbtElectricalLoad nbtElectricalLoad) {
        Intrinsics.checkNotNullParameter(nbtElectricalLoad, "<set-?>");
        this.negativeLoad = nbtElectricalLoad;
    }

    @NotNull
    public final Inductor getInductor() {
        return this.inductor;
    }

    public final void setInductor(@NotNull Inductor inductor) {
        Intrinsics.checkNotNullParameter(inductor, "<set-?>");
        this.inductor = inductor;
    }

    public final boolean getFromNbt() {
        return this.fromNbt;
    }

    public final void setFromNbt(boolean bl) {
        this.fromNbt = bl;
    }

    @Override
    @NotNull
    public SixNodeElementInventory getInventory() {
        return this.inventory;
    }

    public void setInventory(@NotNull SixNodeElementInventory sixNodeElementInventory) {
        Intrinsics.checkNotNullParameter(sixNodeElementInventory, "<set-?>");
        this.inventory = sixNodeElementInventory;
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (lrdu == this.front.right()) {
            return this.positiveLoad;
        }
        return lrdu == this.front.left() ? (ElectricalLoad)this.negativeLoad : null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return null;
    }

    @Override
    public int getConnectionMask(@NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (lrdu == this.front.right()) {
            return 1;
        }
        return lrdu == this.front.left() ? 1 : 0;
    }

    @Override
    @NotNull
    public String multiMeterString() {
        return Utils.plotVolt("U", Math.abs(this.inductor.getVoltage())) + Utils.plotAmpere("I", this.inductor.getCurrent());
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        Map info;
        Map map = info = (Map)new HashMap();
        String string = I18N.tr("Inductance", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string, "tr(\"Inductance\")");
        String string2 = string;
        String string3 = Utils.plotValue(this.inductor.getInductance(), "H");
        map.put(string2, string3);
        map = info;
        String string4 = I18N.tr("Charge", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string4, "tr(\"Charge\")");
        string2 = string4;
        string3 = Utils.plotEnergy("", this.inductor.getEnergy());
        map.put(string2, string3);
        if (Eln.wailaEasyMode) {
            map = info;
            String string5 = I18N.tr("Voltage drop", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string5, "tr(\"Voltage drop\")");
            string2 = string5;
            string3 = Utils.plotVolt("", Math.abs(this.inductor.getVoltage()));
            map.put(string2, string3);
            map = info;
            String string6 = I18N.tr("Current", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string6, "tr(\"Current\")");
            string2 = string6;
            string3 = Utils.plotAmpere("", Math.abs(this.inductor.getCurrent()));
            map.put(string2, string3);
        }
        return info;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void initialize() {
        this.setupPhysical();
    }

    @Override
    public void inventoryChanged() {
        super.inventoryChanged();
        this.setupPhysical();
    }

    public final void setupPhysical() {
        double rs = this.descriptor.getRsValue(this.getInventory());
        this.inductor.setInductance(this.descriptor.getlValue(this.getInventory()));
        this.positiveLoad.setSerialResistance(rs);
        this.negativeLoad.setSerialResistance(rs);
        if (this.fromNbt) {
            this.fromNbt = false;
        } else {
            this.inductor.resetStates();
        }
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.readFromNBT(nbt);
        this.fromNbt = true;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    @NotNull
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        return new PowerInductorSixContainer(player, this.getInventory());
    }

    @Override
    public void readConfigTool(@NotNull NBTTagCompound compound, @NotNull EntityPlayer invoker) {
        Intrinsics.checkNotNullParameter(compound, "compound");
        Intrinsics.checkNotNullParameter(invoker, "invoker");
        if (compound.func_74764_b("indCableAmt")) {
            int desired = compound.func_74762_e("indCableAmt");
            new ItemMovingHelper(){

                public boolean acceptsStack(@NotNull ItemStack stack) {
                    Intrinsics.checkNotNullParameter(stack, "stack");
                    return Eln.instance.copperCableDescriptor.checkSameItemStack(stack);
                }

                @NotNull
                public ItemStack newStackOfSize(int items) {
                    return Eln.instance.copperCableDescriptor.newItemStack(items);
                }
            }.move(invoker.field_71071_by, this.getInventory(), 0, desired);
            this.reconnect();
        }
        if (compound.func_74764_b("indCore")) {
            String descName = compound.func_74779_i("indCore");
            if (descName == GenericItemUsingDamageDescriptor.INVALID_NAME) {
                ItemStack stack = this.getInventory().func_70301_a(1);
                GenericItemUsingDamageDescriptor desc = GenericItemUsingDamageDescriptor.Companion.getDescriptor(stack);
                if (desc != null) {
                    new ItemMovingHelper(desc){
                        final /* synthetic */ GenericItemUsingDamageDescriptor $desc;
                        {
                            this.$desc = $desc;
                        }

                        public boolean acceptsStack(@NotNull ItemStack stack) {
                            Intrinsics.checkNotNullParameter(stack, "stack");
                            return this.$desc == GenericItemUsingDamageDescriptor.Companion.getDescriptor(stack);
                        }

                        @NotNull
                        public ItemStack newStackOfSize(int items) {
                            return this.$desc.newItemStack(items);
                        }
                    }.move(invoker.field_71071_by, this.getInventory(), 1, 0);
                }
            } else {
                GenericItemUsingDamageDescriptor desc = GenericItemUsingDamageDescriptor.Companion.getByName(compound.func_74779_i("indCore"));
                new ItemMovingHelper(desc){
                    final /* synthetic */ GenericItemUsingDamageDescriptor $desc;
                    {
                        this.$desc = $desc;
                    }

                    public boolean acceptsStack(@NotNull ItemStack stack) {
                        Intrinsics.checkNotNullParameter(stack, "stack");
                        return GenericItemUsingDamageDescriptor.Companion.getDescriptor(stack) == this.$desc;
                    }

                    @NotNull
                    public ItemStack newStackOfSize(int items) {
                        GenericItemUsingDamageDescriptor genericItemUsingDamageDescriptor = this.$desc;
                        Intrinsics.checkNotNull(genericItemUsingDamageDescriptor);
                        return genericItemUsingDamageDescriptor.newItemStack(items);
                    }
                }.move(invoker.field_71071_by, this.getInventory(), 1, 1);
            }
            this.reconnect();
        }
    }

    @Override
    public void writeConfigTool(@NotNull NBTTagCompound compound, @NotNull EntityPlayer invoker) {
        Intrinsics.checkNotNullParameter(compound, "compound");
        Intrinsics.checkNotNullParameter(invoker, "invoker");
        ItemStack stack = this.getInventory().func_70301_a(0);
        if (stack == null) {
            compound.func_74768_a("indCableAmt", 0);
        } else {
            compound.func_74768_a("indCableAmt", stack.field_77994_a);
        }
        stack = this.getInventory().func_70301_a(1);
        GenericItemUsingDamageDescriptor desc = GenericItemUsingDamageDescriptor.Companion.getDescriptor(stack);
        if (desc == null) {
            compound.func_74778_a("indCore", GenericItemUsingDamageDescriptor.INVALID_NAME);
        } else {
            compound.func_74778_a("indCore", desc.name);
        }
    }
}

