/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.item.IConfigurable;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.CurrentSource;
import mods.eln.sim.nbt.NbtElectricalLoad;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u0012\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001bH\u0016J\u001a\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001bH\u0016J\u0014\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020$0#H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020$H\u0016J\u0010\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020(2\u0006\u0010+\u001a\u00020.H\u0016J0\u0010/\u001a\u00020&2\u0006\u00100\u001a\u0002012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u00105\u001a\u000203H\u0016J\u0018\u00106\u001a\u00020(2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u000201H\u0016J\u0010\u0010:\u001a\u00020(2\u0006\u0010;\u001a\u000208H\u0016J\b\u0010<\u001a\u00020$H\u0016J\u0018\u0010=\u001a\u00020(2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u000201H\u0016J\u0010\u0010>\u001a\u00020(2\u0006\u0010;\u001a\u000208H\u0016R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006?"}, d2={"Lmods/eln/sixnode/PowerSourceElement;", "Lmods/eln/node/six/SixNodeElement;", "Lmods/eln/item/IConfigurable;", "sixNode", "Lmods/eln/node/six/SixNode;", "side", "Lmods/eln/misc/Direction;", "descriptor", "Lmods/eln/node/six/SixNodeDescriptor;", "(Lmods/eln/node/six/SixNode;Lmods/eln/misc/Direction;Lmods/eln/node/six/SixNodeDescriptor;)V", "currentSource", "Lmods/eln/sim/mna/component/CurrentSource;", "getCurrentSource", "()Lmods/eln/sim/mna/component/CurrentSource;", "setCurrentSource", "(Lmods/eln/sim/mna/component/CurrentSource;)V", "electricalLoad", "Lmods/eln/sim/nbt/NbtElectricalLoad;", "getElectricalLoad", "()Lmods/eln/sim/nbt/NbtElectricalLoad;", "setElectricalLoad", "(Lmods/eln/sim/nbt/NbtElectricalLoad;)V", "setVoltageId", "", "getSetVoltageId", "()B", "getConnectionMask", "", "lrdu", "Lmods/eln/misc/LRDU;", "Lmods/eln/sim/ElectricalLoad;", "mask", "getThermalLoad", "Lmods/eln/sim/ThermalLoad;", "getWaila", "", "", "hasGui", "", "initialize", "", "multiMeterString", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "networkUnserialize", "Ljava/io/DataInputStream;", "onBlockActivated", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "vx", "", "vy", "vz", "readConfigTool", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "invoker", "readFromNBT", "nbt", "thermoMeterString", "writeConfigTool", "writeToNBT", "Eln"})
public final class PowerSourceElement
extends SixNodeElement
implements IConfigurable {
    @NotNull
    private NbtElectricalLoad electricalLoad;
    @NotNull
    private CurrentSource currentSource;
    private final byte setVoltageId;

    public PowerSourceElement(@NotNull SixNode sixNode, @NotNull Direction side, @NotNull SixNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(sixNode, "sixNode");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(sixNode, side, descriptor);
        this.electricalLoad = new NbtElectricalLoad("electricalLoad");
        this.currentSource = new CurrentSource("currSrc", this.electricalLoad, null);
        this.electricalLoadList.add(this.electricalLoad);
        this.electricalComponentList.add(this.currentSource);
        this.setVoltageId = 1;
    }

    @NotNull
    public final NbtElectricalLoad getElectricalLoad() {
        return this.electricalLoad;
    }

    public final void setElectricalLoad(@NotNull NbtElectricalLoad nbtElectricalLoad) {
        Intrinsics.checkNotNullParameter(nbtElectricalLoad, "<set-?>");
        this.electricalLoad = nbtElectricalLoad;
    }

    @NotNull
    public final CurrentSource getCurrentSource() {
        return this.currentSource;
    }

    public final void setCurrentSource(@NotNull CurrentSource currentSource) {
        Intrinsics.checkNotNullParameter(currentSource, "<set-?>");
        this.currentSource = currentSource;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.readFromNBT(nbt);
        this.currentSource.setCurrent(nbt.func_74769_h("current"));
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.writeToNBT(nbt);
        nbt.func_74780_a("current", this.currentSource.getCurrent());
    }

    @Override
    @NotNull
    public ElectricalLoad getElectricalLoad(@NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return this.electricalLoad;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return null;
    }

    @Override
    public int getConnectionMask(@NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return 1;
    }

    @Override
    @NotNull
    public String multiMeterString() {
        return Utils.plotUIP(this.electricalLoad.getVoltage(), this.currentSource.getCurrent());
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        Map info;
        Map map = info = (Map)new HashMap();
        String string = I18N.tr("Voltage", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string, "tr(\"Voltage\")");
        String string2 = string;
        String string3 = Utils.plotVolt("", this.electricalLoad.getVoltage());
        map.put(string2, string3);
        map = info;
        String string4 = I18N.tr("Current", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string4, "tr(\"Current\")");
        string2 = string4;
        string3 = Utils.plotAmpere("", this.electricalLoad.getCurrent());
        map.put(string2, string3);
        if (Eln.wailaEasyMode) {
            map = info;
            String string5 = I18N.tr("Power", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string5, "tr(\"Power\")");
            string2 = string5;
            string3 = Utils.plotPower("", this.electricalLoad.getVoltage() * this.electricalLoad.getCurrent());
            map.put(string2, string3);
        }
        return info;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        try {
            stream.writeDouble(this.currentSource.getCurrent());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void networkUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkUnserialize(stream);
        try {
            this.currentSource.setCurrent(stream.readDouble());
            this.needPublish();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize() {
        Eln.applySmallRs(this.electricalLoad);
    }

    @Override
    public boolean onBlockActivated(@NotNull EntityPlayer entityPlayer, @NotNull Direction side, float vx, float vy, float vz) {
        Intrinsics.checkNotNullParameter(entityPlayer, "entityPlayer");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return this.onBlockActivatedRotate(entityPlayer);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void readConfigTool(@NotNull NBTTagCompound compound, @NotNull EntityPlayer invoker) {
        Intrinsics.checkNotNullParameter(compound, "compound");
        Intrinsics.checkNotNullParameter(invoker, "invoker");
        if (compound.func_74764_b("current")) {
            this.currentSource.setCurrent(compound.func_74769_h("current"));
            this.needPublish();
        }
    }

    @Override
    public void writeConfigTool(@NotNull NBTTagCompound compound, @NotNull EntityPlayer invoker) {
        Intrinsics.checkNotNullParameter(compound, "compound");
        Intrinsics.checkNotNullParameter(invoker, "invoker");
        compound.func_74780_a("current", this.currentSource.getCurrent());
    }

    public final byte getSetVoltageId() {
        return this.setVoltageId;
    }
}

