/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode;

import java.io.DataOutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import mods.eln.i18n.I18N;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.PlayerUtilKt;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.NoWhenBranchMatchedException;
import mods.eln.shadow.kotlin.collections.CollectionsKt;
import mods.eln.shadow.kotlin.collections.IntIterator;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.kotlin.ranges.IntRange;
import mods.eln.shadow.kotlin.text.CharsKt;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalGateOutput;
import mods.eln.sim.nbt.NbtElectricalGateOutputProcess;
import mods.eln.sixnode.ScanMode;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001cH\u0016J\u001a\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001cH\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020*H\u0016J0\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u000200H\u0016J\u0010\u00103\u001a\u00020%2\u0006\u00104\u001a\u000205H\u0016J\u0018\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002J\u001f\u0010<\u001a\u0004\u0018\u0001072\u0006\u0010=\u001a\u00020>2\u0006\u0010:\u001a\u00020;H\u0002\u00a2\u0006\u0002\u0010?J\b\u0010@\u001a\u00020'H\u0016J\u0010\u0010A\u001a\u00020%2\u0006\u00104\u001a\u000205H\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006B"}, d2={"Lmods/eln/sixnode/ScannerElement;", "Lmods/eln/node/six/SixNodeElement;", "sixNode", "Lmods/eln/node/six/SixNode;", "side", "Lmods/eln/misc/Direction;", "descriptor", "Lmods/eln/node/six/SixNodeDescriptor;", "(Lmods/eln/node/six/SixNode;Lmods/eln/misc/Direction;Lmods/eln/node/six/SixNodeDescriptor;)V", "mode", "Lmods/eln/sixnode/ScanMode;", "getMode", "()Lmods/eln/sixnode/ScanMode;", "setMode", "(Lmods/eln/sixnode/ScanMode;)V", "output", "Lmods/eln/sim/nbt/NbtElectricalGateOutput;", "getOutput", "()Lmods/eln/sim/nbt/NbtElectricalGateOutput;", "outputProcess", "Lmods/eln/sim/nbt/NbtElectricalGateOutputProcess;", "getOutputProcess", "()Lmods/eln/sim/nbt/NbtElectricalGateOutputProcess;", "updater", "Lmods/eln/sim/IProcess;", "getUpdater", "()Lmods/eln/sim/IProcess;", "getConnectionMask", "", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "mask", "getThermalLoad", "Lmods/eln/sim/ThermalLoad;", "initialize", "", "multiMeterString", "", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "onBlockActivated", "", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "vx", "", "vy", "vz", "readFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "scanBlock", "", "scannedCoord", "Lmods/eln/misc/Coordinate;", "targetSide", "Lnet/minecraftforge/common/util/ForgeDirection;", "scanTileEntity", "te", "Lnet/minecraft/tileentity/TileEntity;", "(Lnet/minecraft/tileentity/TileEntity;Lnet/minecraftforge/common/util/ForgeDirection;)Ljava/lang/Double;", "thermoMeterString", "writeToNBT", "Eln"})
@SourceDebugExtension(value={"SMAP\nScanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Scanner.kt\nmods/eln/sixnode/ScannerElement\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,205:1\n13600#2,2:206\n13600#2,2:208\n1774#3,4:210\n1#4:214\n*S KotlinDebug\n*F\n+ 1 Scanner.kt\nmods/eln/sixnode/ScannerElement\n*L\n115#1:206,2\n120#1:208,2\n132#1:210,4\n*E\n"})
public final class ScannerElement
extends SixNodeElement {
    @NotNull
    private final NbtElectricalGateOutput output;
    @NotNull
    private final NbtElectricalGateOutputProcess outputProcess;
    @NotNull
    private ScanMode mode;
    @NotNull
    private final IProcess updater;

    public ScannerElement(@NotNull SixNode sixNode, @NotNull Direction side, @NotNull SixNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(sixNode, "sixNode");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(sixNode, side, descriptor);
        this.output = new NbtElectricalGateOutput("signal");
        this.outputProcess = new NbtElectricalGateOutputProcess("signalP", this.output);
        this.mode = ScanMode.SIMPLE;
        this.updater = arg_0 -> ScannerElement.updater$lambda$1(side, this, arg_0);
        this.electricalLoadList.add(this.output);
        this.electricalComponentList.add(this.outputProcess);
        this.slowProcessList.add(this.updater);
    }

    @NotNull
    public final NbtElectricalGateOutput getOutput() {
        return this.output;
    }

    @NotNull
    public final NbtElectricalGateOutputProcess getOutputProcess() {
        return this.outputProcess;
    }

    @NotNull
    public final ScanMode getMode() {
        return this.mode;
    }

    public final void setMode(@NotNull ScanMode scanMode) {
        Intrinsics.checkNotNullParameter((Object)scanMode, "<set-?>");
        this.mode = scanMode;
    }

    @NotNull
    public final IProcess getUpdater() {
        return this.updater;
    }

    private final double scanBlock(Coordinate scannedCoord, ForgeDirection targetSide) {
        Block block = scannedCoord.getBlock();
        return block.func_149740_M() ? (double)block.func_149736_g(scannedCoord.world(), scannedCoord.x, scannedCoord.y, scannedCoord.z, targetSide.ordinal()) / 15.0 : (block.func_149662_c() ? 1.0 : (block.isAir((IBlockAccess)scannedCoord.world(), scannedCoord.x, scannedCoord.y, scannedCoord.z) ? 0.0 : 0.3333333333333333));
    }

    /*
     * WARNING - void declaration
     */
    private final Double scanTileEntity(TileEntity te, ForgeDirection targetSide) {
        if (te instanceof IFluidHandler) {
            FluidTankInfo[] info = ((IFluidHandler)te).getTankInfo(targetSide);
            Intrinsics.checkNotNullExpressionValue(info, "info");
            FluidTankInfo[] fluidTankInfoArray = info;
            double d = 0.0;
            int n = fluidTankInfoArray.length;
            for (int i = 0; i < n; ++i) {
                void it;
                FluidTankInfo fluidTankInfo;
                FluidTankInfo fluidTankInfo2 = fluidTankInfo = fluidTankInfoArray[i];
                double d2 = d;
                boolean bl = false;
                FluidStack fluidStack = it.fluid;
                double d3 = (double)(fluidStack != null ? fluidStack.amount : 0) / (double)it.capacity;
                d = d2 + d3;
            }
            return d / (double)info.length;
        }
        if (te instanceof ISidedInventory) {
            int sum = 0;
            int limit = 0;
            int[] slots = ((ISidedInventory)te).func_94128_d(targetSide.ordinal());
            switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
                case 1: {
                    Intrinsics.checkNotNullExpressionValue(slots, "slots");
                    int[] $this$forEach$iv = slots;
                    boolean $i$f$forEach = false;
                    int bl = $this$forEach$iv.length;
                    for (int i = 0; i < bl; ++i) {
                        int element$iv;
                        int it = element$iv = $this$forEach$iv[i];
                        boolean bl2 = false;
                        ItemStack itemStack = ((ISidedInventory)te).func_70301_a(it);
                        sum += itemStack != null ? itemStack.field_77994_a : 0;
                        limit += ((ISidedInventory)te).func_70297_j_();
                    }
                    break;
                }
                case 2: {
                    Intrinsics.checkNotNullExpressionValue(slots, "slots");
                    int[] $this$forEach$iv = slots;
                    boolean $i$f$forEach = false;
                    int bl = $this$forEach$iv.length;
                    for (int i = 0; i < bl; ++i) {
                        int element$iv;
                        int it = element$iv = $this$forEach$iv[i];
                        boolean bl3 = false;
                        ItemStack itemStack = ((ISidedInventory)te).func_70301_a(it);
                        sum += (itemStack != null ? itemStack.field_77994_a : 0) > 0 ? 1 : 0;
                        ++limit;
                    }
                    break;
                }
            }
            return (double)sum / (double)limit;
        }
        if (te instanceof IInventory) {
            double d;
            switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
                case 1: {
                    Iterable iterable = new IntRange(0, ((IInventory)te).func_70302_i_() - 1);
                    int $this$forEach$iv = 0;
                    Iterator $i$f$forEach = iterable.iterator();
                    while ($i$f$forEach.hasNext()) {
                        void it;
                        int n;
                        int bl = n = ((IntIterator)$i$f$forEach).nextInt();
                        int n2 = $this$forEach$iv;
                        boolean bl4 = false;
                        ItemStack itemStack = ((IInventory)te).func_70301_a((int)it);
                        int n3 = itemStack != null ? itemStack.field_77994_a : 0;
                        $this$forEach$iv = n2 + n3;
                    }
                    d = $this$forEach$iv;
                    break;
                }
                case 2: {
                    int n;
                    Iterable $this$count$iv = new IntRange(0, ((IInventory)te).func_70302_i_() - 1);
                    boolean $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n = 0;
                    } else {
                        int count$iv = 0;
                        Iterator iterator2 = $this$count$iv.iterator();
                        while (iterator2.hasNext()) {
                            int element$iv;
                            int it = element$iv = ((IntIterator)iterator2).nextInt();
                            boolean bl = false;
                            ItemStack itemStack = ((IInventory)te).func_70301_a(it);
                            if (!((itemStack != null ? itemStack.field_77994_a : 0) > 0) || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n = count$iv;
                    }
                    d = (double)n * (double)((IInventory)te).func_70297_j_();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            double sum = d;
            return sum / (double)((IInventory)te).func_70297_j_() / (double)((IInventory)te).func_70302_i_();
        }
        return null;
    }

    @Override
    public boolean onBlockActivated(@NotNull EntityPlayer entityPlayer, @NotNull Direction side, float vx, float vy, float vz) {
        ScanMode scanMode;
        Intrinsics.checkNotNullParameter(entityPlayer, "entityPlayer");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        if (this.onBlockActivatedRotate(entityPlayer)) {
            return true;
        }
        if (PlayerUtilKt.isHoldingMeter(entityPlayer)) {
            return false;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1: {
                scanMode = ScanMode.SLOTS;
                break;
            }
            case 2: {
                scanMode = ScanMode.SIMPLE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.mode = scanMode;
        this.needPublish();
        return true;
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return this.output;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return null;
    }

    @Override
    public int getConnectionMask(@NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return lrdu == this.front.inverse() ? 4 : 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String multiMeterString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder().append("Mode: ");
        String string2 = this.mode.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        String string3 = string2;
        if (((CharSequence)string3).length() > 0) {
            void it;
            char c = string3.charAt(0);
            StringBuilder stringBuilder2 = new StringBuilder();
            StringBuilder stringBuilder3 = stringBuilder;
            boolean bl = false;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault()");
            String string4 = CharsKt.titlecase((char)it, locale);
            stringBuilder = stringBuilder3;
            StringBuilder stringBuilder4 = stringBuilder2.append((Object)string4);
            String string5 = string3;
            int n = 1;
            String string6 = string5.substring(n);
            Intrinsics.checkNotNullExpressionValue(string6, "this as java.lang.String).substring(startIndex)");
            string = stringBuilder4.append(string6).toString();
        } else {
            string = string3;
        }
        return stringBuilder.append(I18N.tr(string, new Object[0])).append(", Value: ").append(Utils.plotPercent("", this.outputProcess.getOutputNormalized())).toString();
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void initialize() {
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        stream.writeByte(this.mode.getValue());
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.writeToNBT(nbt);
        nbt.func_74774_a("mode", this.mode.getValue());
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.readFromNBT(nbt);
        ScanMode scanMode = ScanMode.Companion.fromByte(nbt.func_74771_c("mode"));
        Intrinsics.checkNotNull((Object)scanMode);
        this.mode = scanMode;
    }

    private static final void updater$lambda$1(Direction $side, ScannerElement this$0, double it) {
        Coordinate coordinate;
        Intrinsics.checkNotNullParameter((Object)$side, "$side");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Direction appliedLRDU = $side.applyLRDU(this$0.front);
        Coordinate coordinate2 = this$0.getCoordinate();
        Intrinsics.checkNotNull(coordinate2);
        Coordinate $this$updater_u24lambda_u241_u24lambda_u240 = coordinate = new Coordinate(coordinate2);
        boolean bl = false;
        $this$updater_u24lambda_u241_u24lambda_u240.move(appliedLRDU);
        Coordinate scannedCoord = coordinate;
        ForgeDirection targetSide = appliedLRDU.getInverse().toForge();
        TileEntity te = scannedCoord.getTileEntity();
        Double out = null;
        if (te != null) {
            out = this$0.scanTileEntity(te, targetSide);
        }
        if (out == null) {
            out = this$0.scanBlock(scannedCoord, targetSide);
        }
        this$0.outputProcess.setOutputNormalized(out);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScanMode.values().length];
            try {
                nArray[ScanMode.SIMPLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScanMode.SLOTS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

