/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mods.eln.i18n.I18N;
import mods.eln.misc.Utils;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.collections.CollectionsKt;
import mods.eln.shadow.kotlin.collections.IntIterator;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.kotlin.ranges.IntRange;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.sixnode.AnalogFunction;
import net.minecraft.nbt.NBTTagCompound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u00172\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0019\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u001aJ%\u0010\u001b\u001a\u00020\u00052\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u001c\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000eH\u0016J\u0018\u0010#\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000eH\u0016R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lmods/eln/sixnode/SummingUnit;", "Lmods/eln/sixnode/AnalogFunction;", "()V", "gains", "", "", "getGains$Eln", "()[Ljava/lang/Double;", "[Ljava/lang/Double;", "hasState", "", "getHasState", "()Z", "infos", "", "mods.eln.shadow.kotlin.jvm.PlatformType", "getInfos", "()Ljava/lang/String;", "inputCount", "", "getInputCount", "()I", "getWaila", "", "inputs", "output", "([Ljava/lang/Double;D)Ljava/util/Map;", "process", "deltaTime", "([Ljava/lang/Double;D)D", "readFromNBT", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "str", "writeToNBT", "Eln"})
@SourceDebugExtension(value={"SMAP\nAnalogChips.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalogChips.kt\nmods/eln/sixnode/SummingUnit\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,891:1\n1549#2:892\n1620#2,3:893\n*S KotlinDebug\n*F\n+ 1 AnalogChips.kt\nmods/eln/sixnode/SummingUnit\n*L\n616#1:892\n616#1:893,3\n*E\n"})
public final class SummingUnit
extends AnalogFunction {
    private final boolean hasState;
    private final int inputCount;
    private final String infos = I18N.tr("The summing unit outputs the sum of\nthe three weighted inputs.The\ngain for each input can be configured.", new Object[0]);
    @NotNull
    private final Double[] gains;

    public SummingUnit() {
        this.hasState = true;
        this.inputCount = 3;
        Double[] doubleArray = new Double[]{1.0, 1.0, 1.0};
        this.gains = doubleArray;
    }

    @Override
    public boolean getHasState() {
        return this.hasState;
    }

    @Override
    public int getInputCount() {
        return this.inputCount;
    }

    @Override
    public String getInfos() {
        return this.infos;
    }

    @NotNull
    public final Double[] getGains$Eln() {
        return this.gains;
    }

    @Override
    public double process(@NotNull Double[] inputs, double deltaTime) {
        Intrinsics.checkNotNullParameter(inputs, "inputs");
        Double d = inputs[0];
        Double d2 = inputs[1];
        Double d3 = inputs[2];
        return this.gains[0] * (d != null ? d : 0.0) + this.gains[1] * (d2 != null ? d2 : 0.0) + this.gains[2] * (d3 != null ? d3 : 0.0);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt, @NotNull String str) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter(str, "str");
        int n = this.gains.length;
        for (int i = 0; i < n; ++i) {
            this.gains[i] = nbt.func_74769_h("gain" + i);
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt, @NotNull String str) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter(str, "str");
        int n = this.gains.length;
        for (int i = 0; i < n; ++i) {
            nbt.func_74780_a("gain" + i, this.gains[i].doubleValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, String> getWaila(@NotNull Double[] inputs, double output) {
        void $this$mapTo$iv$iv;
        Map<String, String> info;
        Intrinsics.checkNotNullParameter(inputs, "inputs");
        Map<String, String> map = info = super.getWaila(inputs, output);
        String string = "Gains";
        Iterable $this$map$iv = new IntRange(0, 2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(AnalogFunction.Companion.getInputColors()[it] + Utils.plotValue(this.gains[it]));
        }
        String string2 = CollectionsKt.joinToString$default((List)destination$iv$iv, " ", null, null, 0, null, null, 62, null);
        map.put(string, string2);
        return info;
    }
}

