/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.TreeResinCollector;

import java.util.Collections;
import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.sixnode.TreeResinCollector.TreeResinCollectorElement;
import mods.eln.sixnode.TreeResinCollector.TreeResinCollectorRender;
import mods.eln.wiki.Data;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class TreeResinCollectorDescriptor
extends SixNodeDescriptor {
    private Obj3D obj;
    private Obj3D.Obj3DPart main;
    private Obj3D.Obj3DPart fill;
    float emptyS;
    float emptyT;

    public TreeResinCollectorDescriptor(String name, Obj3D obj) {
        super(name, TreeResinCollectorElement.class, TreeResinCollectorRender.class);
        this.obj = obj;
        if (obj != null) {
            this.main = obj.getPart("main");
            this.fill = obj.getPart("fill");
            if (this.fill != null) {
                this.emptyT = this.fill.getFloat("emptyT");
                this.emptyS = this.fill.getFloat("emptyS");
            }
        }
        this.voltageLevelColor = VoltageLevelColor.Neutral;
    }

    void draw(float factor) {
        if (this.main != null) {
            this.main.draw();
        }
        if (this.fill != null) {
            if (factor > 1.0f) {
                factor = 1.0f;
            }
            factor = 1.0f - factor;
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(factor * this.emptyT));
            GL11.glScalef((float)(1.0f - factor * (1.0f - this.emptyS)), (float)(1.0f - factor * (1.0f - this.emptyS)), (float)1.0f);
            this.fill.draw();
        }
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addMachine(this.newItemStack());
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            this.draw(0.0f);
        }
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        Collections.addAll(list, I18N.tr("Produces Tree Resin over\ntime when put on a tree.", new Object[0]).split("\n"));
    }

    public static boolean isWood(Block b) {
        for (ItemStack s : OreDictionary.getOres((String)"treeWood")) {
            if (s.func_77973_b() != Item.func_150898_a((Block)b)) continue;
            return true;
        }
        for (ItemStack s : OreDictionary.getOres((String)"logWood")) {
            if (s.func_77973_b() != Item.func_150898_a((Block)b)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLeaf(Block b) {
        for (ItemStack s : OreDictionary.getOres((String)"treeLeaves")) {
            if (s.func_77973_b() != Item.func_150898_a((Block)b)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canBePlacedOnSide(EntityPlayer player, Coordinate c, Direction side) {
        Block b = c.getBlock();
        if (!TreeResinCollectorDescriptor.isWood(b) || side.isY()) {
            Utils.addChatMessage(player, I18N.tr("This block can only be placed on the side of a tree!", new Object[0]));
            return false;
        }
        return true;
    }
}

