/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.TreeResinCollector;

import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.NodeBase;
import mods.eln.node.NodeManager;
import mods.eln.node.NodePeriodicPublishProcess;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sixnode.TreeResinCollector.TreeResinCollectorDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TreeResinCollectorElement
extends SixNodeElement {
    TreeResinCollectorSlowProcess slowProcess = new TreeResinCollectorSlowProcess(this);
    final float occupancyMax = 2.0f;
    final float occupancyProductPerSecondPerTreeBlock = 4.1666668E-4f;
    double timeFromLastActivated = 0.0;

    public TreeResinCollectorElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.slowProcessList.add(this.slowProcess);
        this.slowProcessList.add(new NodePeriodicPublishProcess(sixNode, 10.0, 10.0));
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu, int mask) {
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        return 0;
    }

    @Override
    public void initialize() {
    }

    double getProductPerSecond() {
        Coordinate coord = this.sixNode.coordinate;
        World worldObj = coord.world();
        int[] posWood = new int[3];
        int[] posCollector = new int[3];
        Direction woodDirection = this.side;
        posWood[0] = coord.x;
        posWood[1] = coord.y;
        posWood[2] = coord.z;
        posCollector[0] = coord.x;
        posCollector[1] = coord.y;
        posCollector[2] = coord.z;
        woodDirection.applyTo(posWood, 1);
        int leafCount = 0;
        while (TreeResinCollectorDescriptor.isWood(worldObj.func_147439_a(posWood[0], posWood[1] - 1, posWood[2]))) {
            posWood[1] = posWood[1] - 1;
        }
        int yStart = posWood[1];
        posWood[1] = coord.y;
        while (TreeResinCollectorDescriptor.isWood(worldObj.func_147439_a(posWood[0], posWood[1] + 1, posWood[2]))) {
            if (TreeResinCollectorDescriptor.isLeaf(worldObj.func_147439_a(posCollector[0], posWood[1] + 1, posCollector[2]))) {
                ++leafCount;
            }
            posWood[1] = posWood[1] + 1;
        }
        int yEnd = posWood[1];
        int collectiorCount = 0;
        Coordinate coordTemp = new Coordinate(posCollector[0], 0, posCollector[2], worldObj);
        posCollector[1] = yStart;
        posCollector[1] = yStart;
        while (posCollector[1] <= yEnd) {
            SixNode six;
            coordTemp.y = posCollector[1];
            NodeBase node = NodeManager.instance.getNodeFromCoordonate(coordTemp);
            if (node instanceof SixNode && (six = (SixNode)node).getElement(this.side) != null && six.getElement(this.side) instanceof TreeResinCollectorElement) {
                ++collectiorCount;
            }
            posCollector[1] = posCollector[1] + 1;
        }
        if (collectiorCount == 0) {
            ++collectiorCount;
            Utils.println("ASSERT collectiorCount == 0");
        }
        double leaf = leafCount >= 1 ? 1.0 : 1.0E-9;
        double productPerSeconde = Math.min(0.05, (double)(4.1666668E-4f * (float)(yEnd - yStart + 1) / (float)collectiorCount)) * leaf;
        return productPerSeconde;
    }

    double getProduct(double productPerSecond) {
        double product = productPerSecond * this.timeFromLastActivated;
        return product;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        int productI;
        double productPerSeconde = this.getProductPerSecond();
        double product = this.getProduct(productPerSeconde);
        if (product > 2.0) {
            productI = 2;
            this.timeFromLastActivated = 0.0;
        } else {
            productI = (int)product;
            this.timeFromLastActivated -= (double)productI / productPerSeconde;
        }
        for (int idx = 0; idx < productI; ++idx) {
            this.sixNode.dropItem(Eln.treeResin.newItemStack(1));
        }
        Utils.addChatMessage(entityPlayer, "Tree Resin in pot : " + String.format("%1.2f", productPerSeconde * this.timeFromLastActivated));
        this.needPublish();
        return true;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.timeFromLastActivated = nbt.func_74769_h("timeFromLastActivated");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74780_a("timeFromLastActivated", this.timeFromLastActivated);
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            if (this.getCoordinate().getBlockExist()) {
                stream.writeFloat((float)this.getProduct(this.getProductPerSecond()));
            } else {
                stream.writeFloat(0.0f);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class TreeResinCollectorSlowProcess
    implements IProcess {
        TreeResinCollectorElement element;

        public TreeResinCollectorSlowProcess(TreeResinCollectorElement element) {
            this.element = element;
        }

        @Override
        public void process(double time) {
            this.element.timeFromLastActivated += time;
        }
    }
}

