/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode;

import java.util.Map;
import mods.eln.i18n.I18N;
import mods.eln.misc.Utils;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.sixnode.AnalogFunction;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0006\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J1\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0012J%\u0010\u0013\u001a\u00020\u00102\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f2\u0006\u0010\u0014\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0015R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lmods/eln/sixnode/VoltageControlledAmplifier;", "Lmods/eln/sixnode/AnalogFunction;", "()V", "infos", "", "mods.eln.shadow.kotlin.jvm.PlatformType", "getInfos", "()Ljava/lang/String;", "inputCount", "", "getInputCount", "()I", "getWaila", "", "inputs", "", "", "output", "([Ljava/lang/Double;D)Ljava/util/Map;", "process", "deltaTime", "([Ljava/lang/Double;D)D", "Eln"})
public final class VoltageControlledAmplifier
extends AnalogFunction {
    private final int inputCount;
    private final String infos = I18N.tr("A voltage-controlled amplifier (VCA)\nis an electronic amplifier that varies\nits gain depending on the control voltage.", new Object[0]);

    public VoltageControlledAmplifier() {
        this.inputCount = 2;
    }

    @Override
    public int getInputCount() {
        return this.inputCount;
    }

    @Override
    public String getInfos() {
        return this.infos;
    }

    @Override
    public double process(@NotNull Double[] inputs, double deltaTime) {
        Intrinsics.checkNotNullParameter(inputs, "inputs");
        Double d = inputs[1];
        Double d2 = inputs[0];
        return (d != null ? d : 5.0) / 5.0 * (d2 != null ? d2 : 0.0);
    }

    @Override
    @NotNull
    public Map<String, String> getWaila(@NotNull Double[] inputs, double output) {
        Map<String, String> info;
        Intrinsics.checkNotNullParameter(inputs, "inputs");
        Map<String, String> map = info = super.getWaila(inputs, output);
        String string = "Gain";
        Double d = inputs[1];
        String string2 = Utils.plotValue((d != null ? d : 5.0) / 5.0);
        map.put(string, string2);
        return info;
    }
}

