/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode;

import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.LinearFunction;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.sixnode.AnalogFunction;
import net.minecraft.nbt.NBTTagCompound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0016\u001a\u00020\u00152\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00182\u0006\u0010\u0019\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\fH\u0016J\u0018\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lmods/eln/sixnode/VoltageControlledSawtoothOscillator;", "Lmods/eln/sixnode/AnalogFunction;", "()V", "hasState", "", "getHasState", "()Z", "hertzFunction", "Lmods/eln/misc/LinearFunction;", "getHertzFunction", "()Lmods/eln/misc/LinearFunction;", "infos", "", "mods.eln.shadow.kotlin.jvm.PlatformType", "getInfos", "()Ljava/lang/String;", "inputCount", "", "getInputCount", "()I", "out", "", "process", "inputs", "", "deltaTime", "([Ljava/lang/Double;D)D", "readFromNBT", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "str", "writeToNBT", "Eln"})
public class VoltageControlledSawtoothOscillator
extends AnalogFunction {
    private final boolean hasState;
    private final int inputCount;
    private final String infos = I18N.tr("A voltage-controlled oscillator or VCO is\nan electronic oscillator whose oscillation\nfrequency is controlled by a voltage input.", new Object[0]);
    private double out;
    @NotNull
    private final LinearFunction hertzFunction;

    public VoltageControlledSawtoothOscillator() {
        this.hasState = true;
        this.inputCount = 1;
        this.hertzFunction = new LinearFunction(0.0f, 0.1f, 5.0f, (float)(1.0 / Eln.simulator.callPeriod));
    }

    @Override
    public boolean getHasState() {
        return this.hasState;
    }

    @Override
    public int getInputCount() {
        return this.inputCount;
    }

    @Override
    public String getInfos() {
        return this.infos;
    }

    @NotNull
    public LinearFunction getHertzFunction() {
        return this.hertzFunction;
    }

    @Override
    public double process(@NotNull Double[] inputs, double deltaTime) {
        Intrinsics.checkNotNullParameter(inputs, "inputs");
        Double d = inputs[0];
        double hertz = this.getHertzFunction().getValue(d != null ? d : 0.0);
        double halfPeriod = 1.0 / hertz * 0.5;
        this.out += Eln.simulator.callPeriod / halfPeriod;
        if (this.out > 5.0) {
            this.out = 0.0;
        }
        return this.out;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt, @NotNull String str) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter(str, "str");
        this.out = nbt.func_74769_h("out");
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt, @NotNull String str) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter(str, "str");
        nbt.func_74780_a("out", this.out);
    }
}

