/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.batterycharger;

import java.util.Collections;
import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.RealisticEnum;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sixnode.batterycharger.BatteryChargerElement;
import mods.eln.sixnode.batterycharger.BatteryChargerRender;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class BatteryChargerDescriptor
extends SixNodeDescriptor {
    private Obj3D obj;
    Obj3D.Obj3DPart main;
    public double nominalVoltage;
    public double nominalPower;
    public ElectricalCableDescriptor cable;
    double Rp;
    public float[] pinDistance;
    Obj3D.Obj3DPart[] leds = new Obj3D.Obj3DPart[4];

    public BatteryChargerDescriptor(String name, Obj3D obj, ElectricalCableDescriptor cable, double nominalVoltage, double nominalPower) {
        super(name, BatteryChargerElement.class, BatteryChargerRender.class);
        this.nominalVoltage = nominalVoltage;
        this.nominalPower = nominalPower;
        this.Rp = nominalVoltage * nominalVoltage / nominalPower;
        this.obj = obj;
        this.cable = cable;
        if (obj != null) {
            this.main = obj.getPart("main");
            for (int idx = 0; idx < 4; ++idx) {
                this.leds[idx] = obj.getPart("led" + idx);
            }
            this.pinDistance = Utils.getSixNodePinDistance(this.main);
        }
        this.setDefaultIcon("batterycharger");
        this.voltageLevelColor = VoltageLevelColor.fromVoltage(nominalVoltage);
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addEnergy(this.newItemStack());
        Data.addUtilities(this.newItemStack());
    }

    public void draw(boolean[] presence, boolean[] charged) {
        if (this.main != null) {
            this.main.draw();
        }
        int idx = 0;
        for (Obj3D.Obj3DPart led : this.leds) {
            if (presence != null && presence[idx]) {
                UtilsClient.ledOnOffColor(charged[idx]);
                UtilsClient.drawLight(led);
            } else {
                GL11.glColor3f((float)0.2f, (float)0.2f, (float)0.2f);
                led.draw();
            }
            ++idx;
        }
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        }
        this.draw(null, null);
    }

    public void applyTo(NbtElectricalLoad powerLoad) {
        this.cable.applyTo(powerLoad);
    }

    public void setRp(Resistor powerload, boolean powerOn) {
        if (!powerOn) {
            powerload.highImpedance();
        } else {
            powerload.setResistance(this.Rp);
        }
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        Collections.addAll(list, I18N.tr("Can be used to recharge\nelectrical items like:\nFlash Light, X-Ray scanner\nand Portable Battery ...", new Object[0]).split("\\\n"));
        list.add(I18N.tr("Nominal power: %1$W", Utils.plotValue(this.nominalPower)));
    }

    @Override
    public RealisticEnum addRealismContext(List<String> list) {
        super.addRealismContext(list);
        list.add(I18N.tr("This battery charger doesn't take into account battery chemistry", new Object[0]));
        return RealisticEnum.IDEAL;
    }

    @Override
    @Nullable
    public LRDU getFrontFromPlace(@NotNull Direction side, @NotNull EntityPlayer player) {
        return super.getFrontFromPlace(side, player).inverse();
    }
}

