/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.batterycharger;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.item.MachineBoosterDescriptor;
import mods.eln.item.electricalinterface.IItemEnergyBattery;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.AutoAcceptInventoryProxy;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sixnode.batterycharger.BatteryChargerContainer;
import mods.eln.sixnode.batterycharger.BatteryChargerDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class BatteryChargerElement
extends SixNodeElement {
    public BatteryChargerDescriptor descriptor;
    public NbtElectricalLoad powerLoad = new NbtElectricalLoad("powerLoad");
    public BatteryChargerSlowProcess slowProcess = new BatteryChargerSlowProcess();
    Resistor powerResistor = new Resistor(this.powerLoad, null);
    AutoAcceptInventoryProxy inventory = new AutoAcceptInventoryProxy(new SixNodeElementInventory(5, 64, this)).acceptIfEmpty(0, IItemEnergyBattery.class).acceptIfEmpty(1, IItemEnergyBattery.class).acceptIfEmpty(2, IItemEnergyBattery.class).acceptIfEmpty(3, IItemEnergyBattery.class).acceptIfIncrement(4, 5, MachineBoosterDescriptor.class);
    VoltageStateWatchDog voltageWatchDog = new VoltageStateWatchDog(this.powerLoad);
    public String channel = "Default channel";
    boolean invChanged = false;
    boolean powerOn = false;
    public static final byte toogleCharge = 1;
    byte charged;
    byte presence;

    @Override
    public IInventory getInventory() {
        if (this.inventory != null) {
            return this.inventory.getInventory();
        }
        return null;
    }

    @Override
    @Nullable
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new BatteryChargerContainer(player, this.inventory.getInventory());
    }

    public BatteryChargerElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.descriptor = (BatteryChargerDescriptor)descriptor;
        this.electricalLoadList.add(this.powerLoad);
        this.electricalComponentList.add(this.powerResistor);
        this.slowProcessList.add(this.slowProcess);
        WorldExplosion exp = new WorldExplosion(this).machineExplosion();
        this.slowProcessList.add(this.voltageWatchDog.setNominalVoltage(this.descriptor.nominalVoltage).setDestroys(exp));
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu, int mask) {
        if (this.front == lrdu) {
            return this.powerLoad;
        }
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.front == lrdu) {
            return 1;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return Utils.plotUIP(this.powerLoad.getVoltage(), this.powerLoad.getCurrent());
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Charge Current", new Object[0]), Utils.plotAmpere("", this.powerLoad.getCurrent()));
        if (Eln.wailaEasyMode) {
            info.put(I18N.tr("Voltage", new Object[0]), Utils.plotVolt("", this.powerLoad.getVoltage()));
            info.put(I18N.tr("Power", new Object[0]), Utils.plotPower("", this.powerLoad.getCurrent() * this.powerLoad.getVoltage()));
        }
        return info;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return null;
    }

    @Override
    public void initialize() {
        this.descriptor.applyTo(this.powerLoad);
    }

    @Override
    public void inventoryChanged() {
        super.inventoryChanged();
        this.invChanged = true;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        if (this.onBlockActivatedRotate(entityPlayer)) {
            return true;
        }
        return this.inventory.take(entityPlayer.func_71045_bC(), this, false, true);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74757_a("powerOn", this.powerOn);
        nbt.func_74780_a("energyCounter", this.slowProcess.energyCounter);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.powerOn = nbt.func_74767_n("powerOn");
        this.slowProcess.energyCounter = nbt.func_74769_h("energyCounter");
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            switch (stream.readByte()) {
                case 1: {
                    this.powerOn = !this.powerOn;
                    this.needPublish();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeBoolean(this.powerOn);
            stream.writeFloat((float)this.powerLoad.getVoltage());
            Utils.serialiseItemStack(stream, this.getInventory().func_70301_a(0));
            Utils.serialiseItemStack(stream, this.getInventory().func_70301_a(1));
            Utils.serialiseItemStack(stream, this.getInventory().func_70301_a(2));
            Utils.serialiseItemStack(stream, this.getInventory().func_70301_a(3));
            stream.writeByte(this.charged);
            stream.writeByte(this.presence);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class BatteryChargerSlowProcess
    implements IProcess {
        double energyCounter = 0.0;
        double timeout = 0.0;

        BatteryChargerSlowProcess() {
        }

        @Override
        public void process(double time) {
            this.timeout -= time;
            if (this.timeout > 0.0) {
                return;
            }
            this.timeout = 1.0;
            time = 1.0;
            byte oldCharged = BatteryChargerElement.this.charged;
            BatteryChargerElement.this.charged = 0;
            BatteryChargerElement.this.presence = 0;
            if (!BatteryChargerElement.this.powerOn) {
                BatteryChargerElement.this.descriptor.setRp(BatteryChargerElement.this.powerResistor, false);
            } else {
                ItemStack booster = BatteryChargerElement.this.getInventory().func_70301_a(4);
                double boost = 1.0;
                double eff = 1.0;
                if (booster != null) {
                    boost = Math.pow(1.25, booster.field_77994_a);
                    eff = Math.pow(0.9, booster.field_77994_a);
                }
                this.energyCounter += BatteryChargerElement.this.powerResistor.getPower() * time * eff;
                for (int idx = 0; idx < 4; ++idx) {
                    ItemStack stack = BatteryChargerElement.this.getInventory().func_70301_a(idx);
                    Object o = Utils.getItemObject(stack);
                    if (!(o instanceof IItemEnergyBattery)) continue;
                    IItemEnergyBattery b = (IItemEnergyBattery)o;
                    double e = Math.min(Math.min(this.energyCounter, b.getChargePower(stack) * time * boost), b.getEnergyMax(stack) - b.getEnergy(stack));
                    b.setEnergy(stack, b.getEnergy(stack) + e);
                    this.energyCounter -= e;
                }
                if (this.energyCounter < BatteryChargerElement.this.descriptor.nominalPower * time * 2.0 * boost) {
                    double power2 = Math.min(BatteryChargerElement.this.descriptor.nominalPower * boost, (BatteryChargerElement.this.descriptor.nominalPower * time * 2.0 * boost - this.energyCounter) / time);
                    BatteryChargerElement.this.powerResistor.setResistance(Math.max(BatteryChargerElement.this.powerLoad.getVoltage() * BatteryChargerElement.this.powerLoad.getVoltage() / power2, BatteryChargerElement.this.descriptor.Rp / boost));
                } else {
                    BatteryChargerElement.this.descriptor.setRp(BatteryChargerElement.this.powerResistor, false);
                }
            }
            for (int idx = 0; idx < 4; ++idx) {
                ItemStack stack = BatteryChargerElement.this.getInventory().func_70301_a(idx);
                Object o = Utils.getItemObject(stack);
                if (!(o instanceof IItemEnergyBattery)) continue;
                IItemEnergyBattery b = (IItemEnergyBattery)o;
                if (b.getEnergy(stack) == b.getEnergyMax(stack)) {
                    BatteryChargerElement.this.charged = (byte)(BatteryChargerElement.this.charged + (1 << idx));
                }
                BatteryChargerElement.this.presence = (byte)(BatteryChargerElement.this.presence + (1 << idx));
            }
            if (BatteryChargerElement.this.charged != oldCharged) {
                BatteryChargerElement.this.needPublish();
            }
            if (BatteryChargerElement.this.invChanged) {
                BatteryChargerElement.this.invChanged = false;
                BatteryChargerElement.this.needPublish();
            }
        }
    }
}

