/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.batterycharger;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.batterycharger.BatteryChargerDescriptor;
import mods.eln.sixnode.batterycharger.BatteryChargerGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

public class BatteryChargerRender
extends SixNodeElementRender {
    BatteryChargerDescriptor descriptor;
    Coordinate coord;
    boolean[] charged = new boolean[]{false, false, false, false};
    boolean[] batteryPresence = new boolean[]{false, false, false, false};
    float alpha = 0.0f;
    EntityItem[] b = new EntityItem[4];
    boolean powerOn;
    private float voltage;
    SixNodeElementInventory inventory = new SixNodeElementInventory(5, 64, this);

    public BatteryChargerRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (BatteryChargerDescriptor)descriptor;
        this.coord = new Coordinate(tileEntity);
    }

    @Override
    public void draw() {
        super.draw();
        this.drawPowerPin(this.descriptor.pinDistance);
        if (this.side.isY()) {
            this.front.right().glRotateOnX();
        }
        this.drawEntityItem(this.b[0], 0.1875, 0.15625, 0.15625, this.alpha, 0.2f);
        this.drawEntityItem(this.b[1], 0.1875, 0.15625, -0.15625, this.alpha, 0.2f);
        this.drawEntityItem(this.b[2], 0.1875, -0.15625, 0.15625, this.alpha, 0.2f);
        this.drawEntityItem(this.b[3], 0.1875, -0.15625, -0.15625, this.alpha, 0.2f);
        this.descriptor.draw(this.batteryPresence, this.charged);
    }

    @Override
    public void refresh(float deltaT) {
        this.alpha += 90.0f * deltaT;
        if (this.alpha > 360.0f) {
            this.alpha -= 360.0f;
        }
    }

    public void drawEntityItem(EntityItem entityItem, double x, double y, double z, float roty, float scale) {
        if (entityItem == null) {
            return;
        }
        entityItem.field_70290_d = 0.0f;
        entityItem.field_70177_z = 0.0f;
        entityItem.field_70159_w = 0.0;
        entityItem.field_70181_x = 0.0;
        entityItem.field_70179_y = 0.0;
        Render var10 = RenderManager.field_78727_a.func_78713_a((Entity)entityItem);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)roty, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
        var10.func_76986_a((Entity)entityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        GL11.glPopMatrix();
    }

    @Override
    @Nullable
    public CableRenderDescriptor getCableRender(@NotNull LRDU lrdu) {
        return this.descriptor.cable.render;
    }

    @Override
    @Nullable
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new BatteryChargerGui(this, player, this.inventory);
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            int idx;
            this.powerOn = stream.readBoolean();
            this.voltage = stream.readFloat();
            for (int idx2 = 0; idx2 < 4; ++idx2) {
                this.b[idx2] = Utils.unserializeItemStackToEntityItem(stream, this.b[idx2], this.getTileEntity());
            }
            byte temp = stream.readByte();
            for (idx = 0; idx < 4; ++idx) {
                this.charged[idx] = (temp & 1) != 0;
                temp = (byte)(temp >> 1);
            }
            temp = stream.readByte();
            for (idx = 0; idx < 4; ++idx) {
                this.batteryPresence[idx] = (temp & 1) != 0;
                temp = (byte)(temp >> 1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

