/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.currentcable;

import java.util.List;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.i18n.I18N;
import mods.eln.misc.RealisticEnum;
import mods.eln.misc.Utils;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sixnode.currentcable.CurrentCableElement;
import mods.eln.sixnode.currentcable.CurrentCableRender;
import mods.eln.sixnode.genericcable.GenericCableDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J.\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001cH\u0016J\u0006\u0010\"\u001a\u00020\rJ\b\u0010#\u001a\u00020$H\u0016J\u000e\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u001cR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006'"}, d2={"Lmods/eln/sixnode/currentcable/CurrentCableDescriptor;", "Lmods/eln/sixnode/genericcable/GenericCableDescriptor;", "name", "", "render", "Lmods/eln/cable/CableRenderDescriptor;", "description", "(Ljava/lang/String;Lmods/eln/cable/CableRenderDescriptor;Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "setDescription", "(Ljava/lang/String;)V", "addInformation", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "list", "", "par4", "", "addRealismContext", "Lmods/eln/misc/RealisticEnum;", "applyTo", "electricalLoad", "Lmods/eln/sim/ElectricalLoad;", "rsFactor", "", "thermalLoad", "Lmods/eln/sim/ThermalLoad;", "resistor", "Lmods/eln/sim/mna/component/Resistor;", "factor", "bindCableTexture", "getNodeMask", "", "setPhysicalConstantLikeNormalCable", "electricalMaximalCurrent", "Eln"})
public final class CurrentCableDescriptor
extends GenericCableDescriptor {
    @NotNull
    private String description;

    public CurrentCableDescriptor(@Nullable String name, @Nullable CableRenderDescriptor render, @NotNull String description) {
        Intrinsics.checkNotNullParameter(description, "description");
        super(name, (Class)CurrentCableElement.class, (Class)CurrentCableRender.class);
        this.description = "todo cable";
        this.electricalNominalVoltage = 120000.0;
        this.thermalRp = 1.0;
        this.thermalRs = 1.0;
        this.thermalC = 1.0;
        this.description = description;
        this.render = render;
        this.thermalWarmLimit = 100.0;
        this.thermalCoolLimit = -100.0;
        this.thermalWarmLimit = 130.0;
        this.thermalCoolLimit = -10.0;
        Eln.simulator.checkThermalLoad(this.thermalRs, this.thermalRp, this.thermalC);
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.description = string;
    }

    public final void setPhysicalConstantLikeNormalCable(double electricalMaximalCurrent) {
        this.electricalMaximalCurrent = electricalMaximalCurrent;
        this.electricalNominalPower = electricalMaximalCurrent * this.electricalNominalVoltage;
        this.electricalRs = 0.01;
        double thermalMaximalPowerDissipated = this.electricalRs * electricalMaximalCurrent * electricalMaximalCurrent * (double)2;
        this.thermalC = thermalMaximalPowerDissipated * 30.0 / this.thermalWarmLimit;
        this.thermalRp = this.thermalWarmLimit / thermalMaximalPowerDissipated;
        this.thermalRs = 0.5 / this.thermalC / (double)2;
        this.voltageLevelColor = VoltageLevelColor.Neutral;
    }

    @Override
    public void applyTo(@NotNull ElectricalLoad electricalLoad, double rsFactor) {
        Intrinsics.checkNotNullParameter(electricalLoad, "electricalLoad");
        electricalLoad.setSerialResistance(this.electricalRs * rsFactor);
    }

    @Override
    public void applyTo(@NotNull ElectricalLoad electricalLoad) {
        Intrinsics.checkNotNullParameter(electricalLoad, "electricalLoad");
        this.applyTo(electricalLoad, 1.0);
    }

    @Override
    public void applyTo(@NotNull Resistor resistor) {
        Intrinsics.checkNotNullParameter(resistor, "resistor");
        this.applyTo(resistor, 1.0);
    }

    @Override
    public void applyTo(@NotNull Resistor resistor, double factor) {
        Intrinsics.checkNotNullParameter(resistor, "resistor");
        resistor.setResistance(this.electricalRs * factor);
    }

    @Override
    public void applyTo(@NotNull ThermalLoad thermalLoad) {
        Intrinsics.checkNotNullParameter(thermalLoad, "thermalLoad");
        thermalLoad.Rs = this.thermalRs;
        thermalLoad.heatCapacity = this.thermalC;
        thermalLoad.Rp = this.thermalRp;
    }

    @Override
    public void addInformation(@NotNull ItemStack itemStack, @NotNull EntityPlayer entityPlayer, @NotNull List<String> list, boolean par4) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(entityPlayer, "entityPlayer");
        Intrinsics.checkNotNullParameter(list, "list");
        super.addInformation(itemStack, entityPlayer, list, par4);
        String string = I18N.tr("Nominal Ratings:", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string, "tr(\"Nominal Ratings:\")");
        list.add(string);
        Object[] objectArray = new Object[]{Utils.plotValue(this.electricalNominalVoltage)};
        list.add("  " + I18N.tr("Voltage: %1$V", objectArray));
        objectArray = new Object[]{Utils.plotValue(this.electricalNominalPower / this.electricalNominalVoltage)};
        list.add("  " + I18N.tr("Current: %1$A", objectArray));
        objectArray = new Object[]{Utils.plotValue(this.electricalNominalPower)};
        list.add("  " + I18N.tr("Power: %1$W", objectArray));
        objectArray = new Object[]{Utils.plotValue(this.electricalRs * (double)2)};
        list.add("  " + I18N.tr("Serial resistance: %1$\u2126", objectArray));
    }

    @Override
    @Nullable
    public RealisticEnum addRealismContext(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "list");
        String string = I18N.tr("Has some caveats:", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string, "tr(\"Has some caveats:\")");
        list.add(string);
        String string2 = I18N.tr("  * Wire resistance is much higher than normal", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string2, "tr(\"  * Wire resistance \u2026much higher than normal\")");
        list.add(string2);
        String string3 = I18N.tr("  * Wire resistance is not impacted by temperature", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string3, "tr(\"  * Wire resistance \u2026impacted by temperature\")");
        list.add(string3);
        String string4 = I18N.tr("  * Wire voltage limits are arbitrary values, picked to within reasonable simulator error", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string4, "tr(\"  * Wire voltage lim\u2026sonable simulator error\")");
        list.add(string4);
        String string5 = I18N.tr("  * Wire current limits are arbitrary values, added as a gameplay mechanic", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string5, "tr(\"  * Wire current lim\u2026 as a gameplay mechanic\")");
        list.add(string5);
        return RealisticEnum.REALISTIC;
    }

    @Override
    public int getNodeMask() {
        return 1;
    }

    public final void bindCableTexture() {
        this.render.bindCableTexture();
    }
}

