/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.currentcable;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.i18n.I18N;
import mods.eln.item.BrushDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sim.process.heater.ElectricalLoadHeatThermalLoad;
import mods.eln.sixnode.currentcable.CurrentCableDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u00105\u001a\u00020\n2\u0006\u00106\u001a\u000207H\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u0001082\u0006\u00106\u001a\u0002072\u0006\u00109\u001a\u00020\nH\u0016J\u001a\u0010%\u001a\u0004\u0018\u00010:2\u0006\u00106\u001a\u0002072\u0006\u00109\u001a\u00020\nH\u0016J\u0014\u0010;\u001a\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020=0<H\u0016J\b\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u00020=H\u0016J\u0010\u0010A\u001a\u00020?2\u0006\u0010B\u001a\u00020CH\u0016J0\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020I2\u0006\u0010K\u001a\u00020IH\u0016J\u0010\u0010L\u001a\u00020?2\u0006\u0010M\u001a\u00020NH\u0016J\b\u0010O\u001a\u00020=H\u0016J\u0010\u0010P\u001a\u00020?2\u0006\u0010M\u001a\u00020NH\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104\u00a8\u0006Q"}, d2={"Lmods/eln/sixnode/currentcable/CurrentCableElement;", "Lmods/eln/node/six/SixNodeElement;", "sixNode", "Lmods/eln/node/six/SixNode;", "side", "Lmods/eln/misc/Direction;", "descriptor", "Lmods/eln/node/six/SixNodeDescriptor;", "(Lmods/eln/node/six/SixNode;Lmods/eln/misc/Direction;Lmods/eln/node/six/SixNodeDescriptor;)V", "color", "", "getColor", "()I", "setColor", "(I)V", "colorCare", "getColorCare", "setColorCare", "Lmods/eln/sixnode/currentcable/CurrentCableDescriptor;", "getDescriptor", "()Lmods/eln/sixnode/currentcable/CurrentCableDescriptor;", "setDescriptor", "(Lmods/eln/sixnode/currentcable/CurrentCableDescriptor;)V", "electricalLoad", "Lmods/eln/sim/nbt/NbtElectricalLoad;", "getElectricalLoad", "()Lmods/eln/sim/nbt/NbtElectricalLoad;", "setElectricalLoad", "(Lmods/eln/sim/nbt/NbtElectricalLoad;)V", "heater", "Lmods/eln/sim/process/heater/ElectricalLoadHeatThermalLoad;", "getHeater", "()Lmods/eln/sim/process/heater/ElectricalLoadHeatThermalLoad;", "setHeater", "(Lmods/eln/sim/process/heater/ElectricalLoadHeatThermalLoad;)V", "thermalLoad", "Lmods/eln/sim/nbt/NbtThermalLoad;", "getThermalLoad", "()Lmods/eln/sim/nbt/NbtThermalLoad;", "setThermalLoad", "(Lmods/eln/sim/nbt/NbtThermalLoad;)V", "thermalWatchdog", "Lmods/eln/sim/process/destruct/ThermalLoadWatchDog;", "getThermalWatchdog", "()Lmods/eln/sim/process/destruct/ThermalLoadWatchDog;", "setThermalWatchdog", "(Lmods/eln/sim/process/destruct/ThermalLoadWatchDog;)V", "voltageWatchdog", "Lmods/eln/sim/process/destruct/VoltageStateWatchDog;", "getVoltageWatchdog", "()Lmods/eln/sim/process/destruct/VoltageStateWatchDog;", "setVoltageWatchdog", "(Lmods/eln/sim/process/destruct/VoltageStateWatchDog;)V", "getConnectionMask", "lrdu", "Lmods/eln/misc/LRDU;", "Lmods/eln/sim/ElectricalLoad;", "mask", "Lmods/eln/sim/ThermalLoad;", "getWaila", "", "", "initialize", "", "multiMeterString", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "onBlockActivated", "", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "vx", "", "vy", "vz", "readFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "thermoMeterString", "writeToNBT", "Eln"})
public class CurrentCableElement
extends SixNodeElement {
    @NotNull
    private CurrentCableDescriptor descriptor;
    @NotNull
    private NbtElectricalLoad electricalLoad;
    @NotNull
    private NbtThermalLoad thermalLoad;
    @NotNull
    private ElectricalLoadHeatThermalLoad heater;
    @NotNull
    private ThermalLoadWatchDog thermalWatchdog;
    @NotNull
    private VoltageStateWatchDog voltageWatchdog;
    private int color;
    private int colorCare;

    public CurrentCableElement(@Nullable SixNode sixNode, @Nullable Direction side, @NotNull SixNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        SixNode sixNode2 = sixNode;
        Intrinsics.checkNotNull(sixNode2);
        Direction direction = side;
        Intrinsics.checkNotNull((Object)direction);
        super(sixNode2, direction, descriptor);
        this.electricalLoad = new NbtElectricalLoad("electricalLoad");
        this.thermalLoad = new NbtThermalLoad("thermalLoad");
        this.heater = new ElectricalLoadHeatThermalLoad(this.electricalLoad, this.thermalLoad);
        this.thermalWatchdog = new ThermalLoadWatchDog(this.thermalLoad);
        this.voltageWatchdog = new VoltageStateWatchDog(this.electricalLoad);
        this.descriptor = (CurrentCableDescriptor)descriptor;
        this.color = 0;
        this.colorCare = 1;
        this.electricalLoad.setCanBeSimplifiedByLine(true);
        this.electricalLoadList.add(this.electricalLoad);
        this.thermalLoadList.add(this.thermalLoad);
        this.thermalSlowProcessList.add(this.heater);
        this.thermalLoad.setAsSlow();
        this.slowProcessList.add(this.thermalWatchdog);
        this.thermalWatchdog.setTemperatureLimits(this.descriptor.thermalWarmLimit, this.descriptor.thermalCoolLimit).setDestroys(new WorldExplosion(this).cableExplosion());
        this.slowProcessList.add(this.voltageWatchdog);
        this.voltageWatchdog.setNominalVoltage(this.descriptor.electricalNominalVoltage).setDestroys(new WorldExplosion(this).cableExplosion());
    }

    @NotNull
    public final CurrentCableDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final void setDescriptor(@NotNull CurrentCableDescriptor currentCableDescriptor) {
        Intrinsics.checkNotNullParameter(currentCableDescriptor, "<set-?>");
        this.descriptor = currentCableDescriptor;
    }

    @NotNull
    public final NbtElectricalLoad getElectricalLoad() {
        return this.electricalLoad;
    }

    public final void setElectricalLoad(@NotNull NbtElectricalLoad nbtElectricalLoad) {
        Intrinsics.checkNotNullParameter(nbtElectricalLoad, "<set-?>");
        this.electricalLoad = nbtElectricalLoad;
    }

    @NotNull
    public final NbtThermalLoad getThermalLoad() {
        return this.thermalLoad;
    }

    public final void setThermalLoad(@NotNull NbtThermalLoad nbtThermalLoad) {
        Intrinsics.checkNotNullParameter(nbtThermalLoad, "<set-?>");
        this.thermalLoad = nbtThermalLoad;
    }

    @NotNull
    public final ElectricalLoadHeatThermalLoad getHeater() {
        return this.heater;
    }

    public final void setHeater(@NotNull ElectricalLoadHeatThermalLoad electricalLoadHeatThermalLoad) {
        Intrinsics.checkNotNullParameter(electricalLoadHeatThermalLoad, "<set-?>");
        this.heater = electricalLoadHeatThermalLoad;
    }

    @NotNull
    public final ThermalLoadWatchDog getThermalWatchdog() {
        return this.thermalWatchdog;
    }

    public final void setThermalWatchdog(@NotNull ThermalLoadWatchDog thermalLoadWatchDog) {
        Intrinsics.checkNotNullParameter(thermalLoadWatchDog, "<set-?>");
        this.thermalWatchdog = thermalLoadWatchDog;
    }

    @NotNull
    public final VoltageStateWatchDog getVoltageWatchdog() {
        return this.voltageWatchdog;
    }

    public final void setVoltageWatchdog(@NotNull VoltageStateWatchDog voltageStateWatchDog) {
        Intrinsics.checkNotNullParameter(voltageStateWatchDog, "<set-?>");
        this.voltageWatchdog = voltageStateWatchDog;
    }

    public final int getColor() {
        return this.color;
    }

    public final void setColor(int n) {
        this.color = n;
    }

    public final int getColorCare() {
        return this.colorCare;
    }

    public final void setColorCare(int n) {
        this.colorCare = n;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.readFromNBT(nbt);
        byte b = nbt.func_74771_c("color");
        this.color = b & 0xF;
        this.colorCare = b >> 4 & 1;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.writeToNBT(nbt);
        nbt.func_74774_a("color", (byte)(this.color + (this.colorCare << 4)));
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return this.electricalLoad;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return this.thermalLoad;
    }

    @Override
    public int getConnectionMask(@NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return this.descriptor.getNodeMask() + (this.color << 16) + (this.colorCare << 20);
    }

    @Override
    @NotNull
    public String multiMeterString() {
        return Utils.plotUIP(this.electricalLoad.getVoltage(), this.electricalLoad.getCurrent()) + ' ' + Utils.plotPower("Cable Power Loss", this.electricalLoad.getCurrent() * this.electricalLoad.getCurrent() * this.electricalLoad.getSerialResistance());
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        Map info;
        Map map = info = (Map)new HashMap();
        String string = I18N.tr("Current", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string, "tr(\"Current\")");
        String string2 = string;
        String string3 = Utils.plotAmpere("", this.electricalLoad.getCurrent());
        map.put(string2, string3);
        map = info;
        String string4 = I18N.tr("Temperature", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string4, "tr(\"Temperature\")");
        string2 = string4;
        string3 = Utils.plotCelsius("", this.thermalLoad.getTemperature());
        map.put(string2, string3);
        if (Eln.wailaEasyMode) {
            map = info;
            String string5 = I18N.tr("Voltage", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string5, "tr(\"Voltage\")");
            string2 = string5;
            string3 = Utils.plotVolt("", this.electricalLoad.getVoltage());
            map.put(string2, string3);
        }
        map = info;
        String string6 = I18N.tr("Subsystem Matrix Size", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string6, "tr(\"Subsystem Matrix Size\")");
        string2 = string6;
        string3 = Utils.renderSubSystemWaila(this.electricalLoad.getSubSystem());
        map.put(string2, string3);
        return info;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return Utils.plotCelsius("T", this.thermalLoad.temperatureCelsius);
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        try {
            stream.writeByte(this.color << 4);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize() {
        this.descriptor.applyTo(this.electricalLoad);
        this.descriptor.applyTo(this.thermalLoad);
    }

    @Override
    public boolean onBlockActivated(@NotNull EntityPlayer entityPlayer, @NotNull Direction side, float vx, float vy, float vz) {
        GenericItemUsingDamageDescriptor brush;
        int brushColor;
        GenericItemUsingDamageDescriptor gen;
        Intrinsics.checkNotNullParameter(entityPlayer, "entityPlayer");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        ItemStack currentItemStack = entityPlayer.func_71045_bC();
        if (Utils.isPlayerUsingWrench(entityPlayer)) {
            this.colorCare ^= 1;
            Utils.addChatMessage(entityPlayer, "Wire color care " + this.colorCare);
            SixNode sixNode = this.sixNode;
            Intrinsics.checkNotNull(sixNode);
            sixNode.reconnect();
        } else if (currentItemStack != null && (gen = GenericItemUsingDamageDescriptor.Companion.getDescriptor(currentItemStack)) instanceof BrushDescriptor && (brushColor = ((BrushDescriptor)(brush = gen)).getColor(currentItemStack)) != this.color && ((BrushDescriptor)brush).use(currentItemStack, entityPlayer)) {
            this.color = brushColor;
            SixNode sixNode = this.sixNode;
            Intrinsics.checkNotNull(sixNode);
            sixNode.reconnect();
        }
        return false;
    }
}

