/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.currentrelay;

import java.util.List;
import java.util.ListIterator;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.collections.CollectionsKt;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.kotlin.text.Regex;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sixnode.currentcable.CurrentCableDescriptor;
import mods.eln.sixnode.currentrelay.CurrentRelayElement;
import mods.eln.sixnode.currentrelay.CurrentRelayRender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0016\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ2\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010-\u001a\u0004\u0018\u00010.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0003002\u0006\u00101\u001a\u000202H\u0016J\u000e\u00103\u001a\u00020*2\u0006\u00104\u001a\u000205J\u000e\u00103\u001a\u00020*2\u0006\u00104\u001a\u000206J\u000e\u00107\u001a\u00020*2\u0006\u00108\u001a\u00020\u0013J\u0018\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020.H\u0016J\u0018\u0010>\u001a\u0002022\u0006\u0010?\u001a\u00020,2\u0006\u0010@\u001a\u00020AH\u0016J1\u0010B\u001a\u00020*2\u0006\u0010@\u001a\u00020A2\u0006\u0010?\u001a\u00020,2\u0012\u0010C\u001a\n\u0012\u0006\b\u0001\u0012\u00020E0D\"\u00020EH\u0016\u00a2\u0006\u0002\u0010FJ\u000e\u0010G\u001a\u00020*2\u0006\u0010H\u001a\u00020\u000eJ \u0010I\u001a\u0002022\u0006\u0010@\u001a\u00020A2\u0006\u0010?\u001a\u00020,2\u0006\u0010J\u001a\u00020KH\u0016J&\u0010L\u001a\u0002022\b\u0010@\u001a\u0004\u0018\u00010A2\b\u0010?\u001a\u0004\u0018\u00010,2\b\u0010J\u001a\u0004\u0018\u00010KH\u0016R\u0012\u0010\t\u001a\u00060\nR\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00060\nR\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00060\nR\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00060\nR\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010 \"\u0004\b%\u0010\"R\u001a\u0010&\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010 \"\u0004\b(\u0010\"\u00a8\u0006M"}, d2={"Lmods/eln/sixnode/currentrelay/CurrentRelayDescriptor;", "Lmods/eln/node/six/SixNodeDescriptor;", "name", "", "obj", "Lmods/eln/misc/Obj3D;", "cable", "Lmods/eln/sixnode/currentcable/CurrentCableDescriptor;", "(Ljava/lang/String;Lmods/eln/misc/Obj3D;Lmods/eln/sixnode/currentcable/CurrentCableDescriptor;)V", "backplate", "Lmods/eln/misc/Obj3D$Obj3DPart;", "getCable", "()Lmods/eln/sixnode/currentcable/CurrentCableDescriptor;", "electricalRs", "", "main", "getObj", "()Lmods/eln/misc/Obj3D;", "r0rOff", "", "r0rOn", "r1rOff", "r1rOn", "relay0", "relay1", "speed", "getSpeed", "()F", "setSpeed", "(F)V", "thermalC", "getThermalC", "()D", "setThermalC", "(D)V", "thermalRp", "getThermalRp", "setThermalRp", "thermalRs", "getThermalRs", "setThermalRs", "addInformation", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "list", "", "par4", "", "applyTo", "load", "Lmods/eln/sim/ElectricalLoad;", "Lmods/eln/sim/mna/component/Resistor;", "draw", "factor", "getFrontFromPlace", "Lmods/eln/misc/LRDU;", "side", "Lmods/eln/misc/Direction;", "player", "handleRenderType", "item", "type", "Lnet/minecraftforge/client/IItemRenderer$ItemRenderType;", "renderItem", "data", "", "", "(Lnet/minecraftforge/client/IItemRenderer$ItemRenderType;Lnet/minecraft/item/ItemStack;[Ljava/lang/Object;)V", "setPhysicalConstantLikeNormalCable", "electricalMaximalCurrent", "shouldUseRenderHelper", "helper", "Lnet/minecraftforge/client/IItemRenderer$ItemRendererHelper;", "shouldUseRenderHelperEln", "Eln"})
@SourceDebugExtension(value={"SMAP\nCurrentRelay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CurrentRelay.kt\nmods/eln/sixnode/currentrelay/CurrentRelayDescriptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,413:1\n731#2,9:414\n731#2,9:423\n*S KotlinDebug\n*F\n+ 1 CurrentRelay.kt\nmods/eln/sixnode/currentrelay/CurrentRelayDescriptor\n*L\n99#1:414,9\n103#1:423,9\n*E\n"})
public final class CurrentRelayDescriptor
extends SixNodeDescriptor {
    @NotNull
    private final Obj3D obj;
    @NotNull
    private final CurrentCableDescriptor cable;
    private float speed;
    @NotNull
    private final Obj3D.Obj3DPart relay1;
    @NotNull
    private final Obj3D.Obj3DPart relay0;
    @NotNull
    private final Obj3D.Obj3DPart main;
    @NotNull
    private final Obj3D.Obj3DPart backplate;
    private float r0rOff;
    private float r0rOn;
    private float r1rOff;
    private float r1rOn;
    private double thermalRp;
    private double thermalC;
    private double thermalRs;
    private final double electricalRs;

    public CurrentRelayDescriptor(@Nullable String name, @NotNull Obj3D obj, @NotNull CurrentCableDescriptor cable) {
        Intrinsics.checkNotNullParameter(obj, "obj");
        Intrinsics.checkNotNullParameter(cable, "cable");
        super(name, CurrentRelayElement.class, CurrentRelayRender.class);
        this.obj = obj;
        this.cable = cable;
        Obj3D.Obj3DPart obj3DPart = this.obj.getPart("relay1");
        Intrinsics.checkNotNullExpressionValue(obj3DPart, "obj.getPart(\"relay1\")");
        this.relay1 = obj3DPart;
        Obj3D.Obj3DPart obj3DPart2 = this.obj.getPart("relay0");
        Intrinsics.checkNotNullExpressionValue(obj3DPart2, "obj.getPart(\"relay0\")");
        this.relay0 = obj3DPart2;
        Obj3D.Obj3DPart obj3DPart3 = this.obj.getPart("main");
        Intrinsics.checkNotNullExpressionValue(obj3DPart3, "obj.getPart(\"main\")");
        this.main = obj3DPart3;
        Obj3D.Obj3DPart obj3DPart4 = this.obj.getPart("backplate");
        Intrinsics.checkNotNullExpressionValue(obj3DPart4, "obj.getPart(\"backplate\")");
        this.backplate = obj3DPart4;
        this.thermalRp = 1.0;
        this.thermalC = 1.0;
        this.thermalRs = 1.0;
        this.electricalRs = 0.01;
        this.r0rOff = this.relay0.getFloat("rOff");
        this.r0rOn = this.relay0.getFloat("rOn");
        this.speed = this.relay0.getFloat("speed");
        this.r1rOff = this.relay1.getFloat("rOff");
        this.r1rOn = this.relay1.getFloat("rOn");
        this.voltageLevelColor = VoltageLevelColor.Neutral;
    }

    @NotNull
    public final Obj3D getObj() {
        return this.obj;
    }

    @NotNull
    public final CurrentCableDescriptor getCable() {
        return this.cable;
    }

    public final float getSpeed() {
        return this.speed;
    }

    public final void setSpeed(float f) {
        this.speed = f;
    }

    public final double getThermalRp() {
        return this.thermalRp;
    }

    public final void setThermalRp(double d) {
        this.thermalRp = d;
    }

    public final double getThermalC() {
        return this.thermalC;
    }

    public final void setThermalC(double d) {
        this.thermalC = d;
    }

    public final double getThermalRs() {
        return this.thermalRs;
    }

    public final void setThermalRs(double d) {
        this.thermalRs = d;
    }

    public final void setPhysicalConstantLikeNormalCable(double electricalMaximalCurrent) {
        double thermalMaximalPowerDissipated = this.electricalRs * electricalMaximalCurrent * electricalMaximalCurrent * (double)2;
        this.thermalC = thermalMaximalPowerDissipated * 30.0 / 130.0;
        this.thermalRp = 130.0 / thermalMaximalPowerDissipated;
        this.thermalRs = 0.25 / this.thermalC;
    }

    public final void applyTo(@NotNull ElectricalLoad load) {
        Intrinsics.checkNotNullParameter(load, "load");
        this.cable.applyTo(load);
    }

    public final void applyTo(@NotNull Resistor load) {
        Intrinsics.checkNotNullParameter(load, "load");
        this.cable.applyTo(load);
    }

    @Override
    public void addInformation(@Nullable ItemStack itemStack, @Nullable EntityPlayer entityPlayer, @NotNull List<String> list, boolean par4) {
        List list2;
        List list3;
        String it;
        Object $this$dropLastWhile$iv;
        Intrinsics.checkNotNullParameter(list, "list");
        super.addInformation(itemStack, entityPlayer, list, par4);
        String string = I18N.tr("A relay is an electrical\ncontact that conducts\ncurrent when a signal\nvoltage is applied.", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string, "tr(\"A relay is an electr\u2026al\\nvoltage is applied.\")");
        Object object = string;
        Regex regex = new Regex("\n");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        List<String> list4 = list;
        boolean $i$f$dropLastWhile22 = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list3 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list3 = CollectionsKt.emptyList();
        }
        list4.addAll(list3);
        String string2 = I18N.tr("The relay's input behaves\nlike a Schmitt Trigger.", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string2, "tr(\"The relay's input be\u2026like a Schmitt Trigger.\")");
        $this$dropLastWhile$iv = string2;
        Regex $i$f$dropLastWhile22 = new Regex("\n");
        int iterator$iv = 0;
        $this$dropLastWhile$iv = $i$f$dropLastWhile22.split((CharSequence)$this$dropLastWhile$iv, iterator$iv);
        list4 = list;
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv2 = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv2.hasPrevious()) {
                it = (String)iterator$iv2.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, iterator$iv2.nextIndex() + 1);
                break;
            }
        } else {
            list2 = CollectionsKt.emptyList();
        }
        list4.addAll(list2);
    }

    @Override
    public boolean shouldUseRenderHelper(@NotNull IItemRenderer.ItemRenderType type, @NotNull ItemStack item, @NotNull IItemRenderer.ItemRendererHelper helper) {
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(helper, "helper");
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(@NotNull ItemStack item, @NotNull IItemRenderer.ItemRenderType type) {
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(type, "type");
        return true;
    }

    @Override
    public boolean shouldUseRenderHelperEln(@Nullable IItemRenderer.ItemRenderType type, @Nullable ItemStack item, @Nullable IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(@NotNull IItemRenderer.ItemRenderType type, @NotNull ItemStack item, Object ... data) {
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(data, "data");
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            Object[] objectArray = new Object[]{data};
            super.renderItem(type, item, objectArray);
        } else {
            this.draw(0.0f);
        }
    }

    public final void draw(float factor) {
        UtilsClient.disableCulling();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        this.main.draw();
        this.relay0.draw(factor * (this.r0rOn - this.r0rOff) + this.r0rOff, 0.0f, 0.0f, 1.0f);
        this.relay1.draw(factor * (this.r1rOn - this.r1rOff) + this.r1rOff, 0.0f, 0.0f, 1.0f);
        GL11.glPushMatrix();
        this.voltageLevelColor.setGLColor();
        this.backplate.draw();
        GL11.glPopMatrix();
        UtilsClient.enableCulling();
    }

    @Override
    @NotNull
    public LRDU getFrontFromPlace(@NotNull Direction side, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        LRDU lRDU = super.getFrontFromPlace(side, player);
        Intrinsics.checkNotNull((Object)lRDU);
        return lRDU.left();
    }
}

