/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.currentrelay;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.item.IConfigurable;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalGateInput;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sim.process.heater.ElectricalLoadHeatThermalLoad;
import mods.eln.sixnode.currentcable.CurrentCableDescriptor;
import mods.eln.sixnode.currentrelay.CurrentRelayDescriptor;
import mods.eln.sixnode.currentrelay.CurrentRelayGateProcess;
import mods.eln.sound.SoundCommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u00108\u001a\u00020\u001a2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u00109\u001a\u00020:J\u0006\u0010;\u001a\u00020<J\u0010\u0010=\u001a\u00020<2\u0006\u0010-\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u00020:2\u0006\u0010@\u001a\u00020AH\u0016J\u001a\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010@\u001a\u00020A2\u0006\u0010D\u001a\u00020:H\u0016J\u001a\u0010/\u001a\u0004\u0018\u00010>2\u0006\u0010@\u001a\u00020A2\u0006\u0010D\u001a\u00020:H\u0016J\u0014\u0010E\u001a\u000e\u0012\u0004\u0012\u00020G\u0012\u0004\u0012\u00020G0FH\u0016J\b\u0010H\u001a\u00020\u001aH\u0016J\b\u0010I\u001a\u00020<H\u0016J\b\u0010J\u001a\u00020<H\u0016J\b\u0010K\u001a\u00020GH\u0016J\u0010\u0010L\u001a\u00020<2\u0006\u0010M\u001a\u00020NH\u0016J\u0010\u0010O\u001a\u00020<2\u0006\u0010M\u001a\u00020PH\u0016J\u001a\u0010Q\u001a\u00020<2\u0006\u0010R\u001a\u00020S2\b\u0010T\u001a\u0004\u0018\u00010UH\u0016J\u0010\u0010V\u001a\u00020<2\u0006\u0010W\u001a\u00020SH\u0016J\b\u0010X\u001a\u00020<H\u0002J\b\u0010Y\u001a\u00020GH\u0016J\u001a\u0010Z\u001a\u00020<2\u0006\u0010R\u001a\u00020S2\b\u0010T\u001a\u0004\u0018\u00010UH\u0016J\u0010\u0010[\u001a\u00020<2\u0006\u0010W\u001a\u00020SH\u0016R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010*\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\u001a@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u001c\"\u0004\b,\u0010\u001eR\u001a\u0010-\u001a\u00020.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u000e\u00103\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000206X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lmods/eln/sixnode/currentrelay/CurrentRelayElement;", "Lmods/eln/node/six/SixNodeElement;", "Lmods/eln/item/IConfigurable;", "sixNode", "Lmods/eln/node/six/SixNode;", "side", "Lmods/eln/misc/Direction;", "descriptor", "Lmods/eln/node/six/SixNodeDescriptor;", "(Lmods/eln/node/six/SixNode;Lmods/eln/misc/Direction;Lmods/eln/node/six/SixNodeDescriptor;)V", "aLoad", "Lmods/eln/sim/nbt/NbtElectricalLoad;", "getALoad", "()Lmods/eln/sim/nbt/NbtElectricalLoad;", "setALoad", "(Lmods/eln/sim/nbt/NbtElectricalLoad;)V", "bLoad", "getBLoad", "setBLoad", "cableDescriptor", "Lmods/eln/sixnode/currentcable/CurrentCableDescriptor;", "getCableDescriptor", "()Lmods/eln/sixnode/currentcable/CurrentCableDescriptor;", "currentRelayDescriptor", "Lmods/eln/sixnode/currentrelay/CurrentRelayDescriptor;", "defaultOutput", "", "getDefaultOutput", "()Z", "setDefaultOutput", "(Z)V", "gate", "Lmods/eln/sim/nbt/NbtElectricalGateInput;", "getGate", "()Lmods/eln/sim/nbt/NbtElectricalGateInput;", "setGate", "(Lmods/eln/sim/nbt/NbtElectricalGateInput;)V", "gateProcess", "Lmods/eln/sixnode/currentrelay/CurrentRelayGateProcess;", "switchResistor", "Lmods/eln/sim/mna/component/Resistor;", "value", "switchState", "getSwitchState", "setSwitchState", "thermalLoad", "Lmods/eln/sim/nbt/NbtThermalLoad;", "getThermalLoad", "()Lmods/eln/sim/nbt/NbtThermalLoad;", "setThermalLoad", "(Lmods/eln/sim/nbt/NbtThermalLoad;)V", "thermalWatchdog", "Lmods/eln/sim/process/destruct/ThermalLoadWatchDog;", "voltageWatchDogA", "Lmods/eln/sim/process/destruct/VoltageStateWatchDog;", "voltageWatchDogB", "canBePlacedOnSide", "type", "", "computeElectricalLoad", "", "configThermalLoad", "Lmods/eln/sim/ThermalLoad;", "getConnectionMask", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "Lmods/eln/sim/ElectricalLoad;", "mask", "getWaila", "", "", "hasGui", "initialize", "inventoryChanged", "multiMeterString", "networkSerialize", "stream", "Ljava/io/DataOutputStream;", "networkUnserialize", "Ljava/io/DataInputStream;", "readConfigTool", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "invoker", "Lnet/minecraft/entity/player/EntityPlayer;", "readFromNBT", "nbt", "refreshSwitchResistor", "thermoMeterString", "writeConfigTool", "writeToNBT", "Eln"})
public final class CurrentRelayElement
extends SixNodeElement
implements IConfigurable {
    @NotNull
    private final CurrentRelayDescriptor currentRelayDescriptor;
    @NotNull
    private NbtElectricalLoad aLoad;
    @NotNull
    private NbtElectricalLoad bLoad;
    @NotNull
    private NbtThermalLoad thermalLoad;
    @NotNull
    private Resistor switchResistor;
    @NotNull
    private NbtElectricalGateInput gate;
    @NotNull
    private CurrentRelayGateProcess gateProcess;
    @NotNull
    private VoltageStateWatchDog voltageWatchDogA;
    @NotNull
    private VoltageStateWatchDog voltageWatchDogB;
    @NotNull
    private ThermalLoadWatchDog thermalWatchdog;
    private boolean switchState;
    private boolean defaultOutput;
    @NotNull
    private final CurrentCableDescriptor cableDescriptor;

    public CurrentRelayElement(@NotNull SixNode sixNode, @NotNull Direction side, @NotNull SixNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(sixNode, "sixNode");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(sixNode, side, descriptor);
        this.currentRelayDescriptor = (CurrentRelayDescriptor)descriptor;
        this.aLoad = new NbtElectricalLoad("aLoad");
        this.bLoad = new NbtElectricalLoad("bLoad");
        this.thermalLoad = new NbtThermalLoad("thermalLoad");
        this.switchResistor = new Resistor(this.aLoad, this.bLoad);
        this.gate = new NbtElectricalGateInput("gate");
        this.gateProcess = new CurrentRelayGateProcess(this, "GP", this.gate);
        this.voltageWatchDogA = new VoltageStateWatchDog(this.aLoad);
        this.voltageWatchDogB = new VoltageStateWatchDog(this.bLoad);
        this.thermalWatchdog = new ThermalLoadWatchDog(this.thermalLoad);
        this.cableDescriptor = this.currentRelayDescriptor.getCable();
        this.configThermalLoad(this.thermalLoad);
        this.electricalLoadList.add(this.aLoad);
        this.electricalLoadList.add(this.bLoad);
        this.electricalComponentList.add(this.switchResistor);
        this.electricalProcessList.add(this.gateProcess);
        this.electricalLoadList.add(this.gate);
        this.thermalLoadList.add(this.thermalLoad);
        this.electricalComponentList.add(new Resistor(this.bLoad, null).pullDown());
        this.electricalComponentList.add(new Resistor(this.aLoad, null).pullDown());
        this.slowProcessList.add(this.voltageWatchDogA);
        this.slowProcessList.add(this.voltageWatchDogB);
        this.voltageWatchDogA.setNominalVoltage(this.cableDescriptor.electricalNominalVoltage);
        this.voltageWatchDogB.setNominalVoltage(this.cableDescriptor.electricalNominalVoltage);
        ElectricalLoadHeatThermalLoad heater = new ElectricalLoadHeatThermalLoad(this.aLoad, this.thermalLoad);
        this.thermalSlowProcessList.add(heater);
        this.thermalLoad.setAsSlow();
        this.slowProcessList.add(this.thermalWatchdog);
        this.thermalWatchdog.setTemperatureLimits(130.0, -10.0).setDestroys(new WorldExplosion(this).cableExplosion());
    }

    @NotNull
    public final NbtElectricalLoad getALoad() {
        return this.aLoad;
    }

    public final void setALoad(@NotNull NbtElectricalLoad nbtElectricalLoad) {
        Intrinsics.checkNotNullParameter(nbtElectricalLoad, "<set-?>");
        this.aLoad = nbtElectricalLoad;
    }

    @NotNull
    public final NbtElectricalLoad getBLoad() {
        return this.bLoad;
    }

    public final void setBLoad(@NotNull NbtElectricalLoad nbtElectricalLoad) {
        Intrinsics.checkNotNullParameter(nbtElectricalLoad, "<set-?>");
        this.bLoad = nbtElectricalLoad;
    }

    @NotNull
    public final NbtThermalLoad getThermalLoad() {
        return this.thermalLoad;
    }

    public final void setThermalLoad(@NotNull NbtThermalLoad nbtThermalLoad) {
        Intrinsics.checkNotNullParameter(nbtThermalLoad, "<set-?>");
        this.thermalLoad = nbtThermalLoad;
    }

    @NotNull
    public final NbtElectricalGateInput getGate() {
        return this.gate;
    }

    public final void setGate(@NotNull NbtElectricalGateInput nbtElectricalGateInput) {
        Intrinsics.checkNotNullParameter(nbtElectricalGateInput, "<set-?>");
        this.gate = nbtElectricalGateInput;
    }

    public final boolean getSwitchState() {
        return this.switchState;
    }

    public final void setSwitchState(boolean value) {
        if (value == this.switchState) {
            return;
        }
        this.switchState = value;
        this.refreshSwitchResistor();
        SoundCommand soundCommand = new SoundCommand("random.click").mulVolume(0.1f, 2.0f).smallRange();
        Intrinsics.checkNotNullExpressionValue(soundCommand, "SoundCommand(\"random.cli\u2026(0.1f, 2.0f).smallRange()");
        this.play(soundCommand);
        this.needPublish();
    }

    public final boolean getDefaultOutput() {
        return this.defaultOutput;
    }

    public final void setDefaultOutput(boolean bl) {
        this.defaultOutput = bl;
    }

    @NotNull
    public final CurrentCableDescriptor getCableDescriptor() {
        return this.cableDescriptor;
    }

    public final boolean canBePlacedOnSide(@Nullable Direction side, int type) {
        return true;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.readFromNBT(nbt);
        byte value = nbt.func_74771_c("front");
        this.front = LRDU.Companion.fromInt(value >> 0 & 3);
        this.setSwitchState(nbt.func_74767_n("switchState"));
        this.defaultOutput = nbt.func_74767_n("defaultOutput");
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.writeToNBT(nbt);
        nbt.func_74774_a("front", (byte)(this.front.toInt() << 0));
        nbt.func_74757_a("switchState", this.switchState);
        nbt.func_74757_a("defaultOutput", this.defaultOutput);
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (this.front.left() == lrdu) {
            return this.aLoad;
        }
        if (this.front.right() == lrdu) {
            return this.bLoad;
        }
        return this.front == lrdu ? (ElectricalLoad)this.gate : null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (this.front.left() == lrdu) {
            return this.thermalLoad;
        }
        if (this.front.right() == lrdu) {
            return this.thermalLoad;
        }
        return null;
    }

    @Override
    public int getConnectionMask(@NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (this.front.left() == lrdu) {
            return this.cableDescriptor.getNodeMask();
        }
        if (this.front.right() == lrdu) {
            return this.cableDescriptor.getNodeMask();
        }
        return this.front == lrdu ? 4 : 0;
    }

    @Override
    @NotNull
    public String multiMeterString() {
        return Utils.plotVolt("Ua:", this.aLoad.getVoltage()) + Utils.plotVolt("Ub:", this.bLoad.getVoltage()) + Utils.plotAmpere("I:", this.aLoad.getCurrent());
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        Map info;
        Map map = info = (Map)new HashMap();
        String string = I18N.tr("Position", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string, "tr(\"Position\")");
        String string2 = string;
        String string3 = this.switchState ? I18N.tr("Closed", new Object[0]) : I18N.tr("Open", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string3, "if (switchState) I18N.tr\u2026ed\") else I18N.tr(\"Open\")");
        String string4 = string3;
        map.put(string2, string4);
        map = info;
        String string5 = I18N.tr("Current", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string5, "tr(\"Current\")");
        string2 = string5;
        string4 = Utils.plotAmpere("", this.aLoad.getCurrent());
        map.put(string2, string4);
        map = info;
        String string6 = I18N.tr("Temperature", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string6, "tr(\"Temperature\")");
        string2 = string6;
        string4 = Utils.plotCelsius("", this.thermalLoad.temperatureCelsius);
        map.put(string2, string4);
        if (Eln.wailaEasyMode) {
            map = info;
            String string7 = I18N.tr("Default position", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string7, "tr(\"Default position\")");
            string2 = string7;
            String string8 = this.defaultOutput ? I18N.tr("Closed", new Object[0]) : I18N.tr("Open", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string8, "if (defaultOutput) I18N.\u2026ed\") else I18N.tr(\"Open\")");
            string4 = string8;
            map.put(string2, string4);
            map = info;
            String string9 = I18N.tr("Voltages", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(string9, "tr(\"Voltages\")");
            string2 = string9;
            string4 = Utils.plotVolt("", this.aLoad.getVoltage()) + Utils.plotVolt(" ", this.bLoad.getVoltage());
            map.put(string2, string4);
        }
        map = info;
        String string10 = I18N.tr("Subsystem Matrix Size", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(string10, "tr(\"Subsystem Matrix Size\")");
        string2 = string10;
        string4 = Utils.renderSubSystemWaila(this.switchResistor.getSubSystem());
        map.put(string2, string4);
        return info;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return Utils.plotCelsius("T", this.thermalLoad.temperatureCelsius);
    }

    @Override
    public void networkSerialize(@NotNull DataOutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkSerialize(stream);
        try {
            stream.writeBoolean(this.switchState);
            stream.writeBoolean(this.defaultOutput);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private final void refreshSwitchResistor() {
        if (!this.switchState) {
            this.switchResistor.ultraImpedance();
        } else {
            this.currentRelayDescriptor.applyTo(this.switchResistor);
        }
    }

    @Override
    public void initialize() {
        this.computeElectricalLoad();
        this.refreshSwitchResistor();
    }

    @Override
    public void inventoryChanged() {
        this.computeElectricalLoad();
    }

    public final void computeElectricalLoad() {
        this.currentRelayDescriptor.applyTo(this.aLoad);
        this.currentRelayDescriptor.applyTo(this.bLoad);
        this.refreshSwitchResistor();
    }

    private final void configThermalLoad(ThermalLoad thermalLoad) {
        thermalLoad.Rs = this.currentRelayDescriptor.getThermalRs();
        thermalLoad.heatCapacity = this.currentRelayDescriptor.getThermalC();
        thermalLoad.Rp = this.currentRelayDescriptor.getThermalRp();
    }

    @Override
    public void networkUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.networkUnserialize(stream);
        try {
            if (stream.readByte() == 3) {
                this.defaultOutput = !this.defaultOutput;
                this.needPublish();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void readConfigTool(@NotNull NBTTagCompound compound, @Nullable EntityPlayer invoker) {
        Intrinsics.checkNotNullParameter(compound, "compound");
        if (compound.func_74764_b("nc")) {
            this.defaultOutput = compound.func_74767_n("nc");
        }
    }

    @Override
    public void writeConfigTool(@NotNull NBTTagCompound compound, @Nullable EntityPlayer invoker) {
        Intrinsics.checkNotNullParameter(compound, "compound");
        compound.func_74757_a("nc", this.defaultOutput);
    }
}

