/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.currentrelay;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.RcInterpolator;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.currentrelay.CurrentRelayDescriptor;
import mods.eln.sixnode.currentrelay.CurrentRelayGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020 H\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020'2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020/H\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\f\"\u0004\b\u0013\u0010\u000eR\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u000eR\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u00060"}, d2={"Lmods/eln/sixnode/currentrelay/CurrentRelayRender;", "Lmods/eln/node/six/SixNodeElementRender;", "tileEntity", "Lmods/eln/node/six/SixNodeEntity;", "side", "Lmods/eln/misc/Direction;", "descriptor", "Lmods/eln/node/six/SixNodeDescriptor;", "(Lmods/eln/node/six/SixNodeEntity;Lmods/eln/misc/Direction;Lmods/eln/node/six/SixNodeDescriptor;)V", "boot", "", "getBoot", "()Z", "setBoot", "(Z)V", "currentRelayDescriptor", "Lmods/eln/sixnode/currentrelay/CurrentRelayDescriptor;", "defaultOutput", "getDefaultOutput", "setDefaultOutput", "interpolator", "Lmods/eln/misc/RcInterpolator;", "getInterpolator", "()Lmods/eln/misc/RcInterpolator;", "switchState", "getSwitchState", "setSwitchState", "getTileEntity", "()Lmods/eln/node/six/SixNodeEntity;", "setTileEntity", "(Lmods/eln/node/six/SixNodeEntity;)V", "clientToggleDefaultOutput", "", "draw", "getCableRender", "Lmods/eln/cable/CableRenderDescriptor;", "lrdu", "Lmods/eln/misc/LRDU;", "newGuiDraw", "Lnet/minecraft/client/gui/GuiScreen;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "publishUnserialize", "stream", "Ljava/io/DataInputStream;", "refresh", "deltaT", "", "Eln"})
public final class CurrentRelayRender
extends SixNodeElementRender {
    @NotNull
    private SixNodeEntity tileEntity;
    @NotNull
    private final CurrentRelayDescriptor currentRelayDescriptor;
    @NotNull
    private final RcInterpolator interpolator;
    private boolean boot;
    private boolean switchState;
    private boolean defaultOutput;

    public CurrentRelayRender(@NotNull SixNodeEntity tileEntity, @NotNull Direction side, @NotNull SixNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(tileEntity, "tileEntity");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(tileEntity, side, descriptor);
        this.tileEntity = tileEntity;
        this.currentRelayDescriptor = (CurrentRelayDescriptor)descriptor;
        this.interpolator = new RcInterpolator(this.currentRelayDescriptor.getSpeed());
        this.boot = true;
        this.switchState = true;
        this.defaultOutput = true;
    }

    @Override
    @NotNull
    public SixNodeEntity getTileEntity() {
        return this.tileEntity;
    }

    @Override
    public void setTileEntity(@NotNull SixNodeEntity sixNodeEntity) {
        Intrinsics.checkNotNullParameter(sixNodeEntity, "<set-?>");
        this.tileEntity = sixNodeEntity;
    }

    @NotNull
    public final RcInterpolator getInterpolator() {
        return this.interpolator;
    }

    public final boolean getBoot() {
        return this.boot;
    }

    public final void setBoot(boolean bl) {
        this.boot = bl;
    }

    public final boolean getSwitchState() {
        return this.switchState;
    }

    public final void setSwitchState(boolean bl) {
        this.switchState = bl;
    }

    public final boolean getDefaultOutput() {
        return this.defaultOutput;
    }

    public final void setDefaultOutput(boolean bl) {
        this.defaultOutput = bl;
    }

    @Override
    public void draw() {
        super.draw();
        float[] fArray = new float[]{2.5f, 2.5f, 2.5f, 2.5f};
        this.drawSignalPin(this.front, fArray);
        LRDU lRDU = this.front;
        Intrinsics.checkNotNull((Object)lRDU);
        lRDU.glRotateOnX();
        this.currentRelayDescriptor.draw(this.interpolator.get());
    }

    @Override
    public void refresh(float deltaT) {
        this.interpolator.step(deltaT);
    }

    @Override
    public void publishUnserialize(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.publishUnserialize(stream);
        try {
            this.switchState = stream.readBoolean();
            this.defaultOutput = stream.readBoolean();
            this.interpolator.setTarget(this.switchState ? 1.0f : 0.0f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.boot) {
            this.interpolator.setValueFromTarget();
        }
        this.boot = false;
    }

    public final void clientToggleDefaultOutput() {
        this.clientSend(3);
    }

    @Override
    @NotNull
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter(player, "player");
        return new CurrentRelayGui(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public CableRenderDescriptor getCableRender(@NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        if (lrdu == this.front) {
            return Eln.instance.signalCableDescriptor.render;
        }
        LRDU lRDU = this.front;
        Intrinsics.checkNotNull((Object)lRDU);
        if (lrdu != lRDU.left()) {
            LRDU lRDU2 = this.front;
            Intrinsics.checkNotNull((Object)lRDU2);
            if (lrdu != lRDU2.right()) return null;
        }
        CableRenderDescriptor cableRenderDescriptor = this.currentRelayDescriptor.getCable().render;
        return cableRenderDescriptor;
    }
}

