/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.diode;

import java.util.Collections;
import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.IFunction;
import mods.eln.misc.Obj3D;
import mods.eln.misc.RealisticEnum;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.ThermalLoadInitializer;
import mods.eln.sim.mna.component.ResistorSwitch;
import mods.eln.sixnode.diode.DiodeElement;
import mods.eln.sixnode.diode.DiodeRender;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class DiodeDescriptor
extends SixNodeDescriptor {
    private Obj3D.Obj3DPart base;
    private Obj3D.Obj3DPart diodeCables;
    private Obj3D.Obj3DPart diodeCore;
    double stdI;
    double stdU;
    ElectricalCableDescriptor cable;
    String descriptor;
    IFunction IfU;
    ThermalLoadInitializer thermal;

    public DiodeDescriptor(String name, IFunction IfU, double Imax, double stdU, double stdI, ThermalLoadInitializer thermal, ElectricalCableDescriptor cable, Obj3D obj) {
        super(name, DiodeElement.class, DiodeRender.class);
        this.IfU = IfU;
        this.cable = cable;
        this.thermal = thermal;
        thermal.setMaximalPower(stdU * stdI * 1.2);
        this.stdI = stdI;
        this.stdU = stdU;
        this.base = obj.getPart("Base");
        this.diodeCables = obj.getPart("DiodeCables");
        this.diodeCore = obj.getPart("DiodeCore");
        this.voltageLevelColor = cable.signalWire ? VoltageLevelColor.SignalVoltage : VoltageLevelColor.Neutral;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addEnergy(this.newItemStack());
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.2f);
            GL11.glScalef((float)1.25f, (float)1.25f, (float)1.25f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.draw();
        }
    }

    public void applyTo(ThermalLoad load) {
        this.thermal.applyTo(load);
    }

    public void applyTo(ElectricalLoad load) {
        this.cable.applyTo(load);
    }

    public void applyTo(ResistorSwitch resistorSwitch) {
        resistorSwitch.setResistance(this.stdU / this.stdI);
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        Collections.addAll(list, I18N.tr("Electrical current can only\nflow through the diode\nfrom anode to cathode", new Object[0]).split("\\\n"));
    }

    @Override
    public RealisticEnum addRealismContext(List<String> list) {
        super.addRealismContext(list);
        list.add(I18N.tr("Works, with the caveat that it's delayed a sim tick", new Object[0]));
        return RealisticEnum.IDEAL;
    }

    void draw() {
        if (this.base != null) {
            this.base.draw();
        }
        if (this.diodeCables != null) {
            this.diodeCables.draw();
        }
        if (this.diodeCore != null) {
            this.diodeCore.draw();
        }
    }
}

