/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalalarm;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalGateInput;
import mods.eln.sixnode.electricalalarm.ElectricalAlarmDescriptor;
import mods.eln.sixnode.electricalalarm.ElectricalAlarmSlowProcess;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricalAlarmElement
extends SixNodeElement {
    ElectricalAlarmDescriptor descriptor;
    public NbtElectricalGateInput inputGate = new NbtElectricalGateInput("inputGate");
    public ElectricalAlarmSlowProcess slowProcess = new ElectricalAlarmSlowProcess(this);
    boolean warm = false;
    boolean mute = false;
    public static final byte clientSoundToggle = 1;

    public ElectricalAlarmElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.electricalLoadList.add(this.inputGate);
        this.slowProcessList.add(this.slowProcess);
        this.descriptor = (ElectricalAlarmDescriptor)descriptor;
    }

    public static boolean canBePlacedOnSide(Direction side, int type) {
        return true;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        byte value = nbt.func_74771_c("front");
        this.front = LRDU.fromInt(value >> 0 & 3);
        this.mute = nbt.func_74767_n("mute");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74774_a("front", (byte)(this.front.toInt() << 0));
        nbt.func_74757_a("mute", this.mute);
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu, int mask) {
        if (this.front == lrdu) {
            return this.inputGate;
        }
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.front == lrdu) {
            return 4;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return Utils.plotVolt("U:", this.inputGate.getVoltage()) + Utils.plotAmpere("I:", this.inputGate.getCurrent());
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Engaged", new Object[0]), this.inputGate.stateHigh() ? I18N.tr("Yes", new Object[0]) : I18N.tr("No", new Object[0]));
        if (Eln.wailaEasyMode) {
            info.put(I18N.tr("Input Voltage", new Object[0]), Utils.plotVolt("", this.inputGate.getVoltage()));
        }
        return info;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeByte((this.front.toInt() << 4) + (this.warm ? 1 : 0));
            stream.writeBoolean(this.mute);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setWarm(boolean value) {
        if (this.warm != value) {
            this.warm = value;
            this.sixNode.recalculateLightValue();
            this.needPublish();
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public int getLightValue() {
        return this.warm ? this.descriptor.light : 0;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            switch (stream.readByte()) {
                case 1: {
                    this.mute = !this.mute;
                    this.needPublish();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

