/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalalarm;

import mods.eln.misc.Coordinate;
import mods.eln.misc.Utils;
import mods.eln.sim.IProcess;
import mods.eln.sixnode.electricalalarm.ElectricalAlarmElement;
import mods.eln.sound.SoundCommand;

public class ElectricalAlarmSlowProcess
implements IProcess {
    ElectricalAlarmElement element;
    double timeCounter = 0.0;
    double soundTimeTimeout = Math.random() * 2.0;
    static final double refreshPeriode = 0.25;
    int soundUuid = Utils.getUuid();
    boolean oldWarm = false;
    boolean oldMute = true;

    public ElectricalAlarmSlowProcess(ElectricalAlarmElement element) {
        this.element = element;
    }

    @Override
    public void process(double time) {
        this.timeCounter += time;
        if (this.timeCounter > 0.25) {
            this.timeCounter -= 0.25;
            boolean warm = this.element.inputGate.getVoltage() > 5.0 / 2.0;
            this.element.setWarm(warm);
            if (warm & !this.element.mute && this.soundTimeTimeout == 0.0) {
                float speed = 1.0f;
                Coordinate coord = this.element.sixNode.coordinate;
                this.element.play(new SoundCommand(this.element.descriptor.soundName).mulVolume(1.0f, 1.0f).longRange().addUuid(this.soundUuid));
                this.soundTimeTimeout = this.element.descriptor.soundTime;
            }
            if (this.oldWarm && !warm || !this.oldMute && this.element.mute) {
                this.stopSound();
            }
            this.oldWarm = warm;
            this.oldMute = this.element.mute;
        }
        this.soundTimeTimeout -= time;
        if (this.soundTimeTimeout < 0.0) {
            this.soundTimeTimeout = 0.0;
        }
    }

    void stopSound() {
        this.element.stop(this.soundUuid);
        this.soundTimeTimeout = 0.0;
    }
}

