/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalbreaker;

import java.util.Collections;
import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.electricalbreaker.ElectricalBreakerElement;
import mods.eln.sixnode.electricalbreaker.ElectricalBreakerRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;

public class ElectricalBreakerDescriptor
extends SixNodeDescriptor {
    private Obj3D obj;
    private Obj3D.Obj3DPart main;
    private Obj3D.Obj3DPart lever;
    private Obj3D.Obj3DPart led;
    float alphaOff;
    float alphaOn;
    float speed;

    public ElectricalBreakerDescriptor(String name, Obj3D obj) {
        super(name, ElectricalBreakerElement.class, ElectricalBreakerRender.class);
        this.obj = obj;
        if (obj != null) {
            this.main = obj.getPart("case");
            this.lever = obj.getPart("lever");
            if (this.lever != null) {
                this.speed = this.lever.getFloat("speed");
                this.alphaOff = this.lever.getFloat("alphaOff");
                this.alphaOn = this.lever.getFloat("alphaOn");
            }
        }
        this.voltageLevelColor = VoltageLevelColor.Neutral;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addWiring(this.newItemStack());
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            this.draw(0.0f, 0.0f);
        }
    }

    public void draw(float on2, float distance) {
        if (this.main != null) {
            this.main.draw();
        }
        if (this.lever != null) {
            this.lever.draw(on2 * (this.alphaOn - this.alphaOff) + this.alphaOff, 0.0f, 1.0f, 0.0f);
        }
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        Collections.addAll(list, I18N.tr("Protects electrical components\nOpens contact if:\n  - Voltage exceeds a certain level\n  - Current exceeds the cable limit", new Object[0]).split("\n"));
    }

    @Override
    @Nullable
    public LRDU getFrontFromPlace(@NotNull Direction side, @NotNull EntityPlayer player) {
        return super.getFrontFromPlace(side, player).inverse();
    }
}

