/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalbreaker;

import java.text.NumberFormat;
import java.text.ParseException;
import mods.eln.gui.GuiContainerEln;
import mods.eln.gui.GuiHelperContainer;
import mods.eln.gui.GuiTextFieldEln;
import mods.eln.gui.HelperStdContainerSmall;
import mods.eln.gui.IGuiObject;
import mods.eln.i18n.I18N;
import mods.eln.sixnode.electricalbreaker.ElectricalBreakerContainer;
import mods.eln.sixnode.electricalbreaker.ElectricalBreakerRender;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;

public class ElectricalBreakerGui
extends GuiContainerEln {
    GuiButton toogleSwitch;
    GuiTextFieldEln setUmin;
    GuiTextFieldEln setUmax;
    ElectricalBreakerRender render;

    public ElectricalBreakerGui(EntityPlayer player, IInventory inventory, ElectricalBreakerRender render) {
        super(new ElectricalBreakerContainer(player, inventory));
        this.render = render;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.setUmin = this.newGuiTextField(12, 32, 50);
        this.setUmax = this.newGuiTextField(12, 14, 50);
        this.setUmin.setText(this.render.uMin);
        this.setUmax.setText(this.render.uMax);
        this.setUmin.setComment(0, I18N.tr("Minimum voltage before cutting off", new Object[0]));
        this.setUmax.setComment(0, I18N.tr("Maximum voltage before cutting off", new Object[0]));
        this.toogleSwitch = this.newGuiButton(70, 19, 70, I18N.tr("Toggle switch", new Object[0]));
    }

    @Override
    public void guiObjectEvent(IGuiObject object) {
        super.guiObjectEvent(object);
        if (object == this.setUmax) {
            try {
                this.render.clientSetVoltageMax(NumberFormat.getInstance().parse(this.setUmax.func_146179_b()).floatValue());
            }
            catch (ParseException parseException) {}
        } else if (object == this.setUmin) {
            try {
                this.render.clientSetVoltageMin(NumberFormat.getInstance().parse(this.setUmin.func_146179_b()).floatValue());
            }
            catch (ParseException parseException) {}
        } else if (object == this.toogleSwitch) {
            this.render.clientToogleSwitch();
        }
    }

    @Override
    protected void preDraw(float f, int x, int y) {
        super.preDraw(f, x, y);
        this.toogleSwitch.field_146126_j = !this.render.switchState ? I18N.tr("Switch is off", new Object[0]) : I18N.tr("Switch is on", new Object[0]);
    }

    @Override
    protected GuiHelperContainer newHelper() {
        return new HelperStdContainerSmall((GuiScreen)this);
    }

    static enum SelectedType {
        none,
        min,
        max;

    }
}

