/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalcable;

import java.util.Collections;
import java.util.List;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.i18n.I18N;
import mods.eln.misc.RealisticEnum;
import mods.eln.misc.Utils;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sixnode.electricalcable.ElectricalCableElement;
import mods.eln.sixnode.electricalcable.ElectricalCableRender;
import mods.eln.sixnode.genericcable.GenericCableDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ElectricalCableDescriptor
extends GenericCableDescriptor {
    public double electricalNominalPowerDropFactor;
    public boolean signalWire;
    public double electricalRp = Double.POSITIVE_INFINITY;
    public double electricalRsPerCelcius = 0.0;
    public double dielectricBreakOhmPerVolt = 0.0;
    public double dielectricBreakOhm = Double.POSITIVE_INFINITY;
    public double dielectricVoltage = Double.POSITIVE_INFINITY;
    public double dielectricBreakOhmMin = Double.POSITIVE_INFINITY;
    String description = "todo cable";

    public ElectricalCableDescriptor(String name, CableRenderDescriptor render, String description, boolean signalWire) {
        super(name, (Class)ElectricalCableElement.class, (Class)ElectricalCableRender.class);
        this.thermalRp = 1.0;
        this.thermalRs = 1.0;
        this.thermalC = 1.0;
        this.description = description;
        this.render = render;
        this.signalWire = signalWire;
        this.thermalWarmLimit = 100.0;
        this.thermalCoolLimit = -100.0;
    }

    public void setPhysicalConstantLikeNormalCable(double electricalNominalVoltage, double electricalNominalPower, double electricalNominalPowerDropFactor, double electricalMaximalVoltage, double electricalMaximalPower, double electricalOverVoltageStartPowerLost, double thermalWarmLimit, double thermalCoolLimit, double thermalNominalHeatTime, double thermalConductivityTao) {
        this.electricalNominalVoltage = electricalNominalVoltage;
        this.electricalNominalPower = electricalNominalPower;
        this.electricalNominalPowerDropFactor = electricalNominalPowerDropFactor;
        this.thermalWarmLimit = thermalWarmLimit;
        this.thermalCoolLimit = thermalCoolLimit;
        this.electricalMaximalVoltage = electricalMaximalVoltage;
        this.electricalRp = 1.0E9;
        double electricalNorminalI = electricalNominalPower / electricalNominalVoltage;
        this.electricalRs = electricalNominalPower * electricalNominalPowerDropFactor / electricalNorminalI / electricalNorminalI / 2.0;
        electricalNominalPower = electricalMaximalPower / electricalNominalVoltage;
        double thermalMaximalPowerDissipated = electricalNominalPower * electricalNominalPower * this.electricalRs * 2.0;
        this.thermalC = thermalMaximalPowerDissipated * thermalNominalHeatTime / thermalWarmLimit;
        this.thermalRp = thermalWarmLimit / thermalMaximalPowerDissipated;
        this.thermalRs = thermalConductivityTao / this.thermalC / 2.0;
        Eln.simulator.checkThermalLoad(this.thermalRs, this.thermalRp, this.thermalC);
        this.electricalRsPerCelcius = 0.0;
        this.dielectricBreakOhmPerVolt = 0.95;
        this.dielectricBreakOhm = electricalMaximalVoltage * electricalMaximalVoltage / electricalOverVoltageStartPowerLost;
        this.dielectricVoltage = electricalMaximalVoltage;
        this.dielectricBreakOhmMin = this.dielectricBreakOhm;
        this.electricalMaximalCurrent = electricalMaximalPower / electricalNominalVoltage;
        this.voltageLevelColor = this.electricalNominalVoltage > 4000.0 ? VoltageLevelColor.Grid : VoltageLevelColor.fromCable(this);
    }

    @Override
    public void applyTo(ElectricalLoad electricalLoad, double rsFactor) {
        electricalLoad.setSerialResistance(this.electricalRs * rsFactor);
    }

    @Override
    public void applyTo(ElectricalLoad electricalLoad) {
        this.applyTo(electricalLoad, 1.0);
    }

    @Override
    public void applyTo(Resistor resistor) {
        this.applyTo(resistor, 1.0);
    }

    @Override
    public void applyTo(Resistor resistor, double factor) {
        resistor.setResistance(this.electricalRs * factor);
    }

    @Override
    public void applyTo(ThermalLoad thermalLoad) {
        thermalLoad.Rs = this.thermalRs;
        thermalLoad.heatCapacity = this.thermalC;
        thermalLoad.Rp = this.thermalRp;
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        if (this.signalWire) {
            Collections.addAll(list, I18N.tr("Cable is adapted to conduct\nelectrical signals.", new Object[0]).split("\n"));
            Collections.addAll(list, I18N.tr("A signal is electrical information\nwhich must be between 0V and %1$", Utils.plotVolt(5.0)).split("\n"));
            list.add(I18N.tr("Not adapted to transport power.", new Object[0]));
        } else {
            list.add(I18N.tr("Nominal Ratings:", new Object[0]));
            list.add("  " + I18N.tr("Voltage: %1$V", Utils.plotValue(this.electricalNominalVoltage)));
            list.add("  " + I18N.tr("Current: %1$A", Utils.plotValue(this.electricalNominalPower / this.electricalNominalVoltage)));
            list.add("  " + I18N.tr("Power: %1$W", Utils.plotValue(this.electricalNominalPower)));
            list.add("  " + I18N.tr("Serial resistance: %1$\u2126", Utils.plotValue(this.electricalRs * 2.0)));
        }
    }

    public RealisticEnum addRealismContext(List list) {
        list.add(I18N.tr("Has some caveats:", new Object[0]));
        list.add(I18N.tr("  * Wire resistance is much higher than normal", new Object[0]));
        list.add(I18N.tr("  * Wire resistance is not impacted by temperature", new Object[0]));
        list.add(I18N.tr("  * Wire voltage/current limits are arbitrary values, added as a gameplay mechanic", new Object[0]));
        return RealisticEnum.REALISTIC;
    }

    @Override
    public int getNodeMask() {
        if (this.signalWire) {
            return 4;
        }
        return 1;
    }

    public void bindCableTexture() {
        this.render.bindCableTexture();
    }
}

