/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalcable;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.i18n.I18N;
import mods.eln.item.BrushDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sim.process.heater.ElectricalLoadHeatThermalLoad;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricalCableElement
extends SixNodeElement {
    public ElectricalCableDescriptor descriptor;
    public NbtElectricalLoad electricalLoad = new NbtElectricalLoad("electricalLoad");
    NbtThermalLoad thermalLoad = new NbtThermalLoad("thermalLoad");
    ElectricalLoadHeatThermalLoad heater = new ElectricalLoadHeatThermalLoad(this.electricalLoad, this.thermalLoad);
    ThermalLoadWatchDog thermalWatchdog = new ThermalLoadWatchDog(this.thermalLoad);
    VoltageStateWatchDog voltageWatchdog = new VoltageStateWatchDog(this.electricalLoad);
    int color;
    int colorCare;

    public ElectricalCableElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.descriptor = (ElectricalCableDescriptor)descriptor;
        this.color = 0;
        this.colorCare = 1;
        this.electricalLoad.setCanBeSimplifiedByLine(true);
        this.electricalLoadList.add(this.electricalLoad);
        if (!this.descriptor.signalWire) {
            this.thermalLoadList.add(this.thermalLoad);
            this.thermalSlowProcessList.add(this.heater);
            this.thermalLoad.setAsSlow();
            this.slowProcessList.add(this.thermalWatchdog);
            this.thermalWatchdog.setTemperatureLimits(this.descriptor.thermalWarmLimit, this.descriptor.thermalCoolLimit).setDestroys(new WorldExplosion(this).cableExplosion());
        }
        this.slowProcessList.add(this.voltageWatchdog);
        this.voltageWatchdog.setNominalVoltage(this.descriptor.electricalNominalVoltage).setDestroys(new WorldExplosion(this).cableExplosion());
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        byte b = nbt.func_74771_c("color");
        this.color = b & 0xF;
        this.colorCare = b >> 4 & 1;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74774_a("color", (byte)(this.color + (this.colorCare << 4)));
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull LRDU lrdu, int mask) {
        return this.electricalLoad;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        if (!this.descriptor.signalWire) {
            return this.thermalLoad;
        }
        return null;
    }

    @Override
    public int getConnectionMask(@NotNull LRDU lrdu) {
        return this.descriptor.getNodeMask() + (this.color << 16) + (this.colorCare << 20);
    }

    @Override
    public String multiMeterString() {
        if (!this.descriptor.signalWire) {
            return Utils.plotUIP(this.electricalLoad.getVoltage(), this.electricalLoad.getCurrent()) + " " + Utils.plotPower("Cable Power Loss", this.electricalLoad.getCurrent() * this.electricalLoad.getCurrent() * this.electricalLoad.getSerialResistance());
        }
        return Utils.plotSignal(this.electricalLoad.getVoltage());
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        if (this.descriptor.signalWire) {
            info.put(I18N.tr("Signal Voltage", new Object[0]), Utils.plotVolt("", this.electricalLoad.getVoltage()));
        } else {
            info.put(I18N.tr("Current", new Object[0]), Utils.plotAmpere("", this.electricalLoad.getCurrent()));
            info.put(I18N.tr("Temperature", new Object[0]), Utils.plotCelsius("", this.thermalLoad.getTemperature()));
            if (Eln.wailaEasyMode) {
                info.put(I18N.tr("Voltage", new Object[0]), Utils.plotVolt("", this.electricalLoad.getVoltage()));
            }
        }
        info.put(I18N.tr("Subsystem Matrix Size", new Object[0]), Utils.renderSubSystemWaila(this.electricalLoad.getSubSystem()));
        return info;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        if (!this.descriptor.signalWire) {
            return Utils.plotCelsius("T", this.thermalLoad.temperatureCelsius);
        }
        return null;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeByte(this.color << 4);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize() {
        this.descriptor.applyTo(this.electricalLoad);
        this.descriptor.applyTo(this.thermalLoad);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        ItemStack currentItemStack = entityPlayer.func_71045_bC();
        if (Utils.isPlayerUsingWrench(entityPlayer)) {
            this.colorCare ^= 1;
            Utils.addChatMessage(entityPlayer, "Wire color care " + this.colorCare);
            this.sixNode.reconnect();
        } else if (currentItemStack != null) {
            BrushDescriptor brush;
            int brushColor;
            Item item = currentItemStack.func_77973_b();
            GenericItemUsingDamageDescriptor gen = GenericItemUsingDamageDescriptor.getDescriptor(currentItemStack);
            if (gen instanceof BrushDescriptor && (brushColor = (brush = (BrushDescriptor)gen).getColor(currentItemStack)) != this.color && brush.use(currentItemStack, entityPlayer)) {
                this.color = brushColor;
                this.sixNode.reconnect();
            }
        }
        return false;
    }
}

