/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalcable;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.cable.CableRender;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class ElectricalCableRender
extends SixNodeElementRender {
    ElectricalCableDescriptor descriptor;
    int color = 0;

    public ElectricalCableRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (ElectricalCableDescriptor)descriptor;
    }

    @Override
    public boolean drawCableAuto() {
        return false;
    }

    @Override
    public void draw() {
        Minecraft.func_71410_x().field_71424_I.func_76320_a("ECable");
        Utils.setGlColorFromDye(this.color, 1.0f);
        UtilsClient.bindTexture(this.descriptor.render.cableTexture);
        this.glListCall();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }

    @Override
    public void glListDraw() {
        CableRender.drawCable(this.descriptor.render, this.connectedSide, CableRender.connectionType(this, this.side), this.descriptor.render.getWidthDiv2() / 2.0f, false);
        CableRender.drawNode(this.descriptor.render, this.connectedSide, CableRender.connectionType(this, this.side));
    }

    @Override
    public boolean glListEnable() {
        return true;
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            Byte b = stream.readByte();
            this.color = b >> 4 & 0xF;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public CableRenderDescriptor getCableRender(LRDU lrdu) {
        return this.descriptor.render;
    }

    @Override
    public int getCableDry(LRDU lrdu) {
        return this.color;
    }
}

