/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricaldatalogger;

import java.util.Collections;
import java.util.List;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.electricaldatalogger.DataLogs;
import mods.eln.sixnode.electricaldatalogger.ElectricalDataLoggerElement;
import mods.eln.sixnode.electricaldatalogger.ElectricalDataLoggerRender;
import mods.eln.wiki.Data;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ElectricalDataLoggerDescriptor
extends SixNodeDescriptor {
    Obj3D obj;
    Obj3D.Obj3DPart main;
    Obj3D.Obj3DPart led;
    Obj3D.Obj3DPart reflection;
    float sx;
    float sy;
    float sz;
    float tx;
    float ty;
    float tz;
    float rx;
    float ry;
    float rz;
    float ra;
    float mx;
    float my;
    float cr;
    float cg;
    float cb;
    float reflc;
    public boolean onFloor;
    public String textColor;

    public ElectricalDataLoggerDescriptor(String name, boolean onFloor, String objName, float cr, float cg, float cb, String textColor) {
        super(name, ElectricalDataLoggerElement.class, ElectricalDataLoggerRender.class);
        this.cb = cb;
        this.cr = cr;
        this.cg = cg;
        this.onFloor = onFloor;
        this.textColor = textColor;
        this.obj = Eln.obj.getObj(objName);
        if (this.obj != null) {
            this.main = this.obj.getPart("main");
            this.reflection = this.obj.getPart("reflection");
            if (this.main != null) {
                this.sx = this.main.getFloat("sx");
                this.sy = this.main.getFloat("sy");
                this.sz = this.main.getFloat("sz");
                this.tx = this.main.getFloat("tx");
                this.ty = this.main.getFloat("ty");
                this.tz = this.main.getFloat("tz");
                this.rx = this.main.getFloat("rx");
                this.ry = this.main.getFloat("ry");
                this.rz = this.main.getFloat("rz");
                this.ra = this.main.getFloat("ra");
                this.mx = this.main.getFloat("mx");
                this.my = this.main.getFloat("my");
                this.reflc = this.main.getFloat("reflc");
                this.led = this.obj.getPart("led");
            }
        }
        if (onFloor) {
            this.setPlaceDirection(Direction.YN);
        }
        this.voltageLevelColor = VoltageLevelColor.SignalVoltage;
    }

    void draw(DataLogs log, Direction side, LRDU front, int objPosMX, int objPosMZ, byte color) {
        if (this.onFloor || side.isY()) {
            front.glRotateOnX();
        }
        if (!this.onFloor && side.isNotY()) {
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (this.main != null) {
            Utils.setGlColorFromDye(color);
            this.main.draw();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
        UtilsClient.enableBlend();
        this.obj.bindTexture("Reflection.png");
        float rotYaw = Minecraft.func_71410_x().field_71439_g.field_70177_z / 360.0f;
        float rotPitch = Minecraft.func_71410_x().field_71439_g.field_70125_A / 180.0f;
        float pos = ((float)Minecraft.func_71410_x().field_71439_g.field_70165_t - (float)(objPosMX * 2) + (float)Minecraft.func_71410_x().field_71439_g.field_70161_v - (float)(objPosMZ * 2)) / 24.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.reflc);
        this.reflection.draw(rotYaw + pos, rotPitch * 0.857f);
        UtilsClient.disableBlend();
        if (log != null) {
            UtilsClient.disableLight();
            UtilsClient.ledOnOffColor(true);
            if (this.led != null) {
                this.led.draw();
            }
            UtilsClient.glDefaultColor();
            GL11.glTranslatef((float)this.tx, (float)this.ty, (float)this.tz);
            GL11.glRotatef((float)this.ra, (float)this.rx, (float)this.ry, (float)this.rz);
            GL11.glScalef((float)this.sx, (float)this.sy, (float)this.sz);
            GL11.glColor4f((float)this.cr, (float)this.cg, (float)this.cb, (float)1.0f);
            log.draw(this.mx, this.my, this.textColor);
            UtilsClient.glDefaultColor();
            UtilsClient.enableLight();
        }
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addSignal(this.newItemStack());
    }

    @Override
    public boolean hasVolume() {
        return this.onFloor;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else if (this.main != null) {
            this.main.draw();
        }
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        Collections.addAll(list, I18N.tr("Measures the voltage of an\nelectrical signal and plots\nthe data in real time.", new Object[0]).split("\n"));
        list.add(I18N.tr("It can store up to 256 points.", new Object[0]));
    }

    @Override
    @Nullable
    public LRDU getFrontFromPlace(@NotNull Direction side, @NotNull EntityPlayer player) {
        LRDU front = super.getFrontFromPlace(side, player);
        if (this.onFloor) {
            return front.inverse();
        }
        return front;
    }
}

