/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricaldatalogger;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.i18n.I18N;
import mods.eln.item.BrushDescriptor;
import mods.eln.item.IConfigurable;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalGateInput;
import mods.eln.sixnode.electricaldatalogger.DataLogs;
import mods.eln.sixnode.electricaldatalogger.ElectricalDataLoggerContainer;
import mods.eln.sixnode.electricaldatalogger.ElectricalDataLoggerDescriptor;
import mods.eln.sixnode.electricaldatalogger.ElectricalDataLoggerProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricalDataLoggerElement
extends SixNodeElement
implements IConfigurable {
    public static final int logsSizeMax = 256;
    public int sampleStack;
    public int sampleStackNbr;
    NbtElectricalGateInput inputGate;
    ElectricalDataLoggerProcess slowProcess = new ElectricalDataLoggerProcess(this);
    public ElectricalDataLoggerDescriptor descriptor;
    SixNodeElementInventory inventory = new SixNodeElementInventory(2, 64, this);
    public double timeToNextSample = 0.0;
    public byte color = (byte)15;
    public DataLogs logs = new DataLogs(256);
    static final byte publishId = 1;
    static final byte dataId = 2;
    public static final byte resetId = 1;
    public static final byte setSamplingPeriodeId = 2;
    public static final byte setMaxValue = 3;
    public static final byte setUnitId = 4;
    public static final byte newClientId = 5;
    public static final byte printId = 6;
    public static final byte tooglePauseId = 7;
    public static final byte setMinValue = 8;
    public static final byte toClientLogsClear = 1;
    public static final byte toClientLogsAdd = 2;
    boolean printToDo;
    boolean pause = false;

    public ElectricalDataLoggerElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.descriptor = (ElectricalDataLoggerDescriptor)descriptor;
        this.inputGate = new NbtElectricalGateInput("inputGate");
        this.electricalLoadList.add(this.inputGate);
        this.electricalProcessList.add(this.slowProcess);
        this.sampleStackReset();
    }

    public static boolean canBePlacedOnSide(Direction side, SixNodeDescriptor descriptor) {
        return ((ElectricalDataLoggerDescriptor)descriptor).onFloor && side == Direction.YN;
    }

    @Override
    public SixNodeElementInventory getInventory() {
        return this.inventory;
    }

    public static boolean canBePlacedOnSide(Direction side, int type) {
        return true;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        byte value = nbt.func_74771_c("front");
        this.front = LRDU.fromInt(value >> 0 & 3);
        this.logs.readFromNBT(nbt, "logs");
        this.pause = nbt.func_74767_n("pause");
        this.timeToNextSample = nbt.func_74769_h("timeToNextSample");
        this.sampleStack = nbt.func_74762_e("sampleStack");
        this.sampleStackNbr = nbt.func_74762_e("sampleStackNbr");
        this.color = nbt.func_74771_c("color");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74774_a("front", (byte)(this.front.toInt() << 0));
        nbt.func_74780_a("timeToNextSample", this.timeToNextSample);
        nbt.func_74757_a("pause", this.pause);
        nbt.func_74774_a("color", this.color);
        this.logs.writeToNBT(nbt, "logs");
        nbt.func_74768_a("sampleStack", this.sampleStack);
        nbt.func_74768_a("sampleStackNbr", this.sampleStackNbr);
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu, int mask) {
        if (this.front.inverse() == lrdu) {
            return this.inputGate;
        }
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.front.inverse() == lrdu) {
            return 4;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return this.inputGate.plot("In: ");
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Input", new Object[0]), Utils.plotVolt("", this.inputGate.getVoltage()));
        return info;
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeByte(this.logs.unitType);
            stream.writeBoolean(this.pause);
            stream.writeFloat(this.logs.samplingPeriod);
            stream.writeFloat(this.logs.maxValue);
            stream.writeFloat(this.logs.minValue);
            stream.writeByte(this.color);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize() {
        this.computeElectricalLoad();
    }

    @Override
    public void inventoryChanged() {
        this.computeElectricalLoad();
    }

    public void computeElectricalLoad() {
    }

    @Override
    public void networkUnserialize(DataInputStream stream, EntityPlayerMP player) {
        super.networkUnserialize(stream);
        try {
            byte header = stream.readByte();
            switch (header) {
                case 2: {
                    this.logs.reset();
                    this.sampleStackReset();
                    this.logs.samplingPeriod = stream.readFloat();
                    this.timeToNextSample = 0.1;
                    this.needPublish();
                    break;
                }
                case 3: {
                    this.logs.maxValue = stream.readFloat();
                    this.needPublish();
                    break;
                }
                case 8: {
                    this.logs.minValue = stream.readFloat();
                    this.needPublish();
                    break;
                }
                case 4: {
                    this.logs.unitType = stream.readByte();
                    this.needPublish();
                    break;
                }
                case 1: {
                    this.sampleStackReset();
                    this.logs.reset();
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    this.printToDo = true;
                    break;
                }
                case 7: {
                    this.pause = !this.pause;
                    this.needPublish();
                }
            }
            if (header == 1 || header == 5 || header == 2) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(64);
                DataOutputStream packet = new DataOutputStream(bos);
                this.preparePacketForClient(packet);
                packet.writeByte(1);
                int size = this.logs.size();
                for (int idx = size - 1; idx >= 0; --idx) {
                    packet.writeByte(this.logs.read(idx));
                }
                if (header == 5) {
                    this.sendPacketToClient(bos, player);
                } else {
                    this.sendPacketToAllClient(bos);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    @Nullable
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new ElectricalDataLoggerContainer(player, this.inventory);
    }

    public void sampleStackReset() {
        this.sampleStack = 0;
        this.sampleStackNbr = 0;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        GenericItemUsingDamageDescriptor desc;
        ItemStack cur = entityPlayer.func_71045_bC();
        if (cur != null && (desc = BrushDescriptor.getDescriptor(cur)) != null && desc instanceof BrushDescriptor) {
            BrushDescriptor brush = (BrushDescriptor)desc;
            int brushColor = brush.getColor(cur);
            if (brushColor != this.color && brush.use(cur, entityPlayer)) {
                this.color = (byte)brushColor;
                this.needPublish();
            }
            return true;
        }
        return this.onBlockActivatedRotate(entityPlayer);
    }

    @Override
    public void readConfigTool(NBTTagCompound compound, EntityPlayer invoker) {
        if (compound.func_74764_b("min")) {
            this.logs.minValue = compound.func_74760_g("min");
        }
        if (compound.func_74764_b("max")) {
            this.logs.maxValue = compound.func_74760_g("max");
        }
        if (compound.func_74764_b("unit")) {
            this.logs.unitType = compound.func_74771_c("unit");
        }
        if (compound.func_74764_b("period")) {
            this.logs.samplingPeriod = compound.func_74760_g("period");
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(64);
            DataOutputStream packet = new DataOutputStream(bos);
            this.preparePacketForClient(packet);
            packet.writeByte(1);
            int size = this.logs.size();
            for (int i = size - 1; i >= 0; --i) {
                packet.writeByte(this.logs.read(i));
            }
            this.sendPacketToAllClient(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.needPublish();
    }

    @Override
    public void writeConfigTool(NBTTagCompound compound, EntityPlayer invoker) {
        compound.func_74776_a("min", this.logs.minValue);
        compound.func_74776_a("max", this.logs.maxValue);
        compound.func_74774_a("unit", this.logs.unitType);
        compound.func_74776_a("period", this.logs.samplingPeriod);
    }
}

