/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricaldatalogger;

import java.text.NumberFormat;
import java.text.ParseException;
import mods.eln.gui.GuiContainerEln;
import mods.eln.gui.GuiHelperContainer;
import mods.eln.gui.GuiTextFieldEln;
import mods.eln.gui.IGuiObject;
import mods.eln.i18n.I18N;
import mods.eln.misc.FC;
import mods.eln.misc.UtilsClient;
import mods.eln.sixnode.electricaldatalogger.ElectricalDataLoggerContainer;
import mods.eln.sixnode.electricaldatalogger.ElectricalDataLoggerRender;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import org.lwjgl.opengl.GL11;

public class ElectricalDataLoggerGui
extends GuiContainerEln
implements GuiTextFieldEln.GuiTextFieldElnObserver {
    GuiButton resetBt;
    GuiButton voltageType;
    GuiButton energyType;
    GuiButton currentType;
    GuiButton powerType;
    GuiButton celsiusType;
    GuiButton percentType;
    GuiButton noType;
    GuiButton config;
    GuiButton printBt;
    GuiButton pause;
    GuiTextFieldEln samplingPeriod;
    GuiTextFieldEln maxValue;
    GuiTextFieldEln minValue;
    GuiTextFieldEln yCursorValue;
    ElectricalDataLoggerRender render;
    State state = State.display;

    public ElectricalDataLoggerGui(EntityPlayer player, IInventory inventory, ElectricalDataLoggerRender render) {
        super(new ElectricalDataLoggerContainer(player, inventory));
        this.render = render;
    }

    void displayEntry() {
        this.config.field_146126_j = I18N.tr("Configuration", new Object[0]);
        this.config.field_146125_m = true;
        this.pause.field_146125_m = true;
        this.resetBt.field_146125_m = true;
        this.voltageType.field_146125_m = false;
        this.energyType.field_146125_m = false;
        this.percentType.field_146125_m = false;
        this.noType.field_146125_m = false;
        this.currentType.field_146125_m = false;
        this.powerType.field_146125_m = false;
        this.celsiusType.field_146125_m = false;
        this.samplingPeriod.func_146189_e(false);
        this.maxValue.func_146189_e(false);
        this.minValue.func_146189_e(false);
        this.printBt.field_146125_m = true;
        this.state = State.display;
    }

    void configEntry() {
        this.pause.field_146125_m = false;
        this.config.field_146125_m = true;
        this.config.field_146126_j = I18N.tr("Back to display", new Object[0]);
        this.resetBt.field_146125_m = false;
        this.printBt.field_146125_m = true;
        this.voltageType.field_146125_m = true;
        this.energyType.field_146125_m = true;
        this.percentType.field_146125_m = true;
        this.noType.field_146125_m = true;
        this.currentType.field_146125_m = true;
        this.powerType.field_146125_m = true;
        this.celsiusType.field_146125_m = true;
        this.samplingPeriod.func_146189_e(true);
        this.maxValue.func_146189_e(true);
        this.minValue.func_146189_e(true);
        this.state = State.config;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.config = this.newGuiButton(38, 6, 100, "");
        this.voltageType = this.newGuiButton(11, 28, 75, I18N.tr("Voltage [V]", new Object[0]));
        this.currentType = this.newGuiButton(90, 28, 75, I18N.tr("Current [A]", new Object[0]));
        this.powerType = this.newGuiButton(11, 50, 75, I18N.tr("Power [W]", new Object[0]));
        this.celsiusType = this.newGuiButton(90, 50, 75, I18N.tr("Temp. [*C]", new Object[0]));
        this.percentType = this.newGuiButton(11, 72, 75, I18N.tr("Percent [-]%", new Object[0]));
        this.energyType = this.newGuiButton(90, 72, 75, I18N.tr("Energy [J]", new Object[0]));
        this.noType = this.newGuiButton(49, 94, 75, I18N.tr("Unit", new Object[0]));
        this.resetBt = this.newGuiButton(38, 28, 48, I18N.tr("Reset", new Object[0]));
        this.pause = this.newGuiButton(90, 28, 48, "");
        this.printBt = this.newGuiButton(64, 146, 48, I18N.tr("Print", new Object[0]));
        this.samplingPeriod = this.newGuiTextField(30, 124, 50);
        this.samplingPeriod.setText(this.render.log.samplingPeriod);
        this.samplingPeriod.setComment(new String[]{I18N.tr("Sampling period", new Object[0])});
        this.maxValue = this.newGuiTextField(96, 117, 50);
        this.maxValue.setText(this.render.log.maxValue);
        this.maxValue.setComment(new String[]{I18N.tr("Y-axis max", new Object[0])});
        this.minValue = this.newGuiTextField(96, 132, 50);
        this.minValue.setText(this.render.log.minValue);
        this.minValue.setComment(new String[]{I18N.tr("Y-axis min", new Object[0])});
        this.displayEntry();
    }

    @Override
    public void guiObjectEvent(IGuiObject object) {
        super.guiObjectEvent(object);
        try {
            if (object == this.resetBt) {
                this.render.clientSend(1);
            } else if (object == this.pause) {
                this.render.clientSend(7);
            } else if (object == this.printBt) {
                this.render.clientSend(6);
            } else if (object == this.currentType) {
                this.render.clientSetByte((byte)4, (byte)1);
            } else if (object == this.voltageType) {
                this.render.clientSetByte((byte)4, (byte)0);
            } else if (object == this.energyType) {
                this.render.clientSetByte((byte)4, (byte)5);
            } else if (object == this.percentType) {
                this.render.clientSetByte((byte)4, (byte)4);
            } else if (object == this.noType) {
                this.render.clientSetByte((byte)4, (byte)6);
            } else if (object == this.powerType) {
                this.render.clientSetByte((byte)4, (byte)2);
            } else if (object == this.celsiusType) {
                this.render.clientSetByte((byte)4, (byte)3);
            } else if (object == this.config) {
                switch (this.state) {
                    case config: {
                        this.displayEntry();
                        break;
                    }
                    case display: {
                        this.configEntry();
                        break;
                    }
                }
            } else if (object == this.maxValue) {
                this.render.clientSetFloat(3, NumberFormat.getInstance().parse(this.maxValue.func_146179_b()).floatValue());
            } else if (object == this.minValue) {
                this.render.clientSetFloat(8, NumberFormat.getInstance().parse(this.minValue.func_146179_b()).floatValue());
            } else if (object == this.samplingPeriod) {
                float value = NumberFormat.getInstance().parse(this.samplingPeriod.func_146179_b()).floatValue();
                if (value < 0.05f) {
                    value = 0.05f;
                }
                this.samplingPeriod.setText(value);
                this.render.clientSetFloat(2, value);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Override
    protected void preDraw(float f, int x, int y) {
        super.preDraw(f, x, y);
        this.powerType.field_146124_l = true;
        this.currentType.field_146124_l = true;
        this.voltageType.field_146124_l = true;
        this.celsiusType.field_146124_l = true;
        this.percentType.field_146124_l = true;
        this.energyType.field_146124_l = true;
        switch (this.render.log.unitType) {
            case 1: {
                this.currentType.field_146124_l = false;
                break;
            }
            case 0: {
                this.voltageType.field_146124_l = false;
                break;
            }
            case 2: {
                this.powerType.field_146124_l = false;
                break;
            }
            case 3: {
                this.celsiusType.field_146124_l = false;
                break;
            }
            case 4: {
                this.percentType.field_146124_l = false;
                break;
            }
            case 5: {
                this.energyType.field_146124_l = false;
                break;
            }
            case 6: {
                this.noType.field_146124_l = false;
            }
        }
        this.pause.field_146126_j = this.render.pause ? FC.DARK_YELLOW + "Paused" : FC.BRIGHT_GREEN + "Running";
        boolean a = this.field_147002_h.func_75139_a(0).func_75211_c() != null;
        boolean b = this.field_147002_h.func_75139_a(1).func_75211_c() == null;
        this.printBt.field_146124_l = a && b;
    }

    @Override
    protected void postDraw(float f, int x, int y) {
        super.postDraw(f, x, y);
        float bckrndMargin = 0.05f;
        if (this.state == State.display) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(this.field_147003_i + 8), (float)(this.field_147009_r + 53), (float)0.0f);
            GL11.glScalef((float)50.0f, (float)50.0f, (float)1.0f);
            GL11.glColor4f((float)0.15f, (float)0.15f, (float)0.15f, (float)1.0f);
            UtilsClient.disableTexture();
            UtilsClient.disableCulling();
            GL11.glBegin((int)7);
            GL11.glVertex2f((float)-0.05f, (float)-0.05f);
            GL11.glVertex2f((float)3.25f, (float)-0.05f);
            GL11.glVertex2f((float)3.25f, (float)1.75f);
            GL11.glVertex2f((float)-0.05f, (float)1.75f);
            GL11.glEnd();
            UtilsClient.enableCulling();
            UtilsClient.enableTexture();
            GL11.glColor4f((float)this.render.descriptor.cr, (float)this.render.descriptor.cg, (float)this.render.descriptor.cb, (float)1.0f);
            this.render.log.draw(2.9f, 1.6f, this.render.descriptor.textColor);
            GL11.glPopMatrix();
        }
    }

    @Override
    protected GuiHelperContainer newHelper() {
        return new GuiHelperContainer((GuiScreen)this, 176, 253, 8, 171);
    }

    static enum State {
        display,
        config;

    }
}

