/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricaldigitaldisplay;

import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.sixnode.electricaldigitaldisplay.ElectricalDigitalDisplayElement;
import mods.eln.sixnode.electricaldigitaldisplay.ElectricalDigitalDisplayRender;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ElectricalDigitalDisplayDescriptor
extends SixNodeDescriptor {
    protected Obj3D obj;
    protected Obj3D.Obj3DPart[] digits = new Obj3D.Obj3DPart[4];
    protected Obj3D.Obj3DPart[] dots = new Obj3D.Obj3DPart[5];
    protected Obj3D.Obj3DPart[] colons = new Obj3D.Obj3DPart[3];
    protected Obj3D.Obj3DPart base;
    protected Obj3D.Obj3DPart glass;
    public float[] pinDistance;
    public static int DOT_STATES = 256;
    public static final byte netSetRange = 1;

    public ElectricalDigitalDisplayDescriptor(String name, Obj3D obj_) {
        super(name, ElectricalDigitalDisplayElement.class, ElectricalDigitalDisplayRender.class);
        int i;
        this.obj = obj_;
        this.base = this.obj.getPart("base");
        this.pinDistance = Utils.getSixNodePinDistance(this.base);
        this.glass = this.obj.getPart("glass");
        for (i = 0; i < 4; ++i) {
            this.digits[i] = this.obj.getPart("digit" + i);
        }
        for (i = 0; i < 5; ++i) {
            this.dots[i] = this.obj.getPart("dot" + i);
        }
        for (i = 1; i < 4; ++i) {
            this.colons[i - 1] = this.obj.getPart("colon" + i);
        }
        this.voltageLevelColor = VoltageLevelColor.Neutral;
    }

    @Override
    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List<String> list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        list.add(I18N.tr("Displays signal value.", new Object[0]));
    }

    private void bitToColor(int i) {
        if (i != 0) {
            GL11.glColor3f((float)0.95f, (float)0.0f, (float)0.0f);
        } else {
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        }
    }

    void draw(int value, boolean strobe, Style style) {
        this.draw(value, strobe, style, 0, 0);
    }

    void draw(int value, boolean strobe, Style style, int dye) {
        this.draw(value, strobe, style, dye, 0);
    }

    void draw(int value, boolean strobe, Style style, int dye, int dotconfig) {
        int i;
        if (value < 0) {
            value = 0;
        }
        if (value > 9999) {
            value = 9999;
        }
        if (dotconfig < 0) {
            dotconfig = 0;
        }
        if (dotconfig > 255) {
            dotconfig = 255;
        }
        switch (style) {
            case LED: {
                this.obj.bindTexture("Digits_LED.png");
            }
        }
        UtilsClient.disableLight();
        GL11.glColor3f((float)0.95f, (float)0.0f, (float)0.0f);
        int divisor = 1;
        for (i = 0; i < 4; ++i) {
            if (strobe) {
                this.digits[i].draw(0.625f, 0.0f);
            } else {
                this.digits[i].draw((float)(value / divisor % 10) / 16.0f, 0.0f);
            }
            divisor *= 10;
        }
        if (!strobe) {
            for (i = 0; i < 5; ++i) {
                this.bitToColor(dotconfig & 1 << i);
                this.dots[i].draw();
            }
            for (i = 0; i < 3; ++i) {
                this.bitToColor(dotconfig & 1 << 5 + i);
                this.colons[i].draw();
            }
        }
        Utils.setGlColorFromDye(dye);
        UtilsClient.enableLight();
        this.base.draw();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        UtilsClient.enableBlend();
        this.obj.bindTexture("Reflection.png");
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        float normYaw = player.field_70177_z / 360.0f;
        float normPitch = player.field_70125_A / 180.0f;
        float offset = ((float)player.field_70165_t + (float)player.field_70161_v) / 64.0f;
        this.glass.draw(normYaw + offset, normPitch * 0.875f);
        UtilsClient.disableBlend();
    }

    static enum Style {
        LED;

    }
}

