/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricaldigitaldisplay;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.item.BrushDescriptor;
import mods.eln.item.IConfigurable;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalGateInput;
import mods.eln.sixnode.electricaldigitaldisplay.ElectricalDigitalDisplayDescriptor;
import mods.eln.sixnode.electricaldigitaldisplay.ElectricalDigitalDisplayProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricalDigitalDisplayElement
extends SixNodeElement
implements IConfigurable {
    ElectricalDigitalDisplayDescriptor descriptor;
    public ElectricalDigitalDisplayProcess process = new ElectricalDigitalDisplayProcess(this);
    public NbtElectricalGateInput input = new NbtElectricalGateInput("input");
    public NbtElectricalGateInput strobeIn = new NbtElectricalGateInput("strobe");
    public NbtElectricalGateInput dotsIn = new NbtElectricalGateInput("dots");
    public float current = 0.0f;
    public float last = 0.0f;
    public float min = 0.0f;
    public float max = 1000.0f;
    public float strobe = 0.0f;
    public float strobeLast = 0.0f;
    public float dots = 0.0f;
    public float dotsLast = 0.0f;
    public int dye = 5;

    public ElectricalDigitalDisplayElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.electricalLoadList.add(this.input);
        this.electricalLoadList.add(this.strobeIn);
        this.electricalLoadList.add(this.dotsIn);
        this.slowProcessList.add(this.process);
        this.descriptor = (ElectricalDigitalDisplayDescriptor)descriptor;
    }

    @Override
    public void initialize() {
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull LRDU lrdu, int mask) {
        if (lrdu == this.front) {
            return this.dotsIn;
        }
        if (lrdu == this.front.inverse()) {
            return this.input;
        }
        return this.strobeIn;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull LRDU lrdu, int mask) {
        return null;
    }

    @Override
    public String multiMeterString() {
        return "";
    }

    @Override
    @NotNull
    public String thermoMeterString() {
        return "";
    }

    @Override
    public int getConnectionMask(@NotNull LRDU lrdu) {
        if (lrdu == this.front.inverse()) {
            return 4;
        }
        if (lrdu == this.front) {
            return 720900;
        }
        return 65540;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        Utils.println("EDDE.nU");
        try {
            switch (stream.readByte()) {
                case 1: {
                    this.min = stream.readFloat();
                    this.max = stream.readFloat();
                    Utils.println(String.format("EDDE.nu: nSR %f - %f", Float.valueOf(this.min), Float.valueOf(this.max)));
                    this.needPublish();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeFloat(this.current);
            stream.writeFloat(this.min);
            stream.writeFloat(this.max);
            stream.writeFloat(this.dots);
            stream.writeBoolean((double)this.strobe >= 0.5);
            stream.writeByte(this.dye);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        BrushDescriptor brush;
        int color;
        GenericItemUsingDamageDescriptor desc;
        ItemStack stack = entityPlayer.func_71045_bC();
        if (stack != null && (desc = BrushDescriptor.getDescriptor(stack)) != null && desc instanceof BrushDescriptor && (color = (brush = (BrushDescriptor)desc).getColor(stack)) != this.dye && brush.use(stack, entityPlayer)) {
            this.dye = color;
            this.needPublish();
            return true;
        }
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74776_a("current", this.current);
        nbt.func_74776_a("min", this.min);
        nbt.func_74776_a("max", this.max);
        nbt.func_74774_a("dye", (byte)this.dye);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.current = nbt.func_74760_g("current");
        this.min = nbt.func_74760_g("min");
        this.max = nbt.func_74760_g("max");
        this.dye = nbt.func_74771_c("dye");
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("Input: ", Utils.plotVolt(this.input.getVoltage()));
        info.put("Min: ", String.format("%.2f", Float.valueOf(this.min)));
        info.put("Max: ", String.format("%.2f", Float.valueOf(this.max)));
        return info;
    }

    @Override
    public void readConfigTool(NBTTagCompound compound, EntityPlayer invoker) {
        if (compound.func_74764_b("min")) {
            this.min = compound.func_74760_g("min");
        }
        if (compound.func_74764_b("max")) {
            this.max = compound.func_74760_g("max");
        }
        this.needPublish();
    }

    @Override
    public void writeConfigTool(NBTTagCompound compound, EntityPlayer invoker) {
        compound.func_74776_a("min", this.min);
        compound.func_74776_a("max", this.max);
    }
}

