/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricaldigitaldisplay;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import mods.eln.gui.GuiHelper;
import mods.eln.gui.GuiScreenEln;
import mods.eln.gui.GuiTextFieldEln;
import mods.eln.gui.IGuiObject;
import mods.eln.i18n.I18N;
import mods.eln.misc.Utils;
import mods.eln.sixnode.electricaldigitaldisplay.ElectricalDigitalDisplayRender;
import net.minecraft.client.gui.GuiButton;

public class ElectricalDigitalDisplayGui
extends GuiScreenEln {
    GuiTextFieldEln minValue;
    GuiTextFieldEln maxValue;
    GuiButton validate;
    ElectricalDigitalDisplayRender render;

    public ElectricalDigitalDisplayGui(ElectricalDigitalDisplayRender render) {
        this.render = render;
    }

    @Override
    protected GuiHelper newHelper() {
        return new GuiHelper(this, 169, 44);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.minValue = this.newGuiTextField(8, 24, 70);
        this.minValue.setComment(new String[]{"Display at minimum signal input"});
        this.minValue.func_146180_a(String.format("%.2f", Float.valueOf(this.render.min)));
        this.maxValue = this.newGuiTextField(8, 8, 70);
        this.maxValue.setComment(new String[]{"Display at maximum signal input"});
        this.maxValue.func_146180_a(String.format("%.2f", Float.valueOf(this.render.max)));
        this.validate = this.newGuiButton(82, 12, 80, I18N.tr("Validate", new Object[0]));
        this.validate.field_146124_l = true;
    }

    @Override
    public void guiObjectEvent(IGuiObject object) {
        super.guiObjectEvent(object);
        if (object == this.validate) {
            try {
                NumberFormat fmt = NumberFormat.getInstance();
                float newMin = fmt.parse(this.minValue.func_146179_b()).floatValue();
                float newMax = fmt.parse(this.maxValue.func_146179_b()).floatValue();
                Utils.println(String.format("EDDG sending %f - %f", Float.valueOf(newMin), Float.valueOf(newMax)));
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    DataOutputStream stream = new DataOutputStream(bos);
                    this.render.preparePacketForServer(stream);
                    stream.writeByte(1);
                    stream.writeFloat(newMin);
                    stream.writeFloat(newMax);
                    this.render.sendPacketToServer(bos);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }
}

