/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricaldigitaldisplay;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.electricaldigitaldisplay.ElectricalDigitalDisplayDescriptor;
import mods.eln.sixnode.electricaldigitaldisplay.ElectricalDigitalDisplayGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

public class ElectricalDigitalDisplayRender
extends SixNodeElementRender {
    ElectricalDigitalDisplayDescriptor descriptor;
    public float current = 0.0f;
    public float max = 1000.0f;
    public float min = 0.0f;
    public float dots = 0.0f;
    public boolean strobe = false;
    public ElectricalDigitalDisplayDescriptor.Style style = ElectricalDigitalDisplayDescriptor.Style.LED;
    public int dye;

    public ElectricalDigitalDisplayRender(SixNodeEntity entity, Direction side, SixNodeDescriptor descriptor) {
        super(entity, side, descriptor);
        this.descriptor = (ElectricalDigitalDisplayDescriptor)descriptor;
    }

    @Override
    public CableRenderDescriptor getCableRender(LRDU lrdu) {
        return Eln.instance.stdCableRenderSignal;
    }

    @Override
    public void draw() {
        super.draw();
        this.drawSignalPin(this.front.inverse(), this.descriptor.pinDistance);
        this.descriptor.draw((int)(this.min + this.current * (this.max - this.min)), this.strobe, this.style, this.dye, (int)(this.dots * (float)ElectricalDigitalDisplayDescriptor.DOT_STATES));
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            this.current = stream.readFloat();
            this.min = stream.readFloat();
            this.max = stream.readFloat();
            this.dots = stream.readFloat();
            this.strobe = stream.readBoolean();
            this.dye = stream.readByte();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @Nullable
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new ElectricalDigitalDisplayGui(this);
    }
}

