/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalentitysensor;

import java.util.Collections;
import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.item.EntitySensorFilterDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.electricalentitysensor.ElectricalEntitySensorElement;
import mods.eln.sixnode.electricalentitysensor.ElectricalEntitySensorRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ElectricalEntitySensorDescriptor
extends SixNodeDescriptor {
    boolean useEntitySpeed = true;
    double speedFactor = 10.0;
    private Obj3D.Obj3DPart detector;
    private Obj3D.Obj3DPart haloMask;
    double maxRange;
    public float[] pinDistance;
    Obj3D obj;

    public ElectricalEntitySensorDescriptor(String name, Obj3D obj, double maxRange) {
        super(name, ElectricalEntitySensorElement.class, ElectricalEntitySensorRender.class);
        this.obj = obj;
        this.maxRange = maxRange;
        if (obj != null) {
            this.detector = obj.getPart("Detector");
            this.haloMask = obj.getPart("HaloMask");
            this.pinDistance = Utils.getSixNodePinDistance(this.detector);
        }
        this.voltageLevelColor = VoltageLevelColor.SignalVoltage;
    }

    void draw(boolean state, EntitySensorFilterDescriptor filter) {
        if (this.detector != null) {
            this.detector.draw();
        }
        if (state) {
            if (filter == null) {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)0.0f);
            } else {
                filter.glColor();
            }
            UtilsClient.drawLight(this.haloMask);
        }
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addSignal(this.newItemStack());
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        Collections.addAll(list, I18N.tr("Output voltage increases\nif entities are moving around.", new Object[0]).split("\n"));
        list.add(I18N.tr("Range: %1$ blocks", (int)this.maxRange));
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
            this.draw(false, null);
        }
    }

    @Override
    @Nullable
    public LRDU getFrontFromPlace(@NotNull Direction side, @NotNull EntityPlayer player) {
        return super.getFrontFromPlace(side, player).right();
    }
}

