/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalfiredetector;

import java.util.Collections;
import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sixnode.electricalfiredetector.ElectricalFireDetectorElement;
import mods.eln.sixnode.electricalfiredetector.ElectricalFireDetectorRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ElectricalFireDetectorDescriptor
extends SixNodeDescriptor {
    private Obj3D.Obj3DPart detector;
    private Obj3D.Obj3DPart led;
    boolean batteryPowered;
    double maxRange;
    public float[] pinDistance;
    final double updateInterval = 0.5;
    static final double PowerComsumption = 0.1388888888888889;

    public ElectricalFireDetectorDescriptor(String name, Obj3D obj, double maxRange, boolean batteryPowered) {
        super(name, ElectricalFireDetectorElement.class, ElectricalFireDetectorRender.class);
        this.batteryPowered = batteryPowered;
        this.maxRange = maxRange;
        if (obj != null) {
            this.detector = obj.getPart("Detector");
            this.led = obj.getPart("Led");
            this.pinDistance = Utils.getSixNodePinDistance(this.detector);
        }
        this.voltageLevelColor = batteryPowered ? VoltageLevelColor.Neutral : VoltageLevelColor.SignalVoltage;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addSignal(this.newItemStack());
    }

    void draw(boolean firePresent) {
        if (this.detector != null) {
            this.detector.draw();
        }
        if (this.led != null) {
            if (firePresent) {
                UtilsClient.drawLight(this.led);
            } else {
                GL11.glColor3f((float)0.5f, (float)0.5f, (float)0.5f);
                this.led.draw();
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        if (this.batteryPowered) {
            Collections.addAll(list, I18N.tr("Battery powered buzzer \nactivated in presence of fire.", new Object[0]).split("\n"));
        } else {
            Collections.addAll(list, I18N.tr("Output voltage increases\nif a fire has been detected.", new Object[0]).split("\n"));
        }
        list.add(I18N.tr("Range: %1$ blocks", (int)this.maxRange));
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
            this.draw(false);
        }
    }

    @Override
    @Nullable
    public LRDU getFrontFromPlace(@NotNull Direction side, @NotNull EntityPlayer player) {
        return super.getFrontFromPlace(side, player).right();
    }
}

